/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.services;

import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.services.NodeService;
import org.fcrepo.services.ServiceHelpers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={ServiceHelpers.class})
public class NodeServiceTest {
    private Session mockSession;
    private Node mockRoot;
    private NodeService testObj;

    @Before
    public void setUp() throws RepositoryException {
        this.testObj = new NodeService();
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.mockRoot = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetObjectNames() throws RepositoryException {
        Session session = (Session)Mockito.mock(Session.class);
        Node node = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node2.getName()).thenReturn((Object)"foo");
        Mockito.when((Object)node2.isNodeType("nt:folder")).thenReturn((Object)true);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)node2).thenThrow(new Class[]{IndexOutOfBoundsException.class});
        Mockito.when((Object)node.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.when((Object)session.getNode("")).thenReturn((Object)node);
        Set set = this.testObj.getObjectNames(session, "");
        ((Session)Mockito.verify((Object)session)).getNode("");
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertEquals((Object)"foo", set.iterator().next());
    }

    @Test
    public void testDeleteOBject() throws RepositoryException {
        Session session = (Session)Mockito.mock(Session.class);
        Node node = (Node)Mockito.mock(Node.class);
        Node node2 = (Node)Mockito.mock(Node.class);
        Mockito.mock(Property.class);
        Node node3 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)session.getRootNode()).thenReturn((Object)node);
        Mockito.when((Object)node.getNode("objects")).thenReturn((Object)node2);
        Mockito.when((Object)session.getNode("foo")).thenReturn((Object)node3);
        PowerMockito.mockStatic(ServiceHelpers.class, (Class[])new Class[0]);
        this.testObj.deleteObject(session, "foo");
        ((Session)Mockito.verify((Object)session)).getNode("foo");
        ((Node)Mockito.verify((Object)node3)).remove();
    }
}

