/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.services;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.services.ObjectService;
import org.fcrepo.services.ServiceHelpers;
import org.fcrepo.utils.FedoraJcrTypes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={ServiceHelpers.class})
public class ObjectServiceTest
implements FedoraJcrTypes {
    private Session mockSession;
    private Node mockRoot;

    @Before
    public void setUp() throws RepositoryException {
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.mockRoot = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCreateObject() throws Exception {
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.mockRoot.getNode("/foo".substring(1))).thenReturn((Object)node);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"fedora:object");
        Mockito.when((Object)node.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{nodeType});
        ObjectService objectService = new ObjectService();
        Node node2 = objectService.createObject(this.mockSession, "/foo").getNode();
        Assert.assertEquals((Object)node, (Object)node2);
    }

    @Test
    public void testGetObject() throws RepositoryException {
        Session session = (Session)Mockito.mock(Session.class);
        Node node = (Node)Mockito.mock(Node.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"fedora:object");
        Mockito.when((Object)node.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{nodeType});
        Mockito.when((Object)session.getNode("/foo")).thenReturn((Object)node);
        ObjectService objectService = new ObjectService();
        objectService.getObject(session, "/foo");
        ((Session)Mockito.verify((Object)session)).getNode("/foo");
    }

    @Test
    public void testGetObjectNode() throws RepositoryException {
        Session session = (Session)Mockito.mock(Session.class);
        ObjectService objectService = new ObjectService();
        objectService.getObjectNode(session, "/foo");
        ((Session)Mockito.verify((Object)session)).getNode("/foo");
    }
}

