/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.services;

import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.fcrepo.rdf.GraphSubjects;
import org.fcrepo.services.RepositoryService;
import org.fcrepo.utils.FedoraJcrTypes;
import org.fcrepo.utils.FedoraTypesUtils;
import org.fcrepo.utils.JcrRdfTools;
import org.fcrepo.utils.NamespaceTools;
import org.fcrepo.utils.NodeIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "org.apache.xerces.*", "javax.xml.*", "org.xml.sax.*", "javax.management.*"})
@PrepareForTest(value={NamespaceTools.class, JcrRdfTools.class, FedoraTypesUtils.class})
public class RepositoryServiceTest
implements FedoraJcrTypes {
    String testPid = "testObj";
    String testDsId = "testDs";
    String mockPrefix = "mock1";
    RepositoryService testObj;
    Repository mockRepo;
    Session mockSession;
    Node mockRootNode;
    Node mockDsNode;
    Long expectedSize = 5L;
    Long expectedCount = 0L;
    NodeTypeIterator mockNTI;
    Map<String, String> expectedNS;

    @Before
    public void setUp() {
        String string = "/" + this.testPid + "/" + this.testDsId;
        String[] stringArray = new String[]{this.mockPrefix};
        this.expectedNS = new HashMap<String, String>();
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.mockRootNode = (Node)Mockito.mock(Node.class);
        this.mockDsNode = (Node)Mockito.mock(Node.class);
        this.mockRepo = (Repository)Mockito.mock(Repository.class);
        javax.jcr.NodeIterator nodeIterator = (javax.jcr.NodeIterator)Mockito.mock(javax.jcr.NodeIterator.class);
        Property property = (Property)Mockito.mock(Property.class);
        try {
            Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRootNode);
            Mockito.when((Object)this.mockRootNode.getNode(string)).thenReturn((Object)this.mockDsNode);
            Mockito.when((Object)this.mockRootNode.getProperty("fedora:size")).thenReturn((Object)property);
            Mockito.when((Object)property.getLong()).thenReturn((Object)this.expectedSize);
            Mockito.when((Object)this.mockRepo.login()).thenReturn((Object)this.mockSession);
            Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
            QueryManager queryManager = (QueryManager)Mockito.mock(QueryManager.class);
            QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
            Query query = (Query)Mockito.mock(Query.class);
            RowIterator rowIterator = (RowIterator)Mockito.mock(RowIterator.class);
            Value value = (Value)Mockito.mock(Value.class);
            Row row = (Row)Mockito.mock(Row.class);
            NodeTypeManager nodeTypeManager = (NodeTypeManager)Mockito.mock(NodeTypeManager.class);
            NamespaceRegistry namespaceRegistry = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
            this.mockNTI = (NodeTypeIterator)Mockito.mock(NodeTypeIterator.class);
            this.testObj = new RepositoryService();
            this.testObj.setRepository(this.mockRepo);
            Mockito.when((Object)this.mockSession.getNode("/objects")).thenReturn((Object)this.mockRootNode);
            Mockito.when((Object)this.mockRootNode.getNodes()).thenReturn((Object)nodeIterator);
            Mockito.when((Object)nodeIterator.getSize()).thenReturn((Object)this.expectedSize);
            Mockito.when((Object)this.testObj.findOrCreateNode(this.mockSession, "/objects")).thenReturn((Object)this.mockRootNode);
            Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)workspace);
            Mockito.when((Object)workspace.getQueryManager()).thenReturn((Object)queryManager);
            Mockito.when((Object)workspace.getNodeTypeManager()).thenReturn((Object)nodeTypeManager);
            Mockito.when((Object)workspace.getNamespaceRegistry()).thenReturn((Object)namespaceRegistry);
            Mockito.when((Object)namespaceRegistry.getPrefixes()).thenReturn((Object)stringArray);
            Mockito.when((Object)nodeTypeManager.getAllNodeTypes()).thenReturn((Object)this.mockNTI);
            Mockito.when((Object)queryManager.createQuery(Matchers.anyString(), (String)Matchers.eq((Object)"JCR-SQL2"))).thenReturn((Object)query);
            Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
            Mockito.when((Object)queryResult.getRows()).thenReturn((Object)rowIterator);
            Mockito.when((Object)rowIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when((Object)rowIterator.nextRow()).thenReturn((Object)row);
            Mockito.when((Object)row.getValue("fedora:size")).thenReturn((Object)value);
            Mockito.when((Object)value.getLong()).thenReturn((Object)this.expectedSize);
            this.expectedNS.put(this.mockPrefix, namespaceRegistry.getURI(this.mockPrefix));
        }
        catch (RepositoryException repositoryException) {
            repositoryException.printStackTrace();
            Assert.fail((String)repositoryException.getMessage());
        }
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetRepositorySize() throws RepositoryException {
        Long l = this.testObj.getRepositorySize();
        Assert.assertEquals((Object)this.expectedSize, (Object)l);
    }

    @Test
    public void testGetRepositoryObjectCount() {
        Long l = this.testObj.getRepositoryObjectCount();
        Assert.assertEquals((Object)this.expectedCount, (Object)l);
    }

    @Test
    public void testGetAllNodeTypes() throws RepositoryException {
        NodeTypeIterator nodeTypeIterator = this.testObj.getAllNodeTypes(this.mockSession);
        Assert.assertEquals((Object)this.mockNTI, (Object)nodeTypeIterator);
    }

    @Test
    public void testGetRepositoryNamespaces() throws RepositoryException {
        Map map = RepositoryService.getRepositoryNamespaces((Session)this.mockSession);
        Assert.assertEquals(this.expectedNS, (Object)map);
    }

    @Test
    public void testExists() throws RepositoryException {
        Mockito.when((Object)this.mockSession.nodeExists("/foo/bar/exists")).thenReturn((Object)true);
        Assert.assertEquals((Object)true, (Object)this.testObj.exists(this.mockSession, "/foo/bar/exists"));
        Assert.assertEquals((Object)false, (Object)this.testObj.exists(this.mockSession, "/foo/bar"));
    }

    @Test
    public void testSearchRepository() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Resource resource = ResourceFactory.createResource((String)"info:fedora/search/request");
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        QueryManager queryManager = (QueryManager)Mockito.mock(QueryManager.class);
        QueryObjectModelFactory queryObjectModelFactory = (QueryObjectModelFactory)Mockito.mock(QueryObjectModelFactory.class);
        QueryObjectModel queryObjectModel = (QueryObjectModel)Mockito.mock(QueryObjectModel.class);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        javax.jcr.NodeIterator nodeIterator = (javax.jcr.NodeIterator)Mockito.mock(javax.jcr.NodeIterator.class);
        GraphSubjects graphSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        ValueFactory valueFactory = (ValueFactory)Mockito.mock(ValueFactory.class);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)valueFactory);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)workspace.getQueryManager()).thenReturn((Object)queryManager);
        Mockito.when((Object)queryManager.getQOMFactory()).thenReturn((Object)queryObjectModelFactory);
        Mockito.when((Object)queryObjectModelFactory.createQuery(null, null, null, null)).thenReturn((Object)queryObjectModel);
        Mockito.when((Object)queryObjectModel.execute()).thenReturn((Object)queryResult);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.when((Object)nodeIterator.getSize()).thenReturn((Object)500L);
        Mockito.when((Object)nodeIterator.next()).thenReturn((Object)"");
        Mockito.when((Object)JcrRdfTools.getJcrNodeIteratorModel((GraphSubjects)((GraphSubjects)Matchers.eq((Object)graphSubjects)), (Iterator)((Iterator)Matchers.any(NodeIterator.class)), (Resource)((Resource)Matchers.eq((Object)resource)))).thenReturn((Object)ModelFactory.createDefaultModel());
        this.testObj.searchRepository(graphSubjects, resource, this.mockSession, "search terms", 10, 0L);
        ((QueryObjectModel)Mockito.verify((Object)queryObjectModel)).setLimit(11L);
        ((QueryObjectModel)Mockito.verify((Object)queryObjectModel)).setOffset(0L);
        ((QueryObjectModel)Mockito.verify((Object)queryObjectModel)).execute();
    }
}

