/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.services;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.Transaction;
import org.fcrepo.exception.TransactionMissingException;
import org.fcrepo.services.TransactionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TransactionServiceTest {
    private static final String IS_A_TX = "foo";
    private static final String NOT_A_TX = "bar";
    TransactionService service;
    Session mockSession;
    Transaction mockTx;

    @Before
    public void setup() throws Exception {
        this.service = new TransactionService();
        this.mockTx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.mockTx.getId()).thenReturn((Object)IS_A_TX);
        Field field = TransactionService.class.getDeclaredField("TRANSACTIONS");
        field.setAccessible(true);
        Map map = (Map)field.get(TransactionService.class);
        map.put(IS_A_TX, this.mockTx);
    }

    @Test
    public void testExpiration() throws Exception {
        Date date = new Date(System.currentTimeMillis() - 5000L);
        Mockito.when((Object)this.mockTx.getExpires()).thenReturn((Object)date);
        this.service.removeAndRollbackExpired();
        ((Transaction)Mockito.verify((Object)this.mockTx)).rollback();
    }

    @Test
    public void testExpirationThrowsRepositoryException() throws Exception {
        Date date = new Date(System.currentTimeMillis() - 5000L);
        ((Transaction)Mockito.doThrow((Throwable)new RepositoryException("")).when((Object)this.mockTx)).rollback();
        Mockito.when((Object)this.mockTx.getExpires()).thenReturn((Object)date);
        this.service.removeAndRollbackExpired();
    }

    @Test
    public void testCreateTx() throws Exception {
        Transaction transaction = this.service.beginTransaction(null);
        Assert.assertNotNull((Object)transaction);
        Assert.assertNotNull((Object)transaction.getCreated());
        Assert.assertNotNull((Object)transaction.getId());
        Assert.assertEquals((Object)Transaction.State.NEW, (Object)transaction.getState());
    }

    @Test
    public void testGetTx() throws Exception {
        Transaction transaction = this.service.getTransaction(IS_A_TX);
        Assert.assertNotNull((Object)transaction);
    }

    @Test(expected=RepositoryException.class)
    public void testGetNonTx() throws TransactionMissingException {
        this.service.getTransaction(NOT_A_TX);
    }

    @Test
    public void testExists() throws Exception {
        Assert.assertTrue((boolean)this.service.exists(IS_A_TX));
        Assert.assertFalse((boolean)this.service.exists(NOT_A_TX));
    }

    @Test
    public void testCommitTx() throws Exception {
        Transaction transaction = this.service.commit(IS_A_TX);
        Assert.assertNotNull((Object)transaction);
        ((Transaction)Mockito.verify((Object)this.mockTx)).commit();
    }

    @Test(expected=RepositoryException.class)
    public void testCommitRemovedTransaction() throws Exception {
        Transaction transaction = this.service.commit(IS_A_TX);
        this.service.getTransaction(transaction.getId());
    }

    @Test
    public void testRollbackTx() throws Exception {
        Transaction transaction = this.service.rollback(IS_A_TX);
        Assert.assertNotNull((Object)transaction);
        ((Transaction)Mockito.verify((Object)this.mockTx)).rollback();
    }

    @Test(expected=RepositoryException.class)
    public void testRollbackRemovedTransaction() throws Exception {
        Transaction transaction = this.service.rollback(IS_A_TX);
        this.service.getTransaction(transaction.getId());
    }

    @Test(expected=RepositoryException.class)
    public void testRollbackWithNonTx() throws RepositoryException {
        this.service.rollback(NOT_A_TX);
    }

    @Test(expected=RepositoryException.class)
    public void testCommitWithNonTx() throws RepositoryException {
        this.service.commit(NOT_A_TX);
    }
}

