/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.services.functions;

import com.google.common.base.Function;
import java.lang.reflect.Field;
import org.fcrepo.services.functions.CacheLocalTransform;
import org.fcrepo.services.functions.GetCacheStore;
import org.fcrepo.utils.impl.CacheStoreEntry;
import org.infinispan.Cache;
import org.infinispan.CacheImpl;
import org.infinispan.loaders.CacheStore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.modeshape.jcr.value.BinaryKey;

public class CacheLocalTransformTest {
    @Test
    public void testTransform() throws Exception {
        GetCacheStore getCacheStore = (GetCacheStore)Mockito.mock(GetCacheStore.class);
        Field field = CacheLocalTransform.class.getDeclaredField("TRANSFORM");
        field.setAccessible(true);
        field.set(CacheLocalTransform.class, getCacheStore);
        CacheStore cacheStore = (CacheStore)Mockito.mock(CacheStore.class);
        Mockito.when((Object)getCacheStore.apply((Cache)Matchers.any(Cache.class))).thenReturn((Object)cacheStore);
        BinaryKey binaryKey = new BinaryKey("key-123");
        Function function = (Function)Mockito.mock(Function.class);
        CacheLocalTransform cacheLocalTransform = new CacheLocalTransform(binaryKey, function);
        CacheImpl cacheImpl = (CacheImpl)Mockito.mock(CacheImpl.class);
        Mockito.when((Object)cacheImpl.getName()).thenReturn((Object)"foo");
        cacheLocalTransform.setEnvironment((Cache)cacheImpl, null);
        cacheLocalTransform.call();
        ((Function)Mockito.verify((Object)function)).apply(Matchers.eq((Object)new CacheStoreEntry(cacheStore, "foo", binaryKey)));
    }
}

