/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.services.functions;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.jcr.Repository;
import org.fcrepo.services.functions.GetClusterConfiguration;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.modeshape.jcr.GetBinaryStore;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;

public class GetClusterConfigurationTest {
    private GetClusterConfiguration testObj;
    private GetBinaryStore mockGetBinaryStore;

    @Before
    public void setUp() throws Exception {
        this.testObj = new GetClusterConfiguration();
        Field field = GetClusterConfiguration.class.getDeclaredField("getBinaryStore");
        field.setAccessible(true);
        this.mockGetBinaryStore = (GetBinaryStore)Mockito.mock(GetBinaryStore.class);
        field.set(this.testObj, this.mockGetBinaryStore);
    }

    @Test
    public void testGood() throws Exception {
        JcrRepository jcrRepository = (JcrRepository)Mockito.mock(JcrRepository.class);
        RepositoryConfiguration repositoryConfiguration = (RepositoryConfiguration)Mockito.mock(RepositoryConfiguration.class);
        Mockito.when((Object)jcrRepository.getConfiguration()).thenReturn((Object)repositoryConfiguration);
        RepositoryConfiguration.BinaryStorage binaryStorage = (RepositoryConfiguration.BinaryStorage)Mockito.mock(RepositoryConfiguration.BinaryStorage.class);
        Mockito.when((Object)repositoryConfiguration.getBinaryStorage()).thenReturn((Object)binaryStorage);
        InfinispanBinaryStore infinispanBinaryStore = (InfinispanBinaryStore)Mockito.mock(InfinispanBinaryStore.class);
        Mockito.when((Object)this.mockGetBinaryStore.apply((Repository)Matchers.any(Repository.class))).thenReturn((Object)infinispanBinaryStore);
        Cache cache = (Cache)Mockito.mock(Cache.class);
        List<Cache> list = Arrays.asList(cache);
        Mockito.when((Object)infinispanBinaryStore.getCaches()).thenReturn(list);
        DefaultCacheManager defaultCacheManager = (DefaultCacheManager)Mockito.mock(DefaultCacheManager.class);
        Mockito.when((Object)defaultCacheManager.getCache()).thenReturn((Object)cache);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)cache.getCacheConfiguration()).thenReturn((Object)configuration);
        ClusteringConfiguration clusteringConfiguration = (ClusteringConfiguration)Mockito.mock(ClusteringConfiguration.class);
        Mockito.when((Object)configuration.clustering()).thenReturn((Object)clusteringConfiguration);
        Mockito.when((Object)clusteringConfiguration.cacheMode()).thenReturn((Object)CacheMode.LOCAL);
        Mockito.when((Object)cache.getCacheManager()).thenReturn((Object)defaultCacheManager);
        Map map = this.testObj.apply((Repository)jcrRepository);
        Assert.assertNotNull((Object)map);
        Assert.assertFalse((boolean)map.isEmpty());
    }

    @Test
    public void testBad() {
        JcrRepository jcrRepository = (JcrRepository)Mockito.mock(JcrRepository.class);
        Map map = this.testObj.apply((Repository)jcrRepository);
        Assert.assertTrue((boolean)map.isEmpty());
    }
}

