/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.spring;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.fcrepo.services.ObjectService;
import org.fcrepo.spring.ModeShapeRepositoryFactoryBean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrRepositoryFactory;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.api.Repository;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.core.io.Resource;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={ObjectService.class})
public class ModeShapeRepositoryFactoryBeanTest {
    private ModeShapeRepositoryFactoryBean testObj;
    private Resource mockConfig;
    private JcrRepository mockRepo;
    private JcrRepositoryFactory mockRepos;

    @Before
    public void setUp() throws RepositoryException, IOException {
        this.mockConfig = (Resource)Mockito.mock(Resource.class);
        this.mockRepos = (JcrRepositoryFactory)Mockito.mock(JcrRepositoryFactory.class);
        this.mockRepo = (JcrRepository)Mockito.mock(JcrRepository.class);
        JcrSession jcrSession = (JcrSession)Mockito.mock(JcrSession.class);
        Mockito.when((Object)this.mockRepo.login()).thenReturn((Object)jcrSession);
        this.testObj = new ModeShapeRepositoryFactoryBean();
        this.testObj.setRepositoryConfiguration(this.mockConfig);
        Mockito.when((Object)this.mockRepos.getRepository((Map)Matchers.any(Map.class))).thenReturn((Object)this.mockRepo);
        ModeShapeRepositoryFactoryBeanTest.inject("jcrRepositoryFactory", this.mockRepos, this.testObj);
    }

    @Test
    public void testFactory() throws RepositoryException, IOException {
        this.testObj.buildRepository();
        Assert.assertEquals((Object)this.mockRepo, (Object)this.testObj.getObject());
    }

    @Test
    public void testFactoryMetadata() {
        Assert.assertEquals(Repository.class, (Object)this.testObj.getObjectType());
        Assert.assertEquals((Object)true, (Object)this.testObj.isSingleton());
    }

    private static void inject(String string, Object object, Object object2) {
        try {
            Field field = ModeShapeRepositoryFactoryBean.class.getDeclaredField(string);
            if (!field.isAnnotationPresent(Inject.class)) {
                System.err.println("WARNING: test sets ModeShapeRepositoryFactoryBean." + string + ", which is not annotated as an @Inject");
            }
            field.setAccessible(true);
            field.set(object2, object);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

