/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utils;

import com.google.common.base.Predicate;
import java.io.InputStream;
import java.util.Calendar;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.fcrepo.utils.FedoraTypesUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.api.Namespaced;

public class FedoraTypesUtilsTest {
    @Test
    public void testIsMultipleValuedProperty() throws RepositoryException {
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.isMultiple()).thenReturn((Object)true);
        Property property2 = (Property)Mockito.mock(Property.class);
        Predicate predicate = FedoraTypesUtils.isMultipleValuedProperty;
        try {
            predicate.apply(null);
            Assert.fail((String)"Null values should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        boolean bl = predicate.apply((Object)property);
        Assert.assertEquals((Object)true, (Object)bl);
        bl = predicate.apply((Object)property2);
        Assert.assertEquals((Object)false, (Object)bl);
    }

    @Test
    public void testGetValueFactory() throws RepositoryException {
        Node node = (Node)Mockito.mock(Node.class);
        Session session = (Session)Mockito.mock(Session.class);
        ValueFactory valueFactory = (ValueFactory)Mockito.mock(ValueFactory.class);
        Mockito.when((Object)node.getSession()).thenReturn((Object)session);
        Mockito.when((Object)session.getValueFactory()).thenReturn((Object)valueFactory);
        ValueFactory valueFactory2 = (ValueFactory)FedoraTypesUtils.getValueFactory.apply((Object)node);
        Assert.assertEquals((Object)valueFactory, (Object)valueFactory2);
    }

    @Test
    public void testGetPredicateForProperty() {
        PropertyMock propertyMock = (PropertyMock)Mockito.mock(PropertyMock.class);
        FedoraTypesUtils.getPredicateForProperty.apply((Object)propertyMock);
    }

    @Test
    public void testGetBinary() throws RepositoryException {
        Node node = (Node)Mockito.mock(Node.class);
        Session session = (Session)Mockito.mock(Session.class);
        ValueFactory valueFactory = (ValueFactory)Mockito.mock(ValueFactory.class);
        Mockito.when((Object)node.getSession()).thenReturn((Object)session);
        Mockito.when((Object)session.getValueFactory()).thenReturn((Object)valueFactory);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        FedoraTypesUtils.getBinary((Node)node, (InputStream)inputStream);
        ((ValueFactory)Mockito.verify((Object)valueFactory)).createBinary(inputStream);
        JcrValueFactory jcrValueFactory = (JcrValueFactory)Mockito.mock(JcrValueFactory.class);
        Mockito.when((Object)session.getValueFactory()).thenReturn((Object)jcrValueFactory);
        FedoraTypesUtils.getBinary((Node)node, (InputStream)inputStream, (String)"storage-hint");
        ((JcrValueFactory)Mockito.verify((Object)jcrValueFactory)).createBinary(inputStream, "storage-hint");
    }

    @Test
    public void testGetDefinitionForPropertyName() throws RepositoryException {
        Node node = (Node)Mockito.mock(Node.class);
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)node.getSession()).thenReturn((Object)session);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        NodeTypeManager nodeTypeManager = (NodeTypeManager)Mockito.mock(NodeTypeManager.class);
        Mockito.when((Object)workspace.getNodeTypeManager()).thenReturn((Object)nodeTypeManager);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)nodeTypeManager.getNodeType(Matchers.anyString())).thenReturn((Object)nodeType);
        PropertyDefinition propertyDefinition = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)propertyDefinition.getName()).thenReturn((Object)"mock:property");
        PropertyDefinition[] propertyDefinitionArray = new PropertyDefinition[]{propertyDefinition};
        Mockito.when((Object)nodeType.getPropertyDefinitions()).thenReturn((Object)propertyDefinitionArray);
        PropertyDefinition propertyDefinition2 = FedoraTypesUtils.getDefinitionForPropertyName((Node)node, (String)"mock:property");
        Assert.assertEquals((Object)propertyDefinition, (Object)propertyDefinition2);
        propertyDefinition2 = FedoraTypesUtils.getDefinitionForPropertyName((Node)node, (String)"mock:property:fail");
        Assert.assertEquals(null, (Object)propertyDefinition2);
    }

    @Test
    public void testConvertDateToXSDString() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(2006, 10, 13, 9, 40, 55);
        calendar.set(14, 1);
        Assert.assertEquals((Object)"2006-11-13T09:40:55.001Z", (Object)FedoraTypesUtils.convertDateToXSDString((long)calendar.getTimeInMillis()));
    }

    @Test
    public void testGetBaseVersionForNode() throws RepositoryException {
        Version version = (Version)Mockito.mock(Version.class);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/my/path");
        Mockito.when((Object)node.getSession()).thenReturn(Mockito.mock(Session.class));
        Mockito.when((Object)node.getSession().getWorkspace()).thenReturn(Mockito.mock(Workspace.class));
        Mockito.when((Object)node.getSession().getWorkspace().getVersionManager()).thenReturn(Mockito.mock(VersionManager.class));
        Mockito.when((Object)node.getSession().getWorkspace().getVersionManager().getBaseVersion("/my/path")).thenReturn((Object)version);
        Version version2 = FedoraTypesUtils.getBaseVersion((Node)node);
        Assert.assertEquals((Object)version, (Object)version2);
    }

    @Test
    public void testGetVersionHistoryForNode() throws RepositoryException {
        VersionHistory versionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/my/path");
        Mockito.when((Object)node.getSession()).thenReturn(Mockito.mock(Session.class));
        Mockito.when((Object)node.getSession().getWorkspace()).thenReturn(Mockito.mock(Workspace.class));
        Mockito.when((Object)node.getSession().getWorkspace().getVersionManager()).thenReturn(Mockito.mock(VersionManager.class));
        Mockito.when((Object)node.getSession().getWorkspace().getVersionManager().getVersionHistory("/my/path")).thenReturn((Object)versionHistory);
        VersionHistory versionHistory2 = FedoraTypesUtils.getVersionHistory((Node)node);
        Assert.assertEquals((Object)versionHistory, (Object)versionHistory2);
    }

    @Test
    public void testGetVersionHistoryForSessionAndPath() throws RepositoryException {
        VersionHistory versionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Session session = (Session)Mockito.mock(Session.class);
        Mockito.when((Object)session.getWorkspace()).thenReturn(Mockito.mock(Workspace.class));
        Mockito.when((Object)session.getWorkspace().getVersionManager()).thenReturn(Mockito.mock(VersionManager.class));
        Mockito.when((Object)session.getWorkspace().getVersionManager().getVersionHistory("/my/path")).thenReturn((Object)versionHistory);
        VersionHistory versionHistory2 = FedoraTypesUtils.getVersionHistory((Session)session, (String)"/my/path");
        Assert.assertEquals((Object)versionHistory, (Object)versionHistory2);
    }

    @Test
    public void testInternalNode() throws RepositoryException {
        Node node = (Node)Mockito.mock(Node.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)node.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)nodeType.isNodeType("mode:system")).thenReturn((Object)true);
        Assert.assertTrue((String)"mode:system nodes should be treated as internal nodes", (boolean)FedoraTypesUtils.isInternalNode.apply((Object)node));
    }

    @Test
    public void testNonInternalNode() throws RepositoryException {
        Node node = (Node)Mockito.mock(Node.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)node.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)nodeType.isNodeType("mode:system")).thenReturn((Object)false);
        Assert.assertFalse((String)"nodes that are not mode:system types should not be treated as internal nodes", (boolean)FedoraTypesUtils.isInternalNode.apply((Object)node));
    }

    @Test
    public void testGetObjectSize() throws RepositoryException {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Session session = (Session)Mockito.mock(Session.class);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        QueryManager queryManager = (QueryManager)Mockito.mock(QueryManager.class);
        Query query = (Query)Mockito.mock(Query.class);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        RowIterator rowIterator = (RowIterator)Mockito.mock(RowIterator.class);
        Row row = (Row)Mockito.mock(Row.class);
        Value value = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)repository.login()).thenReturn((Object)session);
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)workspace.getQueryManager()).thenReturn((Object)queryManager);
        Mockito.when((Object)queryManager.createQuery("SELECT [fedora:size] FROM [fedora:binary]", "JCR-SQL2")).thenReturn((Object)query);
        Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        Mockito.when((Object)queryResult.getRows()).thenReturn((Object)rowIterator);
        Mockito.when((Object)rowIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)rowIterator.nextRow()).thenReturn((Object)row, (Object[])new Row[]{row, row});
        Mockito.when((Object)row.getValue("fedora:size")).thenReturn((Object)value);
        Mockito.when((Object)value.getLong()).thenReturn((Object)5L, (Object[])new Long[]{10L, 1L});
        long l = FedoraTypesUtils.getRepositorySize((Repository)repository);
        Assert.assertTrue((l == 16L ? 1 : 0) != 0);
        ((Session)Mockito.verify((Object)session)).logout();
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.never())).save();
    }

    @Test
    public void testGetObjectCount() throws RepositoryException {
        Repository repository = (Repository)Mockito.mock(Repository.class);
        Session session = (Session)Mockito.mock(Session.class);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        QueryManager queryManager = (QueryManager)Mockito.mock(QueryManager.class);
        Query query = (Query)Mockito.mock(Query.class);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        RowIterator rowIterator = (RowIterator)Mockito.mock(RowIterator.class);
        Mockito.when((Object)repository.login()).thenReturn((Object)session);
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)workspace.getQueryManager()).thenReturn((Object)queryManager);
        Mockito.when((Object)queryManager.createQuery("SELECT [jcr:path] FROM [fedora:object]", "JCR-SQL2")).thenReturn((Object)query);
        Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        Mockito.when((Object)queryResult.getRows()).thenReturn((Object)rowIterator);
        Mockito.when((Object)rowIterator.getSize()).thenReturn((Object)3L);
        long l = FedoraTypesUtils.getRepositoryCount((Repository)repository);
        Assert.assertTrue((l == 3L ? 1 : 0) != 0);
        ((Session)Mockito.verify((Object)session)).logout();
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.never())).save();
    }

    static interface PropertyMock
    extends Property,
    Namespaced {
    }
}

