/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utils;

import java.net.URI;
import org.fcrepo.utils.FixityResult;
import org.junit.Assert;
import org.junit.Test;

public class FixityResultTest {
    @Test
    public void testEquals() throws Exception {
        Assert.assertEquals((Object)new FixityResult(100L, new URI("urn:123")), (Object)new FixityResult(100L, new URI("urn:123")));
        Assert.assertNotEquals((Object)new FixityResult(99L, new URI("urn:123")), (Object)new FixityResult(100L, new URI("urn:123")));
        Assert.assertNotEquals((Object)new FixityResult(100L, new URI("urn:321")), (Object)new FixityResult(100L, new URI("urn:123")));
        Assert.assertNotEquals((Object)new FixityResult(99L, new URI("urn:321")), (Object)new FixityResult(100L, new URI("urn:123")));
    }

    @Test
    public void testHashCode() throws Exception {
        Assert.assertEquals((long)new FixityResult(100L, new URI("urn:123")).hashCode(), (long)new FixityResult(100L, new URI("urn:123")).hashCode());
        Assert.assertNotEquals((long)new FixityResult(99L, new URI("urn:123")).hashCode(), (long)new FixityResult(100L, new URI("urn:123")).hashCode());
        Assert.assertNotEquals((long)new FixityResult(100L, new URI("urn:321")).hashCode(), (long)new FixityResult(100L, new URI("urn:123")).hashCode());
        Assert.assertNotEquals((long)new FixityResult(99L, new URI("urn:321")).hashCode(), (long)new FixityResult(100L, new URI("urn:123")).hashCode());
    }

    @Test
    public void testIsSuccess() throws Exception {
        FixityResult fixityResult = new FixityResult(100L, new URI("urn:123"));
        fixityResult.status.add(FixityResult.FixityState.SUCCESS);
        Assert.assertTrue((String)"expected fixity to be a success", (boolean)fixityResult.isSuccess());
        fixityResult = new FixityResult(100L, new URI("urn:123"));
        Assert.assertFalse((String)"expected fixity to not be a success", (boolean)fixityResult.isSuccess());
    }

    @Test
    public void testMatchesArguments() throws Exception {
        FixityResult fixityResult = new FixityResult(100L, new URI("urn:123"));
        Assert.assertTrue((String)"expected fixity to match", (boolean)fixityResult.matches(100L, new URI("urn:123")));
        Assert.assertFalse((String)"unexpected match when size differs", (boolean)fixityResult.matches(99L, new URI("urn:123")));
        Assert.assertFalse((String)"unexpected match when checksum differs", (boolean)fixityResult.matches(100L, new URI("urn:312")));
        Assert.assertFalse((String)"unexpected match when size and checksum differs", (boolean)fixityResult.matches(99L, new URI("urn:312")));
    }
}

