/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utils;

import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.rdf.GraphSubjects;
import org.fcrepo.utils.JcrPropertyStatementListener;
import org.fcrepo.utils.JcrRdfTools;
import org.fcrepo.utils.NodePropertiesTools;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={JcrRdfTools.class, NodePropertiesTools.class})
public class JcrPropertyStatementListenerTest {
    private JcrPropertyStatementListener testObj;
    private Node mockNode;
    private Session mockSession;
    private GraphSubjects mockSubjects;
    private Statement mockStatement;
    private Resource mockSubject;
    private Property mockPredicate;

    @Before
    public void setUp() throws RepositoryException {
        this.mockNode = (Node)Mockito.mock(Node.class);
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.mockSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        this.testObj = new JcrPropertyStatementListener(this.mockSubjects, this.mockSession);
        this.mockSubject = (Resource)Mockito.mock(Resource.class);
        this.mockStatement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)this.mockStatement.getSubject()).thenReturn((Object)this.mockSubject);
        this.mockPredicate = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)this.mockStatement.getPredicate()).thenReturn((Object)this.mockPredicate);
    }

    @Test
    public void testAddedIrrelevantStatement() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)JcrRdfTools.isFedoraGraphSubject((GraphSubjects)this.mockSubjects, (Resource)this.mockSubject)).thenReturn((Object)false);
        this.testObj.addedStatement(this.mockStatement);
        PowerMockito.verifyStatic((VerificationMode)Mockito.never());
        JcrRdfTools.getNodeFromGraphSubject((GraphSubjects)((GraphSubjects)Matchers.any(GraphSubjects.class)), (Session)((Session)Matchers.any(Session.class)), (Resource)((Resource)Matchers.any(Resource.class)));
        Assert.assertEquals((long)0L, (long)this.testObj.getProblems().size());
    }

    @Test
    public void testAddedProhibitedStatement() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)JcrRdfTools.isFedoraGraphSubject((GraphSubjects)this.mockSubjects, (Resource)this.mockSubject)).thenReturn((Object)true);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)JcrRdfTools.getNodeFromGraphSubject((GraphSubjects)this.mockSubjects, (Session)this.mockSession, (Resource)this.mockSubject)).thenReturn((Object)node);
        String string = "jcr:property";
        Mockito.when((Object)JcrRdfTools.getPropertyNameFromPredicate((Node)node, (Property)this.mockPredicate)).thenReturn((Object)string);
        this.testObj.addedStatement(this.mockStatement);
        Assert.assertEquals((long)1L, (long)this.testObj.getProblems().size());
    }

    @Test
    public void testAddedStatement() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)JcrRdfTools.isFedoraGraphSubject((GraphSubjects)this.mockSubjects, (Resource)this.mockSubject)).thenReturn((Object)true);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)JcrRdfTools.getNodeFromGraphSubject((GraphSubjects)this.mockSubjects, (Session)this.mockSession, (Resource)this.mockSubject)).thenReturn((Object)node);
        String string = "mock:property";
        Mockito.when((Object)JcrRdfTools.getPropertyNameFromPredicate((Node)node, (Property)this.mockPredicate)).thenReturn((Object)string);
        PowerMockito.mockStatic(NodePropertiesTools.class, (Class[])new Class[0]);
        Mockito.when((Object)NodePropertiesTools.getPropertyType((Node)node, (String)string)).thenReturn((Object)1);
        this.testObj.addedStatement(this.mockStatement);
        Assert.assertEquals((long)0L, (long)this.testObj.getProblems().size());
    }

    @Test(expected=RuntimeException.class)
    public void testAddedStatementRepositoryException() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)JcrRdfTools.isFedoraGraphSubject((GraphSubjects)this.mockSubjects, (Resource)this.mockSubject)).thenReturn((Object)true);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)JcrRdfTools.getNodeFromGraphSubject((GraphSubjects)this.mockSubjects, (Session)this.mockSession, (Resource)this.mockSubject)).thenReturn((Object)node);
        Mockito.when((Object)JcrRdfTools.getPropertyNameFromPredicate((Node)node, (Property)this.mockPredicate)).thenThrow(new Throwable[]{new RepositoryException()});
        this.testObj.addedStatement(this.mockStatement);
    }

    @Test
    public void testRemovedStatement() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)JcrRdfTools.isFedoraGraphSubject((GraphSubjects)this.mockSubjects, (Resource)this.mockSubject)).thenReturn((Object)true);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)JcrRdfTools.getNodeFromGraphSubject((GraphSubjects)this.mockSubjects, (Session)this.mockSession, (Resource)this.mockSubject)).thenReturn((Object)node);
        String string = "mock:property";
        Mockito.when((Object)JcrRdfTools.getPropertyNameFromPredicate((Node)node, (Property)this.mockPredicate)).thenReturn((Object)string);
        Mockito.when((Object)node.hasProperty(string)).thenReturn((Object)true);
        PowerMockito.mockStatic(NodePropertiesTools.class, (Class[])new Class[0]);
        Mockito.when((Object)NodePropertiesTools.getPropertyType((Node)node, (String)string)).thenReturn((Object)1);
        this.testObj.removedStatement(this.mockStatement);
        Assert.assertEquals((long)0L, (long)this.testObj.getProblems().size());
    }

    @Test(expected=RuntimeException.class)
    public void testRemovedStatementRepositoryException() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)JcrRdfTools.isFedoraGraphSubject((GraphSubjects)this.mockSubjects, (Resource)this.mockSubject)).thenReturn((Object)true);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)JcrRdfTools.getNodeFromGraphSubject((GraphSubjects)this.mockSubjects, (Session)this.mockSession, (Resource)this.mockSubject)).thenReturn((Object)node);
        Mockito.when((Object)JcrRdfTools.getPropertyNameFromPredicate((Node)node, (Property)this.mockPredicate)).thenThrow(new Throwable[]{new RepositoryException()});
        this.testObj.removedStatement(this.mockStatement);
    }

    @Test
    public void testRemovedProhibitedStatement() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)JcrRdfTools.isFedoraGraphSubject((GraphSubjects)this.mockSubjects, (Resource)this.mockSubject)).thenReturn((Object)true);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)JcrRdfTools.getNodeFromGraphSubject((GraphSubjects)this.mockSubjects, (Session)this.mockSession, (Resource)this.mockSubject)).thenReturn((Object)node);
        String string = "jcr:property";
        Mockito.when((Object)JcrRdfTools.getPropertyNameFromPredicate((Node)node, (Property)this.mockPredicate)).thenReturn((Object)string);
        Mockito.when((Object)node.hasProperty(string)).thenReturn((Object)true);
        PowerMockito.mockStatic(NodePropertiesTools.class, (Class[])new Class[0]);
        Mockito.when((Object)NodePropertiesTools.getPropertyType((Node)node, (String)string)).thenReturn((Object)1);
        this.testObj.removedStatement(this.mockStatement);
        Assert.assertEquals((long)1L, (long)this.testObj.getProblems().size());
    }

    @Test
    public void testRemovedIrrelevantStatement() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        Mockito.when((Object)JcrRdfTools.isFedoraGraphSubject((GraphSubjects)this.mockSubjects, (Resource)this.mockSubject)).thenReturn((Object)false);
        this.testObj.removedStatement(this.mockStatement);
        PowerMockito.verifyStatic((VerificationMode)Mockito.never());
        JcrRdfTools.getNodeFromGraphSubject((GraphSubjects)((GraphSubjects)Matchers.any(GraphSubjects.class)), (Session)((Session)Matchers.any(Session.class)), (Resource)((Resource)Matchers.any(Resource.class)));
        Assert.assertEquals((long)0L, (long)this.testObj.getProblems().size());
    }
}

