/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utils;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.fcrepo.RdfLexicon;
import org.fcrepo.rdf.GraphSubjects;
import org.fcrepo.rdf.impl.DefaultGraphSubjects;
import org.fcrepo.services.LowLevelStorageService;
import org.fcrepo.services.functions.GetClusterConfiguration;
import org.fcrepo.utils.FedoraTypesUtils;
import org.fcrepo.utils.FixityResult;
import org.fcrepo.utils.JcrRdfTools;
import org.fcrepo.utils.LowLevelCacheEntry;
import org.fcrepo.utils.NamespaceTools;
import org.fcrepo.utils.NodeIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrRdfToolsTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrRdfToolsTest.class);
    private javax.jcr.Node mockNode;
    private NamespaceRegistry mockNsRegistry;
    private GraphSubjects testSubjects;
    private Session mockSession;
    private Repository mockRepository;
    private Workspace mockWorkspace;

    @Before
    public void setUp() throws RepositoryException {
        this.mockSession = (Session)Mockito.mock(Session.class);
        this.testSubjects = new DefaultGraphSubjects();
        this.mockNode = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        this.mockWorkspace = (Workspace)Mockito.mock(Workspace.class);
        this.mockRepository = (Repository)Mockito.mock(Repository.class);
        Mockito.when((Object)this.mockSession.getRepository()).thenReturn((Object)this.mockRepository);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        this.mockNamespaceRegistry();
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNsRegistry);
    }

    @Test
    public void shouldMapInternalJcrNamespaceToFcrepoNamespace() {
        Assert.assertEquals((Object)"info:fedora/fedora-system:def/internal#", (Object)JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"http://www.jcp.org/jcr/1.0"));
    }

    @Test
    public void shouldMapFcrepoNamespaceToJcrNamespace() {
        Assert.assertEquals((Object)"http://www.jcp.org/jcr/1.0", (Object)JcrRdfTools.getJcrNamespaceForRDFNamespace((String)"info:fedora/fedora-system:def/internal#"));
    }

    @Test
    public void shouldPassThroughOtherNamespaceValues() {
        Assert.assertEquals((Object)"some-namespace-uri", (Object)JcrRdfTools.getJcrNamespaceForRDFNamespace((String)"some-namespace-uri"));
        Assert.assertEquals((Object)"some-namespace-uri", (Object)JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"some-namespace-uri"));
    }

    @Test
    public void shouldMapRdfPredicatesToJcrProperties() throws RepositoryException {
        com.hp.hpl.jena.rdf.model.Property property = ResourceFactory.createProperty((String)"info:fedora/fedora-system:def/internal#", (String)"uuid");
        Assert.assertEquals((Object)"jcr:uuid", (Object)JcrRdfTools.getPropertyNameFromPredicate((javax.jcr.Node)this.mockNode, (com.hp.hpl.jena.rdf.model.Property)property));
    }

    @Test
    public void shouldReuseRegisteredNamespaces() throws RepositoryException {
        com.hp.hpl.jena.rdf.model.Property property = ResourceFactory.createProperty((String)"registered-uri#", (String)"uuid");
        Assert.assertEquals((Object)"some-prefix:uuid", (Object)JcrRdfTools.getPropertyNameFromPredicate((javax.jcr.Node)this.mockNode, (com.hp.hpl.jena.rdf.model.Property)property));
    }

    @Test
    public void shouldRegisterUnknownUris() throws RepositoryException {
        Mockito.when((Object)this.mockNsRegistry.registerNamespace("not-registered-uri#")).thenReturn((Object)"ns001");
        com.hp.hpl.jena.rdf.model.Property property = ResourceFactory.createProperty((String)"not-registered-uri#", (String)"uuid");
        Assert.assertEquals((Object)"ns001:uuid", (Object)JcrRdfTools.getPropertyNameFromPredicate((javax.jcr.Node)this.mockNode, (com.hp.hpl.jena.rdf.model.Property)property));
    }

    @Test
    public void shouldMapJcrNodeNamestoRDFResources() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/abc");
        Assert.assertEquals((Object)"info:fedora/abc", (Object)JcrRdfTools.getGraphSubject((GraphSubjects)this.testSubjects, (javax.jcr.Node)this.mockNode).toString());
    }

    @Test
    public void shouldMapJcrContentNodeNamestoRDFResourcesIntheFcrNamespace() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/abc/jcr:content");
        Assert.assertEquals((Object)"info:fedora/abc/fcr:content", (Object)JcrRdfTools.getGraphSubject((GraphSubjects)this.testSubjects, (javax.jcr.Node)this.mockNode).toString());
    }

    @Test
    public void shouldMapRDFResourcesToJcrNodes() throws RepositoryException {
        Mockito.when((Object)this.mockSession.nodeExists("/abc")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode("/abc")).thenReturn((Object)this.mockNode);
        Assert.assertEquals((Object)this.mockNode, (Object)JcrRdfTools.getNodeFromGraphSubject((GraphSubjects)this.testSubjects, (Session)this.mockSession, (Resource)ResourceFactory.createResource((String)"info:fedora/abc")));
    }

    @Test
    public void shouldMapRDFContentResourcesToJcrContentNodes() throws RepositoryException {
        Mockito.when((Object)this.mockSession.nodeExists("/abc/jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode("/abc/jcr:content")).thenReturn((Object)this.mockNode);
        Assert.assertEquals((Object)this.mockNode, (Object)JcrRdfTools.getNodeFromGraphSubject((GraphSubjects)this.testSubjects, (Session)this.mockSession, (Resource)ResourceFactory.createResource((String)"info:fedora/abc/fcr:content")));
    }

    @Test
    public void shouldReturnNullIfItFailstoMapRDFResourcesToJcrNodes() throws RepositoryException {
        Mockito.when((Object)this.mockSession.nodeExists("/does-not-exist")).thenReturn((Object)false);
        Assert.assertNull((String)"should receive null for a non-JCR resource", (Object)JcrRdfTools.getNodeFromGraphSubject((GraphSubjects)this.testSubjects, (Session)this.mockSession, (Resource)ResourceFactory.createResource((String)"this-is-not-a-fedora-node/abc")));
        Assert.assertNull((String)"should receive null a JCR node that isn't found", (Object)JcrRdfTools.getNodeFromGraphSubject((GraphSubjects)this.testSubjects, (Session)this.mockSession, (Resource)ResourceFactory.createResource((String)"info:fedora/does-not-exist")));
    }

    @Test
    public void shouldDetermineIfAGraphResourceIsAJcrNode() throws RepositoryException {
        GraphSubjects graphSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)graphSubjects.isFedoraGraphSubject(resource)).thenReturn((Object)true);
        Assert.assertTrue((boolean)JcrRdfTools.isFedoraGraphSubject((GraphSubjects)graphSubjects, (Resource)resource));
        ((GraphSubjects)Mockito.verify((Object)graphSubjects)).isFedoraGraphSubject(resource);
    }

    @Test
    public void testGetPropertiesModel() throws RepositoryException {
        javax.jcr.Node node = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)node);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType().getName()).thenReturn((Object)"");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        javax.jcr.NodeIterator nodeIterator = (javax.jcr.NodeIterator)Mockito.mock(javax.jcr.NodeIterator.class);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)nodeIterator);
        PropertyIterator propertyIterator = (PropertyIterator)Mockito.mock(PropertyIterator.class);
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)propertyIterator);
        PropertyIterator propertyIterator2 = (PropertyIterator)Mockito.mock(PropertyIterator.class);
        Mockito.when((Object)node.getProperties()).thenReturn((Object)propertyIterator2);
        Mockito.when((Object)propertyIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)propertyIterator2.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)property.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)property.getName()).thenReturn((Object)"xyz");
        Mockito.when((Object)property.getType()).thenReturn((Object)0);
        Value value = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)value.getString()).thenReturn((Object)"abc");
        Mockito.when((Object)property.getValue()).thenReturn((Object)value);
        Mockito.when((Object)propertyIterator.nextProperty()).thenReturn((Object)property);
        Mockito.when((Object)propertyIterator2.nextProperty()).thenReturn((Object)property);
        Model model = JcrRdfTools.getJcrPropertiesModel((GraphSubjects)this.testSubjects, (javax.jcr.Node)this.mockNode);
        Assert.assertEquals((Object)"info:fedora/fedora-system:def/internal#", (Object)model.getNsPrefixURI("fedora-internal"));
        Assert.assertTrue((boolean)model.contains(this.testSubjects.getGraphSubject(this.mockNode), model.getProperty("xyz"), (RDFNode)model.createLiteral("abc")));
    }

    @Test
    public void testGetPropertiesModelWithContent() throws RepositoryException {
        LowLevelStorageService lowLevelStorageService = (LowLevelStorageService)Mockito.mock(LowLevelStorageService.class);
        JcrRdfTools.setLlstore((LowLevelStorageService)lowLevelStorageService);
        javax.jcr.Node node = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)node);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType().getName()).thenReturn((Object)"");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.hasNode("jcr:content")).thenReturn((Object)true);
        javax.jcr.Node node2 = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)node2.getPath()).thenReturn((Object)"/test/jcr/jcr:content");
        Property property = (Property)Mockito.mock(Property.class);
        BinaryValue binaryValue = (BinaryValue)Mockito.mock(BinaryValue.class);
        Mockito.when((Object)binaryValue.getKey()).thenReturn((Object)new BinaryKey("abc"));
        Mockito.when((Object)property.getBinary()).thenReturn((Object)binaryValue);
        Mockito.when((Object)node2.getProperty("jcr:data")).thenReturn((Object)property);
        LowLevelCacheEntry lowLevelCacheEntry = (LowLevelCacheEntry)Mockito.mock(LowLevelCacheEntry.class);
        Mockito.when((Object)lowLevelCacheEntry.getExternalIdentifier()).thenReturn((Object)"xyz");
        Mockito.when((Object)lowLevelStorageService.getLowLevelCacheEntries(node2)).thenReturn((Object)ImmutableSet.of((Object)lowLevelCacheEntry));
        Mockito.when((Object)this.mockNode.getNode("jcr:content")).thenReturn((Object)node2);
        javax.jcr.NodeIterator nodeIterator = (javax.jcr.NodeIterator)Mockito.mock(javax.jcr.NodeIterator.class);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)nodeIterator);
        PropertyIterator propertyIterator = (PropertyIterator)Mockito.mock(PropertyIterator.class);
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)propertyIterator);
        Mockito.when((Object)node.getProperties()).thenReturn((Object)propertyIterator);
        Mockito.when((Object)node2.getProperties()).thenReturn((Object)propertyIterator);
        Mockito.when((Object)propertyIterator.hasNext()).thenReturn((Object)false);
        Model model = JcrRdfTools.getJcrPropertiesModel((GraphSubjects)this.testSubjects, (javax.jcr.Node)this.mockNode);
        Assert.assertEquals((Object)"info:fedora/fedora-system:def/internal#", (Object)model.getNsPrefixURI("fedora-internal"));
        Assert.assertTrue((boolean)model.contains(this.testSubjects.getGraphSubject(this.mockNode), RdfLexicon.HAS_CONTENT, (RDFNode)this.testSubjects.getGraphSubject(node2)));
        Assert.assertTrue((boolean)model.contains(this.testSubjects.getGraphSubject(node2), RdfLexicon.HAS_LOCATION, (RDFNode)model.createLiteral("xyz")));
    }

    @Test
    public void testGetPropertiesModelForRootNode() throws RepositoryException {
        Mockito.when((Object)this.mockRepository.login()).thenReturn((Object)this.mockSession);
        QueryManager queryManager = (QueryManager)Mockito.mock(QueryManager.class);
        Query query = (Query)Mockito.mock(Query.class);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        RowIterator rowIterator = (RowIterator)Mockito.mock(RowIterator.class);
        Mockito.when((Object)rowIterator.getSize()).thenReturn((Object)0L);
        Mockito.when((Object)queryResult.getRows()).thenReturn((Object)rowIterator);
        Mockito.when((Object)query.execute()).thenReturn((Object)queryResult);
        Mockito.when((Object)queryManager.createQuery(Matchers.anyString(), (String)Matchers.eq((Object)"JCR-SQL2"))).thenReturn((Object)query);
        Mockito.when((Object)this.mockWorkspace.getQueryManager()).thenReturn((Object)queryManager);
        MetricRegistry metricRegistry = (MetricRegistry)Mockito.mock(MetricRegistry.class);
        Counter counter = (Counter)Mockito.mock(Counter.class);
        Mockito.when((Object)metricRegistry.getCounters()).thenReturn((Object)ImmutableSortedMap.of((Comparable)((Object)"org.fcrepo.services.LowLevelStorageService.fixity-check-counter"), (Object)counter, (Comparable)((Object)"org.fcrepo.services.LowLevelStorageService.fixity-error-counter"), (Object)counter, (Comparable)((Object)"org.fcrepo.services.LowLevelStorageService.fixity-repaired-counter"), (Object)counter));
        GetClusterConfiguration getClusterConfiguration = (GetClusterConfiguration)Mockito.mock(GetClusterConfiguration.class);
        Mockito.when((Object)getClusterConfiguration.apply(this.mockRepository)).thenReturn((Object)ImmutableMap.of((Object)"a", (Object)"b"));
        JcrRdfTools.setGetClusterConfiguration((GetClusterConfiguration)getClusterConfiguration);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/");
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType().getName()).thenReturn((Object)"mode:root");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        javax.jcr.NodeIterator nodeIterator = (javax.jcr.NodeIterator)Mockito.mock(javax.jcr.NodeIterator.class);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)nodeIterator);
        PropertyIterator propertyIterator = (PropertyIterator)Mockito.mock(PropertyIterator.class);
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)propertyIterator);
        Mockito.when((Object)propertyIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockSession.getRepository()).thenReturn((Object)this.mockRepository);
        Mockito.when((Object)this.mockRepository.getDescriptorKeys()).thenReturn((Object)new String[]{"some-descriptor-key"});
        Mockito.when((Object)this.mockRepository.getDescriptor("some-descriptor-key")).thenReturn((Object)"some-descriptor-value");
        NodeTypeManager nodeTypeManager = (NodeTypeManager)Mockito.mock(NodeTypeManager.class);
        NodeTypeIterator nodeTypeIterator = (NodeTypeIterator)Mockito.mock(NodeTypeIterator.class);
        Mockito.when((Object)nodeTypeIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)nodeTypeManager.getAllNodeTypes()).thenReturn((Object)nodeTypeIterator);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)nodeTypeManager);
        Model model = JcrRdfTools.getJcrPropertiesModel((GraphSubjects)this.testSubjects, (javax.jcr.Node)this.mockNode);
        Assert.assertEquals((Object)"info:fedora/fedora-system:def/internal#", (Object)model.getNsPrefixURI("fedora-internal"));
        Assert.assertTrue((boolean)model.contains(this.testSubjects.getGraphSubject(this.mockNode), model.createProperty("info:fedora/fedora-system:def/internal#repository/some-descriptor-key"), (RDFNode)model.createLiteral("some-descriptor-value")));
        Assert.assertTrue((boolean)model.contains(this.testSubjects.getGraphSubject(this.mockNode), model.createProperty("info:fedora/fedora-system:def/internal#a"), (RDFNode)model.createLiteral("b")));
    }

    @Test
    public void shouldExcludeBinaryProperties() throws RepositoryException {
        javax.jcr.Node node = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)node);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)2);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType().getName()).thenReturn((Object)"fedora:object");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        PropertyIterator propertyIterator = (PropertyIterator)Mockito.mock(PropertyIterator.class);
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)propertyIterator);
        Mockito.when((Object)node.getProperties()).thenReturn((Object)propertyIterator);
        Mockito.when((Object)propertyIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Property property = (Property)Mockito.mock(Property.class);
        Value value = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)property.getValue()).thenReturn((Object)value);
        Mockito.when((Object)value.getType()).thenReturn((Object)2);
        Mockito.when((Object)propertyIterator.nextProperty()).thenReturn((Object)property);
        Model model = JcrRdfTools.getJcrPropertiesModel((GraphSubjects)this.testSubjects, (javax.jcr.Node)this.mockNode);
        Assert.assertEquals((long)0L, (long)model.size());
    }

    @Test
    public void shouldIncludeParentNodeInformation() throws RepositoryException {
        javax.jcr.Node node = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)node);
        javax.jcr.NodeIterator nodeIterator = (javax.jcr.NodeIterator)Mockito.mock(javax.jcr.NodeIterator.class);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)nodeIterator);
        Model model = JcrRdfTools.getJcrTreeModel((GraphSubjects)this.testSubjects, (javax.jcr.Node)this.mockNode, (long)0L, (int)-1);
        Assert.assertEquals((long)1L, (long)model.size());
    }

    @Test
    public void shouldIncludeChildNodeInformation() throws RepositoryException {
        javax.jcr.Node node = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)node);
        javax.jcr.Node node2 = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)node2.getName()).thenReturn((Object)"some-name");
        Mockito.when((Object)node2.getPath()).thenReturn((Object)"/test/jcr/1", (Object[])new String[]{"/test/jcr/2", "/test/jcr/3", "/test/jcr/4", "/test/jcr/5"});
        javax.jcr.NodeIterator nodeIterator = (javax.jcr.NodeIterator)Mockito.mock(javax.jcr.NodeIterator.class);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, true, false});
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)node2);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)nodeIterator);
        Model model = JcrRdfTools.getJcrTreeModel((GraphSubjects)this.testSubjects, (javax.jcr.Node)this.mockNode, (long)0L, (int)0);
        Assert.assertEquals((long)11L, (long)model.size());
    }

    @Test
    public void shouldIncludeFullChildNodeInformationInsideWindow() throws RepositoryException {
        javax.jcr.Node node = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)node);
        javax.jcr.Node node2 = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)node2.getName()).thenReturn((Object)"some-name");
        Mockito.when((Object)node2.getPath()).thenReturn((Object)"/test/jcr/1", (Object[])new String[]{"/test/jcr/4", "/test/jcr/5"});
        javax.jcr.Node node3 = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)node3.getName()).thenReturn((Object)"some-other-name");
        Mockito.when((Object)node3.getPath()).thenReturn((Object)"/test/jcr/2", (Object[])new String[]{"/test/jcr/3"});
        PropertyIterator propertyIterator = (PropertyIterator)Mockito.mock(PropertyIterator.class);
        Mockito.when((Object)node3.getProperties()).thenReturn((Object)propertyIterator);
        Mockito.when((Object)propertyIterator.hasNext()).thenReturn((Object)false);
        javax.jcr.NodeIterator nodeIterator = (javax.jcr.NodeIterator)Mockito.mock(javax.jcr.NodeIterator.class);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, true, false});
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)node2, (Object[])new javax.jcr.Node[]{node3, node3, node2, node2});
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)nodeIterator);
        Model model = JcrRdfTools.getJcrTreeModel((GraphSubjects)this.testSubjects, (javax.jcr.Node)this.mockNode, (long)1L, (int)2);
        Assert.assertEquals((long)11L, (long)model.size());
        ((javax.jcr.Node)Mockito.verify((Object)node2, (VerificationMode)Mockito.never())).getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldMapRdfValuesToJcrPropertyValues() throws RepositoryException {
        ValueFactory valueFactory = (ValueFactory)Mockito.mock(ValueFactory.class);
        Function function = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)function.apply((Object)this.mockNode)).thenReturn((Object)valueFactory);
        Function function2 = FedoraTypesUtils.getValueFactory;
        FedoraTypesUtils.getValueFactory = function;
        try {
            Resource resource = ResourceFactory.createResource((String)"info:fedora/abc");
            Mockito.when((Object)this.mockSession.getNode("/abc")).thenReturn((Object)this.mockNode);
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)9);
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)10);
            ((ValueFactory)Mockito.verify((Object)valueFactory, (VerificationMode)Mockito.times((int)2))).createValue(this.mockNode);
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)0);
            ((ValueFactory)Mockito.verify((Object)valueFactory)).createValue("info:fedora/abc", 11);
            resource = ResourceFactory.createResource();
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)0);
            ((ValueFactory)Mockito.verify((Object)valueFactory)).createValue(resource.toString(), 0);
            resource = ResourceFactory.createTypedLiteral((Object)true);
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)0);
            ((ValueFactory)Mockito.verify((Object)valueFactory)).createValue(true);
            resource = ResourceFactory.createTypedLiteral((String)"1", (RDFDatatype)XSDDatatype.XSDbyte);
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)0);
            ((ValueFactory)Mockito.verify((Object)valueFactory)).createValue(1L);
            resource = ResourceFactory.createTypedLiteral((Object)2.0);
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)0);
            ((ValueFactory)Mockito.verify((Object)valueFactory)).createValue(2.0);
            resource = ResourceFactory.createTypedLiteral((Object)Float.valueOf(3.0f));
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)0);
            ((ValueFactory)Mockito.verify((Object)valueFactory)).createValue(3.0);
            resource = ResourceFactory.createTypedLiteral((Object)4);
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)0);
            ((ValueFactory)Mockito.verify((Object)valueFactory)).createValue(4L);
            resource = ResourceFactory.createTypedLiteral((String)"5", (RDFDatatype)XSDDatatype.XSDlong);
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)0);
            ((ValueFactory)Mockito.verify((Object)valueFactory)).createValue(5L);
            resource = ResourceFactory.createTypedLiteral((String)"6", (RDFDatatype)XSDDatatype.XSDshort);
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)0);
            ((ValueFactory)Mockito.verify((Object)valueFactory)).createValue(6L);
            Calendar calendar = Calendar.getInstance();
            resource = ResourceFactory.createTypedLiteral((Object)calendar);
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)0);
            ((ValueFactory)Mockito.verify((Object)valueFactory)).createValue((Calendar)Matchers.any(Calendar.class));
            resource = ResourceFactory.createTypedLiteral((Object)"string");
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)0);
            ((ValueFactory)Mockito.verify((Object)valueFactory)).createValue("string", 1);
            resource = ResourceFactory.createTypedLiteral((Object)"string");
            JcrRdfTools.createValue((javax.jcr.Node)this.mockNode, (RDFNode)resource, (int)7);
            ((ValueFactory)Mockito.verify((Object)valueFactory)).createValue("string", 7);
        }
        finally {
            FedoraTypesUtils.getValueFactory = function2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAddPropertiesToModel() throws RepositoryException {
        Property property = (Property)Mockito.mock(Property.class);
        com.hp.hpl.jena.rdf.model.Property property2 = (com.hp.hpl.jena.rdf.model.Property)Mockito.mock(com.hp.hpl.jena.rdf.model.Property.class);
        Function function = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)function.apply((Object)property)).thenReturn((Object)property2);
        Function function2 = FedoraTypesUtils.getPredicateForProperty;
        FedoraTypesUtils.getPredicateForProperty = function;
        try {
            Resource resource = (Resource)Mockito.mock(Resource.class);
            Model model = (Model)Mockito.mock(Model.class);
            Value value = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)value.getString()).thenReturn((Object)"");
            Mockito.when((Object)property.isMultiple()).thenReturn((Object)false);
            Mockito.when((Object)property.getValue()).thenReturn((Object)value);
            JcrRdfTools.addPropertyToModel((Resource)resource, (Model)model, (Property)property);
            ((Model)Mockito.verify((Object)model)).add(resource, property2, "");
        }
        finally {
            FedoraTypesUtils.getPredicateForProperty = function2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAddMultivaluedPropertiesToModel() throws RepositoryException {
        Property property = (Property)Mockito.mock(Property.class);
        com.hp.hpl.jena.rdf.model.Property property2 = (com.hp.hpl.jena.rdf.model.Property)Mockito.mock(com.hp.hpl.jena.rdf.model.Property.class);
        Function function = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)function.apply((Object)property)).thenReturn((Object)property2);
        Function function2 = FedoraTypesUtils.getPredicateForProperty;
        FedoraTypesUtils.getPredicateForProperty = function;
        try {
            Resource resource = (Resource)Mockito.mock(Resource.class);
            Model model = (Model)Mockito.mock(Model.class);
            Value value = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)value.getString()).thenReturn((Object)"1");
            Value value2 = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)value2.getString()).thenReturn((Object)"2");
            Mockito.when((Object)property.isMultiple()).thenReturn((Object)true);
            Mockito.when((Object)property.getValues()).thenReturn((Object)Arrays.asList(value, value2).toArray(new Value[2]));
            JcrRdfTools.addPropertyToModel((Resource)resource, (Model)model, (Property)property);
            ((Model)Mockito.verify((Object)model)).add(resource, property2, "1");
            ((Model)Mockito.verify((Object)model)).add(resource, property2, "2");
        }
        finally {
            FedoraTypesUtils.getPredicateForProperty = function2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldMapJcrTypesToRdfDataTypes() throws RepositoryException {
        Property property = (Property)Mockito.mock(Property.class);
        Resource resource = ResourceFactory.createResource((String)"some-resource-uri");
        Model model = ModelFactory.createDefaultModel();
        com.hp.hpl.jena.rdf.model.Property property2 = model.createProperty("some-predicate-uri");
        Function function = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)function.apply((Object)property)).thenReturn((Object)property2);
        Function function2 = FedoraTypesUtils.getPredicateForProperty;
        FedoraTypesUtils.getPredicateForProperty = function;
        try {
            Value value = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)value.getType()).thenReturn((Object)6);
            Mockito.when((Object)value.getBoolean()).thenReturn((Object)true);
            JcrRdfTools.addPropertyToModel((Resource)resource, (Model)model, (Property)property, (Value)value);
            Assert.assertTrue((boolean)model.contains(resource, property2, (RDFNode)ResourceFactory.createTypedLiteral((Object)true)));
            value = (Value)Mockito.mock(Value.class);
            Calendar calendar = Calendar.getInstance();
            Mockito.when((Object)value.getType()).thenReturn((Object)5);
            Mockito.when((Object)value.getDate()).thenReturn((Object)calendar);
            JcrRdfTools.addPropertyToModel((Resource)resource, (Model)model, (Property)property, (Value)value);
            Assert.assertTrue((boolean)model.contains(resource, property2, (RDFNode)ResourceFactory.createTypedLiteral((Object)calendar)));
            value = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)value.getType()).thenReturn((Object)12);
            Mockito.when((Object)value.getDecimal()).thenReturn((Object)BigDecimal.valueOf(0.0));
            JcrRdfTools.addPropertyToModel((Resource)resource, (Model)model, (Property)property, (Value)value);
            Assert.assertTrue((boolean)model.contains(resource, property2, (RDFNode)ResourceFactory.createTypedLiteral((Object)BigDecimal.valueOf(0.0))));
            value = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)value.getType()).thenReturn((Object)4);
            Mockito.when((Object)value.getDouble()).thenReturn((Object)0.0);
            JcrRdfTools.addPropertyToModel((Resource)resource, (Model)model, (Property)property, (Value)value);
            Assert.assertTrue((boolean)model.contains(resource, property2, (RDFNode)ResourceFactory.createTypedLiteral((Object)0.0)));
            value = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)value.getType()).thenReturn((Object)3);
            Mockito.when((Object)value.getLong()).thenReturn((Object)0L);
            JcrRdfTools.addPropertyToModel((Resource)resource, (Model)model, (Property)property, (Value)value);
            Assert.assertTrue((boolean)model.contains(resource, property2, (RDFNode)ResourceFactory.createTypedLiteral((Object)0L)));
            value = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)value.getType()).thenReturn((Object)1);
            Mockito.when((Object)value.getString()).thenReturn((Object)"XYZ");
            JcrRdfTools.addPropertyToModel((Resource)resource, (Model)model, (Property)property, (Value)value);
            Assert.assertTrue((boolean)model.contains(resource, property2, (RDFNode)ResourceFactory.createTypedLiteral((Object)"XYZ")));
            value = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)value.getType()).thenReturn((Object)11);
            Mockito.when((Object)value.getString()).thenReturn((Object)"info:fedora");
            JcrRdfTools.addPropertyToModel((Resource)resource, (Model)model, (Property)property, (Value)value);
            Assert.assertTrue((boolean)model.contains(resource, property2, (RDFNode)ResourceFactory.createResource((String)"info:fedora")));
            value = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)property.getSession()).thenReturn((Object)this.mockSession);
            Mockito.when((Object)this.mockSession.getNodeByIdentifier("uuid")).thenReturn((Object)this.mockNode);
            Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/abc");
            Mockito.when((Object)value.getType()).thenReturn((Object)9);
            Mockito.when((Object)value.getString()).thenReturn((Object)"uuid");
            JcrRdfTools.addPropertyToModel((Resource)resource, (Model)model, (Property)property, (Value)value);
            Assert.assertTrue((boolean)model.contains(resource, property2, (RDFNode)ResourceFactory.createResource((String)"info:fedora/abc")));
            value = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)value.getType()).thenReturn((Object)10);
            Mockito.when((Object)value.getString()).thenReturn((Object)"uuid");
            Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/def");
            JcrRdfTools.addPropertyToModel((Resource)resource, (Model)model, (Property)property, (Value)value);
            Assert.assertTrue((boolean)model.contains(resource, property2, (RDFNode)ResourceFactory.createResource((String)"info:fedora/def")));
            value = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)value.getType()).thenReturn((Object)8);
            Mockito.when((Object)value.getString()).thenReturn((Object)"/ghi");
            JcrRdfTools.addPropertyToModel((Resource)resource, (Model)model, (Property)property, (Value)value);
            Assert.assertTrue((boolean)model.contains(resource, property2, (RDFNode)ResourceFactory.createResource((String)"info:fedora/ghi")));
        }
        finally {
            FedoraTypesUtils.getPredicateForProperty = function2;
        }
    }

    @Test
    @Ignore
    public void testJcrNodeContent() throws RepositoryException {
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType().getName()).thenReturn((Object)"");
        PropertyIterator propertyIterator = (PropertyIterator)Mockito.mock(PropertyIterator.class);
        Mockito.when((Object)propertyIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)propertyIterator);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/path/to/node");
        javax.jcr.NodeIterator nodeIterator = (javax.jcr.NodeIterator)Mockito.mock(javax.jcr.NodeIterator.class);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)nodeIterator);
        javax.jcr.Node node = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/path/to/node/content");
        Mockito.when((Object)node.getProperties()).thenReturn((Object)propertyIterator);
        Mockito.when((Object)node.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNode.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getNode("jcr:content")).thenReturn((Object)node);
        Model model = JcrRdfTools.getJcrPropertiesModel((GraphSubjects)this.testSubjects, (javax.jcr.Node)this.mockNode);
        Assert.assertTrue((model != null ? 1 : 0) != 0);
    }

    @Test
    public void testJcrNodeIteratorModel() throws RepositoryException {
        Resource resource = (Resource)Mockito.mock(Resource.class);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)false);
        Model model = JcrRdfTools.getJcrNodeIteratorModel((GraphSubjects)this.testSubjects, (Iterator)nodeIterator, (Resource)resource);
        Assert.assertTrue((model != null ? 1 : 0) != 0);
    }

    @Test
    public void testJcrNodeIteratorAddsPredicatesForEachNode() throws RepositoryException {
        Resource resource = ResourceFactory.createResource((String)"info:fedora/search/resource");
        javax.jcr.Node node = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        javax.jcr.Node node2 = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        javax.jcr.Node node3 = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        PropertyIterator propertyIterator = (PropertyIterator)Mockito.mock(PropertyIterator.class);
        Mockito.when((Object)propertyIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)node.getProperties()).thenReturn((Object)propertyIterator);
        Mockito.when((Object)node.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/path/to/first/node");
        Mockito.when((Object)node2.getPath()).thenReturn((Object)"/second/path/to/node");
        Mockito.when((Object)node3.getPath()).thenReturn((Object)"/third/path/to/node");
        Mockito.when((Object)node.getProperties()).thenReturn((Object)propertyIterator);
        Mockito.when((Object)node2.getProperties()).thenReturn((Object)propertyIterator);
        Mockito.when((Object)node3.getProperties()).thenReturn((Object)propertyIterator);
        Iterator<javax.jcr.Node> iterator = Arrays.asList(node, node2, node3).iterator();
        Model model = JcrRdfTools.getJcrNodeIteratorModel((GraphSubjects)this.testSubjects, iterator, (Resource)resource);
        Assert.assertEquals((long)3L, (long)model.listObjectsOfProperty(RdfLexicon.HAS_MEMBER_OF_RESULT).toSet().size());
    }

    @Test
    public void testGetFixityResultsModel() throws RepositoryException, URISyntaxException {
        LowLevelCacheEntry lowLevelCacheEntry = (LowLevelCacheEntry)Mockito.mock(LowLevelCacheEntry.class);
        Mockito.when((Object)lowLevelCacheEntry.getExternalIdentifier()).thenReturn((Object)"xyz");
        FixityResult fixityResult = new FixityResult(lowLevelCacheEntry, 123L, new URI("abc"));
        fixityResult.status.add(FixityResult.FixityState.BAD_CHECKSUM);
        fixityResult.status.add(FixityResult.FixityState.BAD_SIZE);
        List<FixityResult> list = Arrays.asList(fixityResult);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/path/to/node");
        PropertyIterator propertyIterator = (PropertyIterator)Mockito.mock(PropertyIterator.class);
        Mockito.when((Object)propertyIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)propertyIterator);
        Model model = JcrRdfTools.getFixityResultsModel((GraphSubjects)this.testSubjects, (javax.jcr.Node)this.mockNode, list);
        LOGGER.info("Got graph {}", (Object)model);
        GraphStore graphStore = GraphStoreFactory.create((Model)model);
        Assert.assertTrue((boolean)graphStore.contains(Node.ANY, Node.ANY, RdfLexicon.IS_FIXITY_RESULT_OF.asNode(), ResourceFactory.createResource((String)"info:fedora/path/to/node").asNode()));
        Assert.assertTrue((boolean)graphStore.contains(Node.ANY, Node.ANY, RdfLexicon.HAS_COMPUTED_CHECKSUM.asNode(), ResourceFactory.createResource((String)"abc").asNode()));
        Assert.assertTrue((boolean)graphStore.contains(Node.ANY, Node.ANY, RdfLexicon.HAS_COMPUTED_SIZE.asNode(), ResourceFactory.createTypedLiteral((Object)123).asNode()));
    }

    @Test
    public void testGetJcrNamespaceModel() throws Exception {
        Model model = JcrRdfTools.getJcrNamespaceModel((Session)this.mockSession);
        Assert.assertTrue((boolean)model.contains(ResourceFactory.createResource((String)"info:fedora/fedora-system:def/internal#"), RdfLexicon.HAS_NAMESPACE_PREFIX, "fedora-internal"));
        Assert.assertTrue((boolean)model.contains(ResourceFactory.createResource((String)"registered-uri#"), RdfLexicon.HAS_NAMESPACE_PREFIX, "some-prefix"));
    }

    @Test
    public void testGetJcrVersionsModel() throws Exception {
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        VersionManager versionManager = (VersionManager)Mockito.mock(VersionManager.class);
        VersionHistory versionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Mockito.when((Object)versionManager.getVersionHistory(this.mockNode.getPath())).thenReturn((Object)versionHistory);
        VersionIterator versionIterator = (VersionIterator)Mockito.mock(VersionIterator.class);
        Mockito.when((Object)versionIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Version version = (Version)Mockito.mock(Version.class);
        javax.jcr.Node node = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/jcr:system/versions/test/jcr");
        Mockito.when((Object)version.getFrozenNode()).thenReturn((Object)node);
        Mockito.when((Object)versionIterator.nextVersion()).thenReturn((Object)version);
        Mockito.when((Object)versionHistory.getAllVersions()).thenReturn((Object)versionIterator);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)versionManager);
        Mockito.when((Object)versionHistory.getVersionLabels(version)).thenReturn((Object)new String[]{"abc"});
        PropertyIterator propertyIterator = (PropertyIterator)Mockito.mock(PropertyIterator.class);
        Mockito.when((Object)propertyIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)node.getProperties()).thenReturn((Object)propertyIterator);
        Model model = JcrRdfTools.getJcrVersionsModel((GraphSubjects)this.testSubjects, (javax.jcr.Node)this.mockNode);
        Assert.assertTrue((boolean)model.contains(this.testSubjects.getGraphSubject(this.mockNode), RdfLexicon.HAS_VERSION, (RDFNode)this.testSubjects.getGraphSubject(node)));
        Assert.assertTrue((boolean)model.contains(this.testSubjects.getGraphSubject(node), RdfLexicon.HAS_VERSION_LABEL, (RDFNode)model.createLiteral("abc")));
    }

    private void mockNamespaceRegistry() throws RepositoryException {
        this.mockNsRegistry = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
        Mockito.when((Object)this.mockNsRegistry.isRegisteredUri("registered-uri#")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNsRegistry.isRegisteredUri("not-registered-uri#")).thenReturn((Object)false);
        Mockito.when((Object)this.mockNsRegistry.isRegisteredUri("http://www.jcp.org/jcr/1.0")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNsRegistry.getPrefix("http://www.jcp.org/jcr/1.0")).thenReturn((Object)"jcr");
        Mockito.when((Object)this.mockNsRegistry.getPrefix("registered-uri#")).thenReturn((Object)"some-prefix");
        Mockito.when((Object)this.mockNsRegistry.getURI("jcr")).thenReturn((Object)"http://www.jcp.org/jcr/1.0");
        Mockito.when((Object)this.mockNsRegistry.getURI("some-prefix")).thenReturn((Object)"registered-uri#");
        Mockito.when((Object)this.mockNsRegistry.getPrefixes()).thenReturn((Object)new String[]{"jcr", "some-prefix"});
        Mockito.when((Object)NamespaceTools.getNamespaceRegistry((Session)this.mockSession)).thenReturn((Object)this.mockNsRegistry);
        Mockito.when((Object)NamespaceTools.getNamespaceRegistry((Item)this.mockNode)).thenReturn((Object)this.mockNsRegistry);
    }
}

