/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.fcrepo.utils.ContentDigest;
import org.fcrepo.utils.FixityResult;
import org.fcrepo.utils.LowLevelCacheEntry;
import org.fcrepo.utils.impl.CacheStoreEntry;
import org.fcrepo.utils.impl.LocalBinaryStoreEntry;
import org.fcrepo.utils.infinispan.StoreChunkInputStream;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.FileSystemBinaryStore;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={StoreChunkInputStream.class})
public class LowLevelCacheEntryTest {
    LowLevelCacheEntry testObj;
    LowLevelCacheEntry testIspnObj;
    BinaryStore mockStore;
    BinaryStore mockIspnStore;
    CacheStore mockLowLevelCacheStore;
    BinaryKey testKey;

    @Before
    public void setUp() throws Exception {
        this.mockStore = (BinaryStore)Mockito.mock(BinaryStore.class);
        this.testKey = new BinaryKey("test-key-123");
        this.testObj = new LocalBinaryStoreEntry(this.mockStore, this.testKey);
        this.mockIspnStore = (BinaryStore)Mockito.mock(InfinispanBinaryStore.class);
        this.mockLowLevelCacheStore = (CacheStore)Mockito.mock(CacheStore.class);
        this.testIspnObj = new CacheStoreEntry(this.mockLowLevelCacheStore, "foo", this.testKey);
    }

    @Test
    public void shouldBeEqualIfTheKeyAndStoreAreEqual() throws Exception {
        LocalBinaryStoreEntry localBinaryStoreEntry = new LocalBinaryStoreEntry(this.mockStore, this.testKey);
        Assert.assertTrue((boolean)this.testObj.equals(localBinaryStoreEntry));
    }

    @Test
    public void shouldBeEqualIfTheKeyStoreAndCacheStoreAreEqual() throws Exception {
        CacheStoreEntry cacheStoreEntry = new CacheStoreEntry(this.mockLowLevelCacheStore, "foo", this.testKey);
        Assert.assertTrue((boolean)this.testIspnObj.equals(cacheStoreEntry));
    }

    @Test
    public void shouldNotBeEqualIfTheOtherObjectIsTotallyDifferent() throws Exception {
        Assert.assertFalse((boolean)this.testObj.equals(""));
    }

    @Test
    public void shouldNotBeEqualIfTheBinaryKeyIsDifferent() throws Exception {
        LocalBinaryStoreEntry localBinaryStoreEntry = new LocalBinaryStoreEntry(this.mockStore, new BinaryKey("321-yek-tset"));
        Assert.assertFalse((boolean)this.testObj.equals(localBinaryStoreEntry));
    }

    @Test
    public void shouldNotBeEqualIfTheStoreIsDifferent() throws Exception {
        BinaryStore binaryStore = (BinaryStore)Mockito.mock(BinaryStore.class);
        LocalBinaryStoreEntry localBinaryStoreEntry = new LocalBinaryStoreEntry(binaryStore, this.testKey);
        Assert.assertFalse((boolean)this.testObj.equals(localBinaryStoreEntry));
    }

    @Test
    public void testGetInputStream() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.mockStore.getInputStream(this.testKey)).thenReturn((Object)inputStream);
        Assert.assertEquals((Object)inputStream, (Object)this.testObj.getInputStream());
        ((BinaryStore)Mockito.verify((Object)this.mockStore)).getInputStream(this.testKey);
    }

    @Test
    public void testGetInputStreamWithAnInfinispanStore() throws Exception {
        PowerMockito.mockStatic(StoreChunkInputStream.class, (Class[])new Class[0]);
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.mockStore.getInputStream(this.testKey)).thenReturn((Object)inputStream);
        InputStream inputStream2 = this.testIspnObj.getInputStream();
        Assert.assertTrue((boolean)(inputStream2 instanceof StoreChunkInputStream));
    }

    @Test
    public void testStoreValue() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        this.testObj.storeValue(inputStream);
        ((BinaryStore)Mockito.verify((Object)this.mockStore)).storeValue(inputStream);
        CacheStoreConfig cacheStoreConfig = (CacheStoreConfig)Mockito.mock(CacheStoreConfig.class);
        Mockito.when((Object)cacheStoreConfig.toString()).thenReturn((Object)"mockCacheStoreConfig");
        Mockito.when((Object)this.mockLowLevelCacheStore.getCacheStoreConfig()).thenReturn((Object)cacheStoreConfig);
        CacheStoreEntry cacheStoreEntry = new CacheStoreEntry(this.mockLowLevelCacheStore, "foo", this.testKey);
        byte[] byArray = new byte[]{0, 1, 2, 3, 4};
        cacheStoreEntry.storeValue((InputStream)new ByteArrayInputStream(byArray));
        ((CacheStore)Mockito.verify((Object)this.mockLowLevelCacheStore)).store((InternalCacheEntry)Matchers.any(InternalCacheEntry.class));
    }

    @Test
    public void testGetExternalIdentifier() throws Exception {
        Mockito.when((Object)this.mockStore.toString()).thenReturn((Object)"i-am-a-mock-store");
        this.testObj.setExternalId("zyx");
        Assert.assertEquals((Object)"zyx/i-am-a-mock-store", (Object)this.testObj.getExternalIdentifier());
    }

    @Test
    public void testFileSystemExternalIdentifier() throws Exception {
        FileSystemBinaryStore fileSystemBinaryStore = (FileSystemBinaryStore)Mockito.mock(FileSystemBinaryStore.class);
        Mockito.when((Object)fileSystemBinaryStore.getDirectory()).thenReturn((Object)new File("/tmp/xyz"));
        LocalBinaryStoreEntry localBinaryStoreEntry = new LocalBinaryStoreEntry((BinaryStore)fileSystemBinaryStore, this.testKey);
        localBinaryStoreEntry.setExternalId("zyx");
        String string = localBinaryStoreEntry.getExternalIdentifier();
        Assert.assertTrue((boolean)string.startsWith("zyx/org.modeshape.jcr.value.binary.FileSystemBinaryStore"));
        Assert.assertTrue((boolean)string.endsWith(File.separator + "tmp" + File.separator + "xyz"));
    }

    @Test
    public void testGetFixity() throws BinaryStoreException, IOException, NoSuchAlgorithmException {
        LocalBinaryStoreEntry localBinaryStoreEntry = new LocalBinaryStoreEntry(this.mockStore, this.testKey);
        final byte[] byArray = new byte[]{0, 1, 2, 3, 4};
        Mockito.when((Object)this.mockStore.getInputStream(this.testKey)).thenAnswer((Answer)new Answer<InputStream>(){

            public InputStream answer(InvocationOnMock invocationOnMock) throws Throwable {
                return new ByteArrayInputStream(byArray);
            }
        });
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] byArray2 = messageDigest.digest(byArray);
        URI uRI = ContentDigest.asURI((String)"SHA-1", (byte[])byArray2);
        System.out.println(uRI);
        FixityResult fixityResult = localBinaryStoreEntry.checkFixity(uRI, (long)byArray.length);
        Assert.assertEquals((long)1L, (long)fixityResult.status.size());
        Assert.assertEquals((String)((FixityResult.FixityState)fixityResult.status.iterator().next()).toString(), (Object)true, (Object)fixityResult.status.contains(FixityResult.FixityState.SUCCESS));
        fixityResult = localBinaryStoreEntry.checkFixity(uRI, (long)(byArray.length + 1));
        Assert.assertEquals((long)1L, (long)fixityResult.status.size());
        Assert.assertEquals((String)((FixityResult.FixityState)fixityResult.status.iterator().next()).toString(), (Object)true, (Object)fixityResult.status.contains(FixityResult.FixityState.BAD_SIZE));
        byArray2[0] = (byte)(byArray2[0] + 9);
        uRI = ContentDigest.asURI((String)"SHA-1", (byte[])byArray2);
        fixityResult = localBinaryStoreEntry.checkFixity(uRI, (long)byArray.length);
        Assert.assertEquals((long)1L, (long)fixityResult.status.size());
        Assert.assertEquals((String)((FixityResult.FixityState)fixityResult.status.iterator().next()).toString(), (Object)true, (Object)fixityResult.status.contains(FixityResult.FixityState.BAD_CHECKSUM));
        fixityResult = localBinaryStoreEntry.checkFixity(uRI, (long)(byArray.length + 1));
        Assert.assertEquals((long)2L, (long)fixityResult.status.size());
        Assert.assertEquals((Object)true, (Object)fixityResult.status.contains(FixityResult.FixityState.BAD_CHECKSUM));
        Assert.assertEquals((Object)true, (Object)fixityResult.status.contains(FixityResult.FixityState.BAD_SIZE));
    }
}

