/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utils;

import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.fcrepo.RdfLexicon;
import org.fcrepo.utils.NamespaceChangedStatementListener;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class NamespaceChangedStatementListenerTest {
    private NamespaceChangedStatementListener testObj;
    private NamespaceRegistry mockNamespaceRegistry;

    @Before
    public void setUp() throws RepositoryException {
        Session session = (Session)Mockito.mock(Session.class);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        this.mockNamespaceRegistry = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
        Mockito.when((Object)workspace.getNamespaceRegistry()).thenReturn((Object)this.mockNamespaceRegistry);
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        this.testObj = new NamespaceChangedStatementListener(session);
    }

    @Test
    public void shouldAddNamespaceStatement() throws RepositoryException {
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)statement.getSubject()).thenReturn((Object)ResourceFactory.createResource((String)"uri"));
        Mockito.when((Object)statement.getPredicate()).thenReturn((Object)RdfLexicon.HAS_NAMESPACE_PREFIX);
        Mockito.when((Object)statement.getObject()).thenReturn((Object)ResourceFactory.createPlainLiteral((String)"123"));
        this.testObj.addedStatement(statement);
        ((NamespaceRegistry)Mockito.verify((Object)this.mockNamespaceRegistry)).registerNamespace("123", "uri");
    }

    @Test
    public void shouldIgnoreNonNamespaceStatements() throws RepositoryException {
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)statement.getSubject()).thenReturn((Object)ResourceFactory.createResource((String)"uri"));
        Mockito.when((Object)statement.getPredicate()).thenReturn((Object)ResourceFactory.createProperty((String)"some-random-predicate"));
        Mockito.when((Object)statement.getObject()).thenReturn((Object)ResourceFactory.createPlainLiteral((String)"abc"));
        this.testObj.addedStatement(statement);
        ((NamespaceRegistry)Mockito.verify((Object)this.mockNamespaceRegistry, (VerificationMode)Mockito.never())).registerNamespace("abc", "uri");
    }

    @Test
    public void shouldRemoveNamespaceStatement() throws RepositoryException {
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)statement.getSubject()).thenReturn((Object)ResourceFactory.createResource((String)"uri"));
        Mockito.when((Object)statement.getPredicate()).thenReturn((Object)RdfLexicon.HAS_NAMESPACE_PREFIX);
        Mockito.when((Object)statement.getObject()).thenReturn((Object)ResourceFactory.createPlainLiteral((String)"123"));
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefix("uri")).thenReturn((Object)"123");
        this.testObj.removedStatement(statement);
        ((NamespaceRegistry)Mockito.verify((Object)this.mockNamespaceRegistry)).unregisterNamespace("123");
    }

    @Test
    public void shouldIgnoreNonMatchingNamespacesOnRemoveNamespaceStatement() throws RepositoryException {
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)statement.getSubject()).thenReturn((Object)ResourceFactory.createResource((String)"uri"));
        Mockito.when((Object)statement.getPredicate()).thenReturn((Object)RdfLexicon.HAS_NAMESPACE_PREFIX);
        Mockito.when((Object)statement.getObject()).thenReturn((Object)ResourceFactory.createPlainLiteral((String)"456"));
        Mockito.when((Object)this.mockNamespaceRegistry.getPrefix("uri")).thenReturn((Object)"123");
        this.testObj.removedStatement(statement);
        ((NamespaceRegistry)Mockito.verify((Object)this.mockNamespaceRegistry, (VerificationMode)Mockito.never())).unregisterNamespace("456");
    }

    @Test
    public void shouldIgnoreNonNamespaceStatementsOnRemove() throws RepositoryException {
        Statement statement = (Statement)Mockito.mock(Statement.class);
        Mockito.when((Object)statement.getSubject()).thenReturn((Object)ResourceFactory.createResource((String)"uri"));
        Mockito.when((Object)statement.getPredicate()).thenReturn((Object)ResourceFactory.createProperty((String)"some-random-predicate"));
        Mockito.when((Object)statement.getObject()).thenReturn((Object)ResourceFactory.createPlainLiteral((String)"abc"));
        this.testObj.removedStatement(statement);
        ((NamespaceRegistry)Mockito.verify((Object)this.mockNamespaceRegistry, (VerificationMode)Mockito.never())).unregisterNamespace("abc");
    }
}

