/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utils;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.fcrepo.utils.FedoraTypesUtils;
import org.fcrepo.utils.NodePropertiesTools;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={FedoraTypesUtils.class})
public class NodePropertiesToolsTest {
    private PropertyDefinition mockDefinition;
    private Value mockValue;
    private Node mockNode;
    private Property mockProperty;

    @Before
    public void setUp() throws RepositoryException {
        PowerMockito.mockStatic(FedoraTypesUtils.class, (Class[])new Class[0]);
        this.mockDefinition = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        this.mockProperty = (Property)Mockito.mock(Property.class);
        this.mockValue = (Value)Mockito.mock(Value.class);
        this.mockNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)FedoraTypesUtils.getDefinitionForPropertyName((Node)this.mockNode, (String)"mockPropertyName")).thenReturn((Object)this.mockDefinition);
        Mockito.when((Object)this.mockNode.getProperty("mockPropertyName")).thenReturn((Object)this.mockProperty);
    }

    @Test
    public void addNewSingleValuedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockDefinition.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)false);
        NodePropertiesTools.appendOrReplaceNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Node)Mockito.verify((Object)this.mockNode)).setProperty("mockPropertyName", this.mockValue);
    }

    @Test
    public void addNewMultiValuedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockDefinition.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)false);
        NodePropertiesTools.appendOrReplaceNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Node)Mockito.verify((Object)this.mockNode)).setProperty("mockPropertyName", Arrays.asList(this.mockValue).toArray(new Value[0]));
    }

    @Test
    public void replaceExistingSingleValuedPropertyWithValue() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        NodePropertiesTools.appendOrReplaceNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue(this.mockValue);
    }

    @Test
    public void appendValueToExistingMultivaluedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        Value value = (Value)Mockito.mock(Value.class);
        Value[] valueArray = new Value[]{value};
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)valueArray);
        NodePropertiesTools.appendOrReplaceNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Value[].class);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue((Value[])argumentCaptor.capture());
        List<Object> list = Arrays.asList((Object[])argumentCaptor.getValue());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((String)"actual values missing previous value", (boolean)list.contains(value));
        Assert.assertTrue((String)"actual values missing value we were adding", (boolean)list.contains(this.mockValue));
    }

    @Test
    public void addMultiValuedPropertyWithSameValueAsExistingProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        Value value = this.mockValue;
        Value[] valueArray = new Value[]{value};
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)valueArray);
        NodePropertiesTools.appendOrReplaceNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Property)Mockito.verify((Object)this.mockProperty, (VerificationMode)Mockito.never())).setValue((Value[])Matchers.any(Value[].class));
    }

    @Test
    public void shouldBeANoopWhenRemovingPropertyThatDoesntExist() throws RepositoryException {
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)false);
        NodePropertiesTools.removeNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Node)Mockito.verify((Object)this.mockNode)).hasProperty("mockPropertyName");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockNode});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockProperty});
    }

    @Test
    public void shouldRemoveASingleValuedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"");
        NodePropertiesTools.removeNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue((Value)null);
    }

    @Test
    public void shouldRemoveAMultiValuedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        Value[] valueArray = new Value[]{this.mockValue};
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)valueArray);
        NodePropertiesTools.removeNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue((Value[])null);
    }

    @Test
    public void shouldRemoveAValueFromMultiValuedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        Value value = (Value)Mockito.mock(Value.class);
        Value[] valueArray = new Value[]{value, this.mockValue};
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)valueArray);
        NodePropertiesTools.removeNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Value[].class);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue((Value[])argumentCaptor.capture());
        Value[] valueArray2 = (Value[])argumentCaptor.getValue();
        Assert.assertEquals((long)1L, (long)valueArray2.length);
        Assert.assertTrue((String)"removed the wrong value", (boolean)value.equals(valueArray2[0]));
        Assert.assertTrue((String)"found the value we were removing", (!this.mockValue.equals(valueArray2[0]) ? 1 : 0) != 0);
    }

    @Test
    public void shouldRemoveAllMatchingValuesFromAMultivaluedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        Value[] valueArray = new Value[]{this.mockValue, this.mockValue};
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)valueArray);
        NodePropertiesTools.removeNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue((Value[])null);
    }
}

