/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.fcrepo.utils.ContentDigest;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class TestHelpers {
    private static final SecureRandom GARBAGE_GENERATOR = new SecureRandom("G4RbAG3".getBytes());

    public static Node getContentNodeMock(int n) {
        return TestHelpers.getContentNodeMock(TestHelpers.randomData(n));
    }

    public static Node getContentNodeMock(String string) {
        return TestHelpers.getContentNodeMock(string.getBytes());
    }

    public static Node getContentNodeMock(final byte[] byArray) {
        Node node = (Node)Mockito.mock(Node.class);
        long l = byArray.length;
        String string = TestHelpers.checksumString(byArray);
        Property property = (Property)Mockito.mock(Property.class);
        Property property2 = (Property)Mockito.mock(Property.class);
        Property property3 = (Property)Mockito.mock(Property.class);
        Property property4 = (Property)Mockito.mock(Property.class);
        Property property5 = (Property)Mockito.mock(Property.class);
        Binary binary = (Binary)Mockito.mock(Binary.class);
        try {
            Mockito.when((Object)property.getLong()).thenReturn((Object)l);
            Mockito.when((Object)binary.getSize()).thenReturn((Object)l);
            Mockito.when((Object)binary.getStream()).thenAnswer((Answer)new Answer<InputStream>(){

                public InputStream answer(InvocationOnMock invocationOnMock) {
                    return new ByteArrayInputStream(byArray);
                }
            });
            Mockito.when((Object)property2.getBinary()).thenReturn((Object)binary);
            Mockito.when((Object)property3.getString()).thenReturn((Object)string);
            Mockito.when((Object)property4.getString()).thenReturn((Object)"SHA-1");
            Mockito.when((Object)node.getProperty("jcr:data")).thenReturn((Object)property2);
            Mockito.when((Object)node.getProperty("fedora:size")).thenReturn((Object)property);
            Mockito.when((Object)node.getProperty("fedora:digest")).thenReturn((Object)property3);
            Mockito.when((Object)node.getProperty("jcr:createdby")).thenReturn((Object)property5);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return node;
    }

    public static String checksumString(String string) {
        return TestHelpers.checksumString(string.getBytes());
    }

    public static String checksumString(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray2 = messageDigest.digest(byArray);
            return ContentDigest.asURI((String)"SHA-1", (byte[])byArray2).toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            return "";
        }
    }

    public static PropertyIterator getPropertyIterator(int n, long l) {
        PropertyIterator propertyIterator = (PropertyIterator)Mockito.mock(PropertyIterator.class);
        Property property = (Property)Mockito.mock(Property.class);
        try {
            Mockito.when((Object)property.isMultiple()).thenReturn((Object)(n > 1 ? 1 : 0));
            if (n != 1) {
                Value[] valueArray = new Value[n];
                for (int i = 0; i < n; ++i) {
                    Value value = (Value)Mockito.mock(Value.class);
                    Binary binary = (Binary)Mockito.mock(Binary.class);
                    Mockito.when((Object)value.getBinary()).thenReturn((Object)binary);
                    Mockito.when((Object)binary.getSize()).thenReturn((Object)l);
                    valueArray[i] = value;
                }
                Mockito.when((Object)property.getValues()).thenReturn((Object)valueArray);
            } else {
                Binary binary = (Binary)Mockito.mock(Binary.class);
                Mockito.when((Object)binary.getSize()).thenReturn((Object)l);
                Mockito.when((Object)property.getBinary()).thenReturn((Object)binary);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        Mockito.when((Object)propertyIterator.getSize()).thenReturn((Object)1L);
        Mockito.when((Object)propertyIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)propertyIterator.nextProperty()).thenReturn((Object)property).thenThrow(new Class[]{IndexOutOfBoundsException.class});
        return propertyIterator;
    }

    public static byte[] randomData(int n) {
        byte[] byArray = new byte[n];
        GARBAGE_GENERATOR.nextBytes(byArray);
        return byArray;
    }
}

