/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utils.infinispan;

import java.io.IOException;
import org.fcrepo.utils.TestHelpers;
import org.fcrepo.utils.infinispan.StoreChunkInputStream;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class StoreChunkInputStreamTest {
    private static final int DATA_SIZE = 1024;
    private StoreChunkInputStream testObj;
    private CacheStore mockStore;
    private InternalCacheEntry mockEntry;
    private String mockKey = "key-to-a-mock-blob";
    private String mockFirstChunk = this.mockKey + "-0";

    @Before
    public void setUp() throws CacheLoaderException {
        this.mockStore = (CacheStore)Mockito.mock(CacheStore.class);
        Mockito.when((Object)this.mockStore.containsKey((Object)this.mockFirstChunk)).thenReturn((Object)true);
        this.mockEntry = (InternalCacheEntry)Mockito.mock(InternalCacheEntry.class);
        this.testObj = new StoreChunkInputStream(this.mockStore, this.mockKey);
    }

    @Test
    public void testRead() throws IOException {
        this.testObj.read();
    }

    @Test
    public void testBufferedRead() throws IOException, CacheLoaderException {
        InternalCacheEntry internalCacheEntry = (InternalCacheEntry)Mockito.mock(InternalCacheEntry.class);
        byte[] byArray = TestHelpers.randomData(1024);
        Mockito.when((Object)internalCacheEntry.getValue()).thenReturn((Object)byArray);
        Mockito.when((Object)this.mockStore.load((Object)Matchers.anyString())).thenReturn((Object)internalCacheEntry).thenReturn((Object)internalCacheEntry).thenReturn(null);
        int n = 234;
        int n2 = 1024 - n;
        byte[] byArray2 = new byte[1024];
        long l = this.testObj.read(byArray2, 0, n2);
        Assert.assertEquals((long)n2, (long)l);
        l = this.testObj.read(byArray2, 0, 1024);
        Assert.assertEquals((long)n, (long)l);
        l = this.testObj.read(byArray2, 0, 1024);
        Assert.assertEquals((long)1024L, (long)l);
        l = this.testObj.read(byArray2, 0, 1024);
        Assert.assertEquals((long)-1L, (long)l);
    }

    @Test
    public void testAvailable() throws IOException, CacheLoaderException {
        byte[] byArray = TestHelpers.randomData(1024);
        Mockito.when((Object)this.mockEntry.getValue()).thenReturn((Object)byArray);
        Mockito.when((Object)this.mockStore.load((Object)this.mockFirstChunk)).thenReturn((Object)this.mockEntry);
        Assert.assertEquals((long)0L, (long)this.testObj.available());
        int n = 435;
        this.testObj.skip((long)n);
        Assert.assertEquals((long)(1024 - n), (long)this.testObj.available());
        this.testObj.skip((long)(1024 - n));
        Assert.assertEquals((long)0L, (long)this.testObj.available());
        this.testObj.skip(1L);
        Assert.assertEquals((long)-1L, (long)this.testObj.available());
    }

    @Test
    public void testSkip() throws IOException, CacheLoaderException {
        long l = 1023L;
        byte[] byArray = TestHelpers.randomData(1024);
        Mockito.when((Object)this.mockEntry.getValue()).thenReturn((Object)byArray);
        Mockito.when((Object)this.mockStore.load((Object)this.mockFirstChunk)).thenReturn((Object)this.mockEntry);
        long l2 = this.testObj.skip(l);
        Assert.assertEquals((long)l, (long)l2);
        ((CacheStore)Mockito.verify((Object)this.mockStore)).load((Object)Matchers.anyString());
        ((CacheStore)Mockito.verify((Object)this.mockStore)).load((Object)this.mockFirstChunk);
        ((InternalCacheEntry)Mockito.verify((Object)this.mockEntry)).getValue();
        Assert.assertTrue((this.testObj.read() > -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)this.testObj.read());
    }

    @Test
    public void testSkipMultipleBuffers() throws IOException, CacheLoaderException {
        InternalCacheEntry internalCacheEntry = (InternalCacheEntry)Mockito.mock(InternalCacheEntry.class);
        byte[] byArray = TestHelpers.randomData(1024);
        Mockito.when((Object)internalCacheEntry.getValue()).thenReturn((Object)byArray);
        Mockito.when((Object)this.mockStore.load((Object)Matchers.anyString())).thenReturn((Object)internalCacheEntry).thenReturn((Object)internalCacheEntry).thenReturn(null);
        long l = 1024L;
        long l2 = this.testObj.skip(1025L);
        Assert.assertEquals((long)l, (long)l2);
        l = 1023L;
        l2 = this.testObj.skip(l);
        Assert.assertEquals((long)l, (long)l2);
        Assert.assertTrue((this.testObj.read() > -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)this.testObj.read());
        ((InternalCacheEntry)Mockito.verify((Object)internalCacheEntry, (VerificationMode)Mockito.times((int)2))).getValue();
    }

    @Test
    public void testNextChunk() throws IOException {
        this.testObj.nextChunk();
    }
}

