/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utils.infinispan;

import java.io.IOException;
import org.fcrepo.utils.TestHelpers;
import org.fcrepo.utils.infinispan.StoreChunkOutputStream;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class StoreChunkOutputStreamTest {
    private static final int DATA_SIZE = 1024;
    private StoreChunkOutputStream testObj;
    private CacheStore mockStore;
    private InternalCacheEntry mockEntry;
    private String mockKey = "key-to-a-mock-blob";

    @Before
    public void setUp() {
        this.mockStore = (CacheStore)Mockito.mock(CacheStore.class);
        this.mockEntry = (InternalCacheEntry)Mockito.mock(InternalCacheEntry.class);
        this.testObj = new StoreChunkOutputStream(this.mockStore, this.mockKey);
    }

    @Test
    public void testWritingMultipleChunks() throws IOException, CacheLoaderException {
        byte[] byArray = TestHelpers.randomData(1024);
        for (int i = 0; i < 1025; ++i) {
            this.testObj.write(byArray);
        }
        this.testObj.close();
        ((CacheStore)Mockito.verify((Object)this.mockStore, (VerificationMode)Mockito.times((int)2))).store((InternalCacheEntry)Matchers.any(InternalCacheEntry.class));
        Assert.assertEquals((long)2L, (long)this.testObj.getNumberChunks());
    }

    @Test
    public void testWritingMultipleChunksOnVersionedKey() throws IOException, CacheLoaderException {
        byte[] byArray = TestHelpers.randomData(1024);
        Mockito.when((Object)this.mockStore.load((Object)(this.mockKey + "-0"))).thenReturn((Object)this.mockEntry);
        for (int i = 0; i < 1025; ++i) {
            this.testObj.write(byArray);
        }
        this.testObj.close();
        ((CacheStore)Mockito.verify((Object)this.mockStore)).load((Object)(this.mockKey + "-0"));
        ((CacheStore)Mockito.verify((Object)this.mockStore, (VerificationMode)Mockito.times((int)2))).store((InternalCacheEntry)Matchers.any(InternalCacheEntry.class));
        Assert.assertEquals((long)2L, (long)this.testObj.getNumberChunks());
    }
}

