/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.update.UpdateAction;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.integration.kernel.AbstractIT;
import org.fcrepo.kernel.FedoraObject;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.impl.DefaultGraphSubjects;
import org.fcrepo.kernel.services.ObjectService;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class FedoraObjectIT
extends AbstractIT {
    @Inject
    Repository repo;
    @Inject
    ObjectService objectService;

    @Test
    public void testCreatedObject() throws RepositoryException, IOException {
        Session session = this.repo.login();
        this.objectService.createObject(session, "/testObject");
        session.save();
        session.logout();
        session = this.repo.login();
        FedoraObject obj = this.objectService.getObject(session, "/testObject");
        Assert.assertNotNull((String)"Couldn't find object!", (Object)obj);
    }

    @Test
    public void testGetSizeWhenInATree() throws Exception {
        Session session = this.repo.login();
        FedoraObject object = this.objectService.createObject(session, "/parentObject");
        long originalSize = object.getSize();
        this.objectService.createObject(session, "/parentObject/testChildObject");
        session.save();
        Assert.assertTrue((this.objectService.getObject(session, "/parentObject").getSize() > originalSize ? 1 : 0) != 0);
    }

    @Test
    public void testObjectGraph() throws Exception {
        Session session = this.repo.login();
        FedoraObject object = this.objectService.createObject(session, "/graphObject");
        Dataset graphStore = object.getPropertiesDataset((GraphSubjects)new DefaultGraphSubjects(session));
        String graphSubject = "http://fedora.info/definitions/v4/rest-api#/graphObject";
        Assert.assertFalse((String)"Graph store should not contain JCR prefixes", (boolean)Pattern.compile("jcr").matcher(graphStore.toString()).find());
        Assert.assertFalse((String)"Graph store should contain our fcrepo prefix", (boolean)Pattern.compile("fcrepo").matcher(graphStore.toString()).find());
        UpdateAction.parseExecute((String)"PREFIX dc: <http://purl.org/dc/terms/>\nINSERT { <http://example/egbook> dc:title \"This is an example of an update that will be ignored\" } WHERE {}", (Dataset)graphStore);
        UpdateAction.parseExecute((String)"PREFIX dc: <http://purl.org/dc/terms/>\nINSERT { <http://fedora.info/definitions/v4/rest-api#/graphObject> dc:title \"This is an example title\" } WHERE {}", (Dataset)graphStore);
        Assert.assertTrue((String)object.getNode().getProperty("dc:title").getValues()[0].getString(), (boolean)object.getNode().getProperty("dc:title").getValues()[0].getString().equals("This is an example title"));
        UpdateAction.parseExecute((String)"PREFIX myurn: <info:myurn/>\nINSERT { <http://fedora.info/definitions/v4/rest-api#/graphObject> myurn:info \"This is some example data\";myurn:info  \"And so it this\"     } WHERE {}", (Dataset)graphStore);
        Value[] values = object.getNode().getProperty(object.getNode().getSession().getNamespacePrefix("info:myurn/") + ":info").getValues();
        Assert.assertEquals((Object)"This is some example data", (Object)values[0].getString());
        Assert.assertEquals((Object)"And so it this", (Object)values[1].getString());
        UpdateAction.parseExecute((String)"PREFIX fedora-rels-ext: <http://fedora.info/definitions/v4/rels-ext#>\nINSERT { <http://fedora.info/definitions/v4/rest-api#/graphObject> fedora-rels-ext:isPartOf <http://fedora.info/definitions/v4/rest-api#/graphObject> } WHERE {}", (Dataset)graphStore);
        Assert.assertTrue((String)object.getNode().getProperty("fedorarelsext:isPartOf").getValues()[0].getString(), (boolean)object.getNode().getProperty("fedorarelsext:isPartOf").getValues()[0].getString().equals(object.getNode().getIdentifier()));
        UpdateAction.parseExecute((String)"PREFIX dc: <http://purl.org/dc/terms/>\nDELETE { <http://fedora.info/definitions/v4/rest-api#/graphObject> dc:title \"This is an example title\" } WHERE {}", (Dataset)graphStore);
        Assert.assertFalse((String)"Found unexpected dc:title", (boolean)object.getNode().hasProperty("dc:title"));
        UpdateAction.parseExecute((String)"PREFIX fedora-rels-ext: <http://fedora.info/definitions/v4/rels-ext#>\nDELETE { <http://fedora.info/definitions/v4/rest-api#/graphObject> fedora-rels-ext:isPartOf <http://fedora.info/definitions/v4/rest-api#/graphObject> } WHERE {}", (Dataset)graphStore);
        Assert.assertFalse((String)"found unexpected reference", (boolean)object.getNode().hasProperty("fedorarelsext:isPartOf"));
        session.save();
    }
}

