/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.integration.kernel.AbstractIT;
import org.fcrepo.kernel.FedoraObject;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.impl.DefaultGraphSubjects;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.services.ObjectService;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class FedoraResourceIT
extends AbstractIT {
    @Inject
    Repository repo;
    @Inject
    NodeService nodeService;
    @Inject
    ObjectService objectService;
    @Inject
    DatastreamService datastreamService;
    private Session session;
    private DefaultGraphSubjects subjects;

    @Before
    public void setUp() throws RepositoryException {
        this.session = this.repo.login();
        this.subjects = new DefaultGraphSubjects(this.session);
    }

    @After
    public void tearDown() {
        this.session.logout();
    }

    @Test
    public void testGetRootNode() throws IOException, RepositoryException {
        Session session = this.repo.login();
        FedoraResource object = this.nodeService.getObject(session, "/");
        Assert.assertEquals((Object)"/", (Object)object.getPath());
        session.logout();
    }

    @Test
    public void testRandomNodeGraph() throws IOException, RepositoryException {
        FedoraResource object = this.nodeService.findOrCreateObject(this.session, "/testNodeGraph");
        this.logger.warn(object.getPropertiesDataset((GraphSubjects)new DefaultGraphSubjects(this.session)).toString());
        Node s = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testNodeGraph");
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#primaryType");
        Node o = NodeFactory.createLiteral((String)"nt:unstructured");
        Assert.assertTrue((boolean)object.getPropertiesDataset((GraphSubjects)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
    }

    @Test
    public void testRepositoryRootGraph() throws IOException, RepositoryException {
        FedoraResource object = this.nodeService.getObject(this.session, "/");
        this.logger.warn(object.getPropertiesDataset((GraphSubjects)this.subjects).toString());
        Node s = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/");
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#primaryType");
        Node o = NodeFactory.createLiteral((String)"mode:root");
        Assert.assertTrue((boolean)object.getPropertiesDataset((GraphSubjects)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#repository/jcr.repository.vendor.url");
        o = NodeFactory.createLiteral((String)"http://www.modeshape.org");
        Assert.assertTrue((boolean)object.getPropertiesDataset((GraphSubjects)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#hasNodeType");
        o = NodeFactory.createLiteral((String)"fedora:resource");
        Assert.assertTrue((boolean)object.getPropertiesDataset((GraphSubjects)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
    }

    @Test
    public void testObjectGraph() throws IOException, RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectGraph");
        this.logger.warn(object.getPropertiesDataset((GraphSubjects)this.subjects).toString());
        Node s = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testObjectGraph");
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#uuid");
        Node o = NodeFactory.createLiteral((String)object.getNode().getIdentifier());
        Assert.assertTrue((boolean)object.getPropertiesDataset((GraphSubjects)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#mixinTypes");
        o = NodeFactory.createLiteral((String)"fedora:resource");
        Assert.assertTrue((boolean)object.getPropertiesDataset((GraphSubjects)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
        o = NodeFactory.createLiteral((String)"fedora:object");
        Assert.assertTrue((boolean)object.getPropertiesDataset((GraphSubjects)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
    }

    @Test
    public void testDatastreamGraph() throws IOException, RepositoryException, InvalidChecksumException {
        this.objectService.createObject(this.session, "/testDatastreamGraphParent");
        this.datastreamService.createDatastreamNode(this.session, "/testDatastreamGraph", "text/plain", (InputStream)new ByteArrayInputStream("123456789test123456789".getBytes()));
        FedoraResource object = this.nodeService.getObject(this.session, "/testDatastreamGraph");
        object.getNode().setProperty("fedorarelsext:isPartOf", this.session.getNode("/testDatastreamGraphParent"));
        Dataset propertiesDataset = object.getPropertiesDataset((GraphSubjects)this.subjects);
        Assert.assertTrue((boolean)propertiesDataset.getContext().isDefined(Symbol.create((String)"uri")));
        this.logger.warn(propertiesDataset.toString());
        Node s = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testDatastreamGraph");
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#uuid");
        Node o = NodeFactory.createLiteral((String)object.getNode().getIdentifier());
        DatasetGraph datasetGraph = propertiesDataset.asDatasetGraph();
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#mixinTypes");
        o = NodeFactory.createLiteral((String)"fedora:resource");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        o = NodeFactory.createLiteral((String)"fedora:datastream");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#numberOfChildren");
        RDFDatatype long_datatype = ResourceFactory.createTypedLiteral((Object)0L).getDatatype();
        o = NodeFactory.createLiteral((String)"0", (RDFDatatype)long_datatype);
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rels-ext#isPartOf");
        o = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testDatastreamGraphParent");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#hasContent");
        o = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testDatastreamGraph/fcr:content");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        s = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testDatastreamGraph/fcr:content");
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#mimeType");
        o = NodeFactory.createLiteral((String)"text/plain");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#size");
        o = NodeFactory.createLiteral((String)"22", (RDFDatatype)ModelFactory.createDefaultModel().createTypedLiteral(22L).getDatatype());
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#hasLocation");
        o = Node.ANY;
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
    }

    @Test
    public void testObjectGraphWindow() throws IOException, RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectGraphWindow");
        this.objectService.createObject(this.session, "/testObjectGraphWindow/a");
        this.objectService.createObject(this.session, "/testObjectGraphWindow/b");
        this.objectService.createObject(this.session, "/testObjectGraphWindow/c");
        Dataset propertiesDataset = object.getPropertiesDataset((GraphSubjects)this.subjects, 1L, 1);
        this.logger.warn(propertiesDataset.toString());
        DatasetGraph datasetGraph = propertiesDataset.asDatasetGraph();
        Node s = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testObjectGraphWindow");
        Node p = RdfLexicon.HAS_PRIMARY_IDENTIFIER.asNode();
        Node o = NodeFactory.createLiteral((String)object.getNode().getIdentifier());
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        p = RdfLexicon.HAS_CHILD.asNode();
        o = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testObjectGraphWindow/a");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        o = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testObjectGraphWindow/b");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        o = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testObjectGraphWindow/c");
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, o));
        s = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testObjectGraphWindow/b");
        p = RdfLexicon.HAS_PRIMARY_IDENTIFIER.asNode();
        Assert.assertTrue((boolean)datasetGraph.contains(Node.ANY, s, p, Node.ANY));
        s = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testObjectGraphWindow/c");
        Assert.assertFalse((boolean)datasetGraph.contains(Node.ANY, s, p, Node.ANY));
    }

    @Test
    public void testUpdatingObjectGraph() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectGraphUpdates");
        object.updatePropertiesDataset((GraphSubjects)this.subjects, "INSERT { <http://fedora.info/definitions/v4/rest-api#/testObjectGraphUpdates> <info:fcrepo/zyx> \"a\" } WHERE {} ");
        Node s = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testObjectGraphUpdates");
        Node p = NodeFactory.createURI((String)"info:fcrepo/zyx");
        Node o = NodeFactory.createLiteral((String)"a");
        Assert.assertTrue((boolean)object.getPropertiesDataset((GraphSubjects)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
        object.updatePropertiesDataset((GraphSubjects)this.subjects, "DELETE { <http://fedora.info/definitions/v4/rest-api#/testObjectGraphUpdates> <info:fcrepo/zyx> ?o }\nINSERT { <http://fedora.info/definitions/v4/rest-api#/testObjectGraphUpdates> <info:fcrepo/zyx> \"b\" } WHERE { <http://fedora.info/definitions/v4/rest-api#/testObjectGraphUpdates> <info:fcrepo/zyx> ?o } ");
        Assert.assertFalse((String)"found value we should have removed", (boolean)object.getPropertiesDataset((GraphSubjects)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
        o = NodeFactory.createLiteral((String)"b");
        Assert.assertTrue((String)"could not find new value", (boolean)object.getPropertiesDataset((GraphSubjects)this.subjects).asDatasetGraph().contains(Node.ANY, s, p, o));
    }

    @Test
    public void testAddVersionLabel() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectVersionLabel");
        this.session.save();
        object.addVersionLabel("v0.0.1");
        this.session.save();
        Assert.assertTrue((boolean)Arrays.asList(FedoraTypesUtils.getVersionHistory((javax.jcr.Node)object.getNode()).getVersionLabels()).contains("v0.0.1"));
    }

    @Test
    public void testGetObjectVersionGraph() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectVersionGraph");
        this.session.save();
        object.addVersionLabel("v0.0.1");
        this.session.save();
        Dataset graphStore = object.getVersionDataset((GraphSubjects)this.subjects);
        this.logger.info(graphStore.toString());
        Node s = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/rest-api#/testObjectVersionGraph");
        Node p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#hasVersion");
        ExtendedIterator triples = graphStore.asDatasetGraph().getDefaultGraph().find((TripleMatch)Triple.createMatch((Node)s, (Node)p, (Node)Node.ANY));
        List list = triples.toList();
        Assert.assertEquals((long)1L, (long)list.size());
        s = ((Triple)list.get(0)).getMatchObject();
        p = NodeFactory.createURI((String)"http://fedora.info/definitions/v4/repository#hasVersionLabel");
        Node o = NodeFactory.createLiteral((String)"v0.0.1");
        Assert.assertTrue((boolean)graphStore.asDatasetGraph().contains(Node.ANY, s, p, o));
    }

    @Test
    public void testUpdatingRdfTypedValues() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectRdfType");
        Dataset propertiesDataset = object.getPropertiesDataset((GraphSubjects)this.subjects, 0L, -2);
        this.logger.warn(propertiesDataset.toString());
        object.updatePropertiesDataset((GraphSubjects)this.subjects, "PREFIX example: <http://example.org/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\nINSERT { <http://fedora.info/definitions/v4/rest-api#/testObjectRdfType> example:int-property \"0\"^^xsd:long } WHERE { }");
        Assert.assertEquals((long)3L, (long)object.getNode().getProperty("example:int-property").getType());
        Assert.assertEquals((long)0L, (long)object.getNode().getProperty("example:int-property").getValues()[0].getLong());
    }

    @Test
    public void testUpdatingRdfType() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testObjectRdfType");
        Dataset propertiesDataset = object.getPropertiesDataset((GraphSubjects)this.subjects, 0L, -2);
        this.logger.warn(propertiesDataset.toString());
        object.updatePropertiesDataset((GraphSubjects)this.subjects, "INSERT { <http://fedora.info/definitions/v4/rest-api#/testObjectRdfType> <" + RDF.type + "> <http://some/uri> } WHERE { }");
        Assert.assertEquals((long)11L, (long)object.getNode().getProperty("rdf:type").getType());
        Assert.assertEquals((Object)"http://some/uri", (Object)object.getNode().getProperty("rdf:type").getValues()[0].getString());
    }

    @Test
    public void testEtagValue() throws RepositoryException {
        FedoraObject object = this.objectService.createObject(this.session, "/testEtagObject");
        this.session.save();
        String actual = object.getEtagValue();
        Assert.assertNotNull((Object)actual);
        Assert.assertNotEquals((Object)"", (Object)actual);
    }
}

