/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.services;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.apache.tika.io.IOUtils;
import org.fcrepo.integration.kernel.AbstractIT;
import org.fcrepo.kernel.Datastream;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.ObjectService;
import org.fcrepo.kernel.utils.FixityResult;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/repo.xml"})
public class DatastreamServiceIT
extends AbstractIT {
    @Inject
    private Repository repository;
    @Inject
    ObjectService objectService;
    @Inject
    DatastreamService datastreamService;

    @Test
    public void testCreateDatastreamNode() throws Exception {
        Session session = this.repository.login();
        this.datastreamService.createDatastreamNode(session, "/testDatastreamNode", "application/octet-stream", (InputStream)new ByteArrayInputStream("asdf".getBytes()));
        session.save();
        session.logout();
        session = this.repository.login();
        Util.assertTrue((boolean)session.getRootNode().hasNode("testDatastreamNode"));
        Util.assertEquals((Object)"asdf", (Object)session.getNode("/testDatastreamNode").getNode("jcr:content").getProperty("jcr:data").getString());
        session.logout();
    }

    @Test
    public void testGetDatastreamContentInputStream() throws Exception {
        Session session = this.repository.login();
        ByteArrayInputStream is = new ByteArrayInputStream("asdf".getBytes());
        this.objectService.createObject(session, "/testDatastreamServiceObject");
        this.datastreamService.createDatastreamNode(session, "/testDatastreamServiceObject/testDatastreamNode", "application/octet-stream", (InputStream)is);
        session.save();
        session.logout();
        session = this.repository.login();
        Datastream ds = this.datastreamService.getDatastream(session, "/testDatastreamServiceObject/testDatastreamNode");
        Util.assertEquals((Object)"asdf", (Object)IOUtils.toString((InputStream)ds.getContent(), (String)"UTF-8"));
        session.logout();
    }

    @Test
    public void testChecksumBlobs() throws Exception {
        Session session = this.repository.login();
        this.objectService.createObject(session, "/testLLObject");
        this.datastreamService.createDatastreamNode(session, "/testLLObject/testRepositoryContent", "application/octet-stream", (InputStream)new ByteArrayInputStream("0123456789".getBytes()));
        session.save();
        Datastream ds = this.datastreamService.getDatastream(session, "/testLLObject/testRepositoryContent");
        Collection fixityResults = this.datastreamService.getFixity(ds.getNode().getNode("jcr:content"), ds.getContentDigest(), ds.getContentSize());
        Assert.assertNotEquals((long)0L, (long)fixityResults.size());
        for (FixityResult fixityResult : fixityResults) {
            Assert.assertEquals((Object)"urn:sha1:87acec17cd9dcd20a716cc2cf67417b71c8a7016", (Object)fixityResult.computedChecksum.toString());
        }
    }
}

