/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.services;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.fcrepo.kernel.Datastream;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.services.ObjectService;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"/spring-test/repo.xml"})
public class LowLevelStorageServiceIT {
    @Inject
    Repository repo;
    @Inject
    ObjectService objectService;
    @Inject
    DatastreamService datastreamService;
    @Inject
    LowLevelStorageService lowLevelService;

    @Test
    public void testGetBinaryBlobs() throws Exception {
        Session session = this.repo.login();
        this.objectService.createObject(session, "/testLLObject");
        this.datastreamService.createDatastreamNode(session, "/testLLObject/testRepositoryContent", "image/tiff", (InputStream)new ByteArrayInputStream("0123456789987654321012345678900987654321".getBytes()));
        session.save();
        Datastream ds = this.datastreamService.getDatastream(session, "/testLLObject/testRepositoryContent");
        Iterator inputStreamList = this.lowLevelService.getLowLevelCacheEntries(ds.getNode().getNode("jcr:content")).iterator();
        int i = 0;
        while (inputStreamList.hasNext()) {
            InputStream is = ((LowLevelCacheEntry)inputStreamList.next()).getInputStream();
            String myString = IOUtils.toString((InputStream)is, (String)"UTF-8");
            Assert.assertEquals((Object)"0123456789987654321012345678900987654321", (Object)myString);
            ++i;
        }
        Assert.assertNotEquals((long)0L, (long)i);
    }
}

