/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import javax.jcr.Repository;
import org.apache.commons.io.IOUtils;
import org.fcrepo.kernel.utils.impl.CacheStoreEntry;
import org.fcrepo.kernel.utils.impl.LocalBinaryStoreEntry;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"/spring-test/repo.xml"})
public class LowLevelCacheEntryIT {
    @Inject
    Repository repo;

    @Test
    public void testGetExternalIdentifier() throws Exception {
        BinaryStore store = ((JcrRepository)this.repo).getConfiguration().getBinaryStorage().getBinaryStore();
        LocalBinaryStoreEntry cs = new LocalBinaryStoreEntry(store, new BinaryKey("asd"));
        Assert.assertEquals((Object)"/org.modeshape.jcr.value.binary.TransientBinaryStore", (Object)cs.getExternalIdentifier().split(":")[0]);
    }

    @Test
    public void testEquals() throws Exception {
        BinaryStore store = ((JcrRepository)this.repo).getConfiguration().getBinaryStorage().getBinaryStore();
        LocalBinaryStoreEntry cs1 = new LocalBinaryStoreEntry(store, new BinaryKey("asd"));
        LocalBinaryStoreEntry cs2 = new LocalBinaryStoreEntry(store, new BinaryKey("asd"));
        Assert.assertEquals((Object)cs1, (Object)cs2);
    }

    @Test
    public void testHashCode() throws Exception {
        BinaryStore store = ((JcrRepository)this.repo).getConfiguration().getBinaryStorage().getBinaryStore();
        LocalBinaryStoreEntry cs1 = new LocalBinaryStoreEntry(store, new BinaryKey("asd"));
        LocalBinaryStoreEntry cs2 = new LocalBinaryStoreEntry(store, new BinaryKey("asd"));
        Assert.assertEquals((long)cs1.hashCode(), (long)cs2.hashCode());
    }

    @Test
    public void testEqualsIspn() throws Exception {
        DefaultCacheManager cm = new DefaultCacheManager("config/infinispan/basic/infinispan.xml");
        CacheStore ispn = ((CacheLoaderManager)cm.getCache("FedoraRepository").getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class)).getCacheStore();
        CacheStoreEntry cs1 = new CacheStoreEntry(ispn, "FedoraRepository", new BinaryKey("asd"));
        CacheStoreEntry cs2 = new CacheStoreEntry(ispn, "FedoraRepository", new BinaryKey("asd"));
        Assert.assertEquals((Object)cs1, (Object)cs2);
    }

    @Test
    public void testHashCodeIspn() throws Exception {
        DefaultCacheManager cm = new DefaultCacheManager("config/infinispan/basic/infinispan.xml");
        CacheStore ispn = ((CacheLoaderManager)cm.getCache("FedoraRepository").getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class)).getCacheStore();
        CacheStoreEntry cs1 = new CacheStoreEntry(ispn, "FedoraRepository", new BinaryKey("asd"));
        CacheStoreEntry cs2 = new CacheStoreEntry(ispn, "FedoraRepository", new BinaryKey("asd"));
        Assert.assertEquals((long)cs1.hashCode(), (long)cs2.hashCode());
    }

    @Test
    public void testGetExternalIdentifierWithInfinispan() throws Exception {
        DefaultCacheManager cm = new DefaultCacheManager("config/infinispan/basic/infinispan.xml");
        CacheStore ispn = ((CacheLoaderManager)cm.getCache("FedoraRepository").getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class)).getCacheStore();
        CacheStoreEntry cs = new CacheStoreEntry(ispn, "FedoraRepository", new BinaryKey("asd"));
        Assert.assertEquals((Object)"/org.infinispan.loaders.file.FileCacheStore:FedoraRepository:org.infinispan.loaders.file.FileCacheStore:target/FedoraRepository/storage", (Object)cs.getExternalIdentifier());
    }

    @Test
    public void testModifyingCacheStores() throws Exception {
        DefaultCacheManager cm = new DefaultCacheManager("config/infinispan/chained/infinispan.xml");
        CacheStore ispn = ((CacheLoaderManager)cm.getCache("FedoraRepository").getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class)).getCacheStore();
        assert (ispn instanceof ChainingCacheStore);
        BinaryKey key = new BinaryKey("123");
        ChainingCacheStore chained_store = (ChainingCacheStore)ispn;
        LinkedHashMap stores = chained_store.getStores();
        CacheStoreEntry cs = new CacheStoreEntry((CacheStore)stores.keySet().toArray()[0], "FedoraRepository", key);
        CacheStoreEntry cs2 = new CacheStoreEntry((CacheStore)stores.keySet().toArray()[1], "FedoraRepository", key);
        cs.storeValue((InputStream)new ByteArrayInputStream("123456".getBytes()));
        cs2.storeValue((InputStream)new ByteArrayInputStream("asdfg".getBytes()));
        Thread.sleep(1000L);
        String v1 = IOUtils.toString((InputStream)cs.getInputStream());
        String v2 = IOUtils.toString((InputStream)cs2.getInputStream());
        Assert.assertEquals((String)"Found the wrong value in our cache store", (Object)"123456", (Object)v1);
        Assert.assertEquals((String)"Found the wrong value in our cache store", (Object)"asdfg", (Object)v2);
    }
}

