/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.codec.binary.Hex;
import org.apache.poi.util.IOUtils;
import org.fcrepo.kernel.Datastream;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.services.ObjectService;
import org.fcrepo.kernel.services.policy.StoragePolicyDecisionPoint;
import org.fcrepo.kernel.utils.ContentDigest;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.fcrepo.kernel.utils.impl.CacheStoreEntry;
import org.fcrepo.kernel.utils.infinispan.StoreChunkOutputStream;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.jcr.JcrRepositoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SelfHealingIT {
    protected Logger logger;
    private static Repository repo;
    private DatastreamService datastreamService;
    private ObjectService objectService;
    private LowLevelStorageService lowLevelService;
    @Autowired(required=false)
    StoragePolicyDecisionPoint storagePolicyDecisionPoint;

    @Before
    public void setLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Before
    public void setRepository() throws RepositoryException {
        URL config = this.getClass().getClassLoader().getResource("test_selfhealing_repository.json");
        Map<String, String> params = Collections.singletonMap("org.modeshape.jcr.URL", config.toString());
        repo = new JcrRepositoryFactory().getRepository(params);
        this.datastreamService = new DatastreamService();
        this.datastreamService.setRepository(repo);
        this.datastreamService.setStoragePolicyDecisionPoint(this.storagePolicyDecisionPoint);
        this.objectService = new ObjectService();
        this.objectService.setRepository(repo);
        this.lowLevelService = new LowLevelStorageService();
        this.lowLevelService.setRepository(repo);
        this.datastreamService.setLlStoreService(this.lowLevelService);
    }

    private void tamperWithNode(Node node) throws Exception {
        this.logger.info("Tampering with node " + node.toString());
        Set binaryBlobs = this.lowLevelService.getLowLevelCacheEntries(node.getNode("jcr:content"));
        Iterator it = binaryBlobs.iterator();
        LowLevelCacheEntry entryToTamper = (LowLevelCacheEntry)it.next();
        CacheStore store = ((CacheStoreEntry)entryToTamper).getLowLevelStore();
        if (store instanceof ChainingCacheStore) {
            store = (CacheStore)((ChainingCacheStore)store).getStores().keySet().iterator().next();
            StoreChunkOutputStream outputStream = new StoreChunkOutputStream(store, entryToTamper.getKey().toString() + "-data");
            IOUtils.copy((InputStream)new ByteArrayInputStream("qwerty".getBytes()), (OutputStream)outputStream);
            outputStream.close();
        } else {
            entryToTamper.storeValue((InputStream)new ByteArrayInputStream("qwerty".getBytes()));
        }
        Thread.sleep(1000L);
    }

    private Collection<FixityResult> getNodeFixity(Datastream ds) throws NoSuchAlgorithmException, RepositoryException {
        return this.datastreamService.getFixity(ds.getNode().getNode("jcr:content"), ds.getContentDigest(), ds.getContentSize());
    }

    @Test
    public void testEddiesMagicSelfHealingRepository() throws Exception {
        Session session = repo.login();
        String contentA = "qn8y34jweuytgopfv3oevo29r7ajrp6r7q21jrxkkciggheh7rqqjbolsq09";
        String contentB = "2e6sxpys67dslongzydxosx6ndze5vbgb6fnj1rr53buk405i1380a868xsb";
        URI shaA = ContentDigest.asURI((String)"SHA-1", (String)Hex.encodeHexString((byte[])MessageDigest.getInstance("SHA-1").digest("qn8y34jweuytgopfv3oevo29r7ajrp6r7q21jrxkkciggheh7rqqjbolsq09".getBytes())));
        URI shaB = ContentDigest.asURI((String)"SHA-1", (String)Hex.encodeHexString((byte[])MessageDigest.getInstance("SHA-1").digest("2e6sxpys67dslongzydxosx6ndze5vbgb6fnj1rr53buk405i1380a868xsb".getBytes())));
        this.objectService.createObject(session, "/testSelfHealingObject");
        this.datastreamService.createDatastreamNode(session, "/testSelfHealingObject/testDatastreamNode4", "application/octet-stream", (InputStream)new ByteArrayInputStream("qn8y34jweuytgopfv3oevo29r7ajrp6r7q21jrxkkciggheh7rqqjbolsq09".getBytes()), shaA);
        this.datastreamService.createDatastreamNode(session, "/testSelfHealingObject/testDatastreamNode5", "application/octet-stream", (InputStream)new ByteArrayInputStream("2e6sxpys67dslongzydxosx6ndze5vbgb6fnj1rr53buk405i1380a868xsb".getBytes()), shaB);
        session.save();
        Thread.sleep(1000L);
        Datastream ds = this.datastreamService.getDatastream(session, "/testSelfHealingObject/testDatastreamNode4");
        Datastream ds2 = this.datastreamService.getDatastream(session, "/testSelfHealingObject/testDatastreamNode5");
        this.logger.info("checking that our setup succeeded");
        Collection<FixityResult> nodeFixity = this.getNodeFixity(ds);
        Collection<FixityResult> nodeFixity2 = this.getNodeFixity(ds2);
        Assert.assertNotEquals((long)0L, (long)nodeFixity.size());
        this.logger.info("ds1");
        boolean fixityOk = true;
        for (FixityResult fixityResult : nodeFixity) {
            fixityOk &= fixityResult.computedChecksum.equals(shaA);
        }
        Assert.assertTrue((String)"Expected the fixity check to pass.", (boolean)fixityOk);
        this.logger.info("ds2");
        fixityOk = true;
        for (FixityResult fixityResult : nodeFixity2) {
            fixityOk &= fixityResult.computedChecksum.equals(shaB);
        }
        Assert.assertTrue((String)"Expected the fixity check to pass.", (boolean)fixityOk);
        this.tamperWithNode(ds.getNode());
        nodeFixity = this.getNodeFixity(ds);
        fixityOk = true;
        for (FixityResult fixityResult : nodeFixity) {
            fixityOk &= fixityResult.computedChecksum.equals(shaA);
        }
        Assert.assertFalse((String)"Expected the fixity check to fail.", (boolean)fixityOk);
        this.datastreamService.runFixityAndFixProblems(ds);
        nodeFixity = this.getNodeFixity(ds);
        fixityOk = true;
        for (FixityResult fixityResult : nodeFixity) {
            fixityOk &= fixityResult.computedChecksum.equals(shaA);
        }
        Assert.assertTrue((String)"Expected the fixity check to pass.", (boolean)fixityOk);
    }
}

