/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.commons.codec.digest.DigestUtils;
import org.fcrepo.kernel.DummyURIResource;
import org.fcrepo.kernel.FedoraResource;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.impl.DefaultGraphSubjects;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.JcrRdfTools;
import org.fcrepo.kernel.utils.NamespaceTools;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "org.apache.xerces.*", "javax.xml.*", "org.xml.sax.*", "javax.management.*", "com.google.common.*", "com.hp.hpl.jena.*", "com.codahale.metrics.*"})
@PrepareForTest(value={NamespaceTools.class, JcrRdfTools.class, FedoraTypesUtils.class})
public class FedoraResourceTest {
    private FedoraResource testObj;
    @Mock
    private Node mockNode;
    @Mock
    private Node mockRoot;
    @Mock
    private Session mockSession;
    @Mock
    private Property mockProp;
    @Mock
    private JcrRdfTools mockJcrRdfTools;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        this.testObj = new FedoraResource(this.mockNode);
        Assert.assertEquals((Object)this.mockNode, (Object)this.testObj.getNode());
    }

    @Test
    public void testPathConstructor() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockRoot.getNode("foo/bar")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        new FedoraResource(this.mockSession, "/foo/bar", null);
    }

    @Test
    public void testHasMixin() throws RepositoryException {
        NodeType mockType = (NodeType)Mockito.mock(NodeType.class);
        NodeType[] mockTypes = new NodeType[]{mockType};
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)mockTypes);
        boolean actual = FedoraResource.hasMixin((Node)this.mockNode);
        Assert.assertEquals((Object)false, (Object)actual);
        Mockito.when((Object)mockType.getName()).thenReturn((Object)"fedora:resource");
        actual = FedoraResource.hasMixin((Node)this.mockNode);
        Assert.assertEquals((Object)true, (Object)actual);
    }

    @Test
    public void testGetPath() throws RepositoryException {
        this.testObj.getPath();
        ((Node)Mockito.verify((Object)this.mockNode)).getPath();
    }

    @Test
    public void testHasContent() throws RepositoryException {
        this.testObj.hasContent();
        ((Node)Mockito.verify((Object)this.mockNode)).hasNode("jcr:content");
    }

    @Test
    public void testGetCreatedDate() throws RepositoryException {
        Calendar someDate = Calendar.getInstance();
        Mockito.when((Object)this.mockProp.getDate()).thenReturn((Object)someDate);
        Mockito.when((Object)this.mockNode.hasProperty("jcr:created")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getProperty("jcr:created")).thenReturn((Object)this.mockProp);
        Assert.assertEquals((long)someDate.getTimeInMillis(), (long)this.testObj.getCreatedDate().getTime());
    }

    @Test
    public void testGetLastModifiedDateDefault() throws RepositoryException {
        Calendar someDate = Calendar.getInstance();
        someDate.add(5, -1);
        try {
            Mockito.when((Object)this.mockNode.hasProperty("jcr:lastModified")).thenReturn((Object)false);
            Mockito.when((Object)this.mockProp.getDate()).thenReturn((Object)someDate);
            Mockito.when((Object)this.mockNode.hasProperty("jcr:created")).thenReturn((Object)true);
            Mockito.when((Object)this.mockNode.getProperty("jcr:created")).thenReturn((Object)this.mockProp);
            Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        Date actual = this.testObj.getLastModifiedDate();
        Assert.assertEquals((long)someDate.getTimeInMillis(), (long)actual.getTime());
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).save();
    }

    @Test
    public void testGetLastModifiedDate() throws RepositoryException {
        Calendar someDate = Calendar.getInstance();
        someDate.add(5, -1);
        try {
            Mockito.when((Object)this.mockProp.getDate()).thenReturn((Object)someDate);
            Mockito.when((Object)this.mockNode.hasProperty("jcr:created")).thenReturn((Object)true);
            Mockito.when((Object)this.mockNode.getProperty("jcr:created")).thenReturn((Object)this.mockProp);
            Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        Property mockMod = (Property)Mockito.mock(Property.class);
        Calendar modDate = Calendar.getInstance();
        try {
            Mockito.when((Object)this.mockNode.hasProperty("jcr:lastModified")).thenReturn((Object)true);
            Mockito.when((Object)this.mockNode.getProperty("jcr:lastModified")).thenReturn((Object)mockMod);
            Mockito.when((Object)mockMod.getDate()).thenReturn((Object)modDate);
        }
        catch (RepositoryException e) {
            System.err.println("What are we doing in the second test?");
            e.printStackTrace();
        }
        Date actual = this.testObj.getLastModifiedDate();
        Assert.assertEquals((long)modDate.getTimeInMillis(), (long)actual.getTime());
    }

    @Test
    public void testGetPropertiesDataset() throws Exception {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        GraphSubjects mockSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        Mockito.when((Object)JcrRdfTools.withContext((GraphSubjects)mockSubjects, (Session)this.mockSession)).thenReturn((Object)this.mockJcrRdfTools);
        DummyURIResource mockResource = new DummyURIResource("http://fedora.info/definitions/v4/rest-api#xyz");
        Mockito.when((Object)mockSubjects.getGraphSubject(this.mockNode)).thenReturn((Object)mockResource);
        Model propertiesModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)this.mockJcrRdfTools.getJcrPropertiesModel(this.mockNode)).thenReturn((Object)propertiesModel);
        Model treeModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)this.mockJcrRdfTools.getJcrTreeModel(this.mockNode, 0L, -1)).thenReturn((Object)treeModel);
        Model problemsModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getProblemsModel()).thenReturn((Object)problemsModel);
        Dataset dataset = this.testObj.getPropertiesDataset(mockSubjects, 0L, -1);
        Assert.assertTrue((boolean)dataset.containsNamedModel("tree"));
        Assert.assertEquals((Object)treeModel, (Object)dataset.getNamedModel("tree"));
        Assert.assertEquals((Object)propertiesModel, (Object)dataset.getDefaultModel());
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/rest-api#xyz", (Object)dataset.getContext().get(Symbol.create((String)"uri")));
    }

    @Test
    public void testGetPropertiesDatasetDefaultLimits() throws Exception {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        GraphSubjects mockSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        Mockito.when((Object)JcrRdfTools.withContext((GraphSubjects)mockSubjects, (Session)this.mockSession)).thenReturn((Object)this.mockJcrRdfTools);
        DummyURIResource mockResource = new DummyURIResource("http://fedora.info/definitions/v4/rest-api#xyz");
        Mockito.when((Object)mockSubjects.getGraphSubject(this.mockNode)).thenReturn((Object)mockResource);
        Model propertiesModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)this.mockJcrRdfTools.getJcrPropertiesModel(this.mockNode)).thenReturn((Object)propertiesModel);
        Model treeModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)this.mockJcrRdfTools.getJcrTreeModel(this.mockNode, 0L, -1)).thenReturn((Object)treeModel);
        Model problemsModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getProblemsModel()).thenReturn((Object)problemsModel);
        Dataset dataset = this.testObj.getPropertiesDataset(mockSubjects);
        Assert.assertTrue((boolean)dataset.containsNamedModel("tree"));
        Assert.assertEquals((Object)treeModel, (Object)dataset.getNamedModel("tree"));
        Assert.assertEquals((Object)propertiesModel, (Object)dataset.getDefaultModel());
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/rest-api#xyz", (Object)dataset.getContext().get(Symbol.create((String)"uri")));
    }

    @Test
    public void testGetVersionDataset() throws Exception {
        PowerMockito.mockStatic(FedoraTypesUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)FedoraTypesUtils.getVersionHistory((Node)this.mockNode)).thenReturn(Mockito.mock(VersionHistory.class));
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        GraphSubjects mockSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        Mockito.when((Object)JcrRdfTools.withContext((GraphSubjects)mockSubjects, (Session)this.mockSession)).thenReturn((Object)this.mockJcrRdfTools);
        DummyURIResource mockResource = new DummyURIResource("http://fedora.info/definitions/v4/rest-api#xyz");
        Mockito.when((Object)mockSubjects.getGraphSubject(this.mockNode)).thenReturn((Object)mockResource);
        Model versionsModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)this.mockJcrRdfTools.getJcrPropertiesModel((VersionHistory)Matchers.any(VersionHistory.class), (Resource)Matchers.eq((Object)mockResource))).thenReturn((Object)versionsModel);
        Dataset dataset = this.testObj.getVersionDataset(mockSubjects);
        Assert.assertEquals((Object)versionsModel, (Object)dataset.getDefaultModel());
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/rest-api#xyz", (Object)dataset.getContext().get(Symbol.create((String)"uri")));
    }

    @Test
    public void testAddVersionLabel() throws RepositoryException {
        PowerMockito.mockStatic(FedoraTypesUtils.class, (Class[])new Class[0]);
        VersionHistory mockVersionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Version mockVersion = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)mockVersion.getName()).thenReturn((Object)"uuid");
        Mockito.when((Object)FedoraTypesUtils.getBaseVersion((Node)this.mockNode)).thenReturn((Object)mockVersion);
        Mockito.when((Object)FedoraTypesUtils.getVersionHistory((Node)this.mockNode)).thenReturn((Object)mockVersionHistory);
        this.testObj.addVersionLabel("v1.0.0");
        ((VersionHistory)Mockito.verify((Object)mockVersionHistory)).addVersionLabel("uuid", "v1.0.0", true);
    }

    @Test
    public void testIsNew() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)true);
        Assert.assertTrue((String)"resource state should be the same as the node state", (boolean)this.testObj.isNew());
    }

    @Test
    public void testIsNotNew() throws RepositoryException {
        Mockito.when((Object)this.mockNode.isNew()).thenReturn((Object)false);
        Assert.assertFalse((String)"resource state should be the same as the node state", (boolean)this.testObj.isNew());
    }

    @Test
    public void testReplacePropertiesDataset() throws RepositoryException {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        DefaultGraphSubjects defaultGraphSubjects = new DefaultGraphSubjects(this.mockSession);
        Mockito.when((Object)JcrRdfTools.withContext((GraphSubjects)defaultGraphSubjects, (Session)this.mockSession)).thenReturn((Object)this.mockJcrRdfTools);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/xyz");
        Model propertiesModel = ModelFactory.createDefaultModel();
        propertiesModel.add(propertiesModel.createResource("a"), propertiesModel.createProperty("b"), "c");
        propertiesModel.add(propertiesModel.createResource("i"), propertiesModel.createProperty("j"), "k");
        propertiesModel.add(propertiesModel.createResource("x"), propertiesModel.createProperty("y"), "z");
        Mockito.when((Object)this.mockJcrRdfTools.getJcrPropertiesModel(this.mockNode)).thenReturn((Object)propertiesModel);
        Model treeModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)this.mockJcrRdfTools.getJcrTreeModel(this.mockNode, 0L, -2)).thenReturn((Object)treeModel);
        Model problemsModel = ModelFactory.createDefaultModel();
        Mockito.when((Object)JcrRdfTools.getProblemsModel()).thenReturn((Object)problemsModel);
        Model replacementModel = ModelFactory.createDefaultModel();
        replacementModel.add(replacementModel.createResource("a"), replacementModel.createProperty("b"), "n");
        replacementModel.add(replacementModel.createResource("i"), replacementModel.createProperty("j"), "k");
        this.testObj.replacePropertiesDataset((GraphSubjects)defaultGraphSubjects, replacementModel);
        Assert.assertTrue((boolean)propertiesModel.containsAll(replacementModel));
        Assert.assertFalse((boolean)problemsModel.contains(propertiesModel.createResource("x"), propertiesModel.createProperty("y"), "z"));
    }

    @Test
    public void shouldGetEtagForAnObject() throws RepositoryException {
        Property mockMod = (Property)Mockito.mock(Property.class);
        Calendar modDate = Calendar.getInstance();
        modDate.set(2013, 6, 30, 0, 0, 0);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"some-path");
        Mockito.when((Object)this.mockNode.hasProperty("jcr:lastModified")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getProperty("jcr:lastModified")).thenReturn((Object)mockMod);
        Mockito.when((Object)mockMod.getDate()).thenReturn((Object)modDate);
        Assert.assertEquals((Object)DigestUtils.shaHex((String)("some-path" + this.testObj.getLastModifiedDate().toString())), (Object)this.testObj.getEtagValue());
    }
}

