/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.observer.DefaultFilter;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.Repository;

public class DefaultFilterTest {
    private DefaultFilter testObj;
    @Mock
    private Session mockSession;
    @Mock
    private Repository mockRepo;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new DefaultFilter();
        Field repoF = DefaultFilter.class.getDeclaredField("repository");
        repoF.setAccessible(true);
        Mockito.when((Object)this.mockRepo.login()).thenReturn((Object)this.mockSession);
        repoF.set(this.testObj, this.mockRepo);
        this.testObj.acquireSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldApplyToObject() throws Exception {
        Predicate mockFuncTrue = (Predicate)Mockito.mock(Predicate.class);
        Mockito.when((Object)mockFuncTrue.apply(Matchers.any(Node.class))).thenReturn((Object)true);
        Predicate mockFuncFalse = (Predicate)Mockito.mock(Predicate.class);
        Predicate holdDS = FedoraTypesUtils.isFedoraDatastream;
        Predicate holdO = FedoraTypesUtils.isFedoraObject;
        try {
            FedoraTypesUtils.isFedoraDatastream = mockFuncFalse;
            FedoraTypesUtils.isFedoraObject = mockFuncTrue;
            String testPath = "/foo/bar";
            Event mockEvent = (Event)Mockito.mock(Event.class);
            Mockito.when((Object)mockEvent.getPath()).thenReturn((Object)"/foo/bar");
            Node mockNode = (Node)Mockito.mock(Node.class);
            Mockito.when((Object)this.mockSession.getItem("/foo/bar")).thenReturn((Object)mockNode);
            Assert.assertTrue((boolean)this.testObj.apply(mockEvent));
        }
        finally {
            FedoraTypesUtils.isFedoraDatastream = holdDS;
            FedoraTypesUtils.isFedoraObject = holdO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldApplyToDatastream() throws Exception {
        Predicate mockFuncTrue = (Predicate)Mockito.mock(Predicate.class);
        Mockito.when((Object)mockFuncTrue.apply(Matchers.any(Node.class))).thenReturn((Object)true);
        Predicate mockFuncFalse = (Predicate)Mockito.mock(Predicate.class);
        Predicate holdDS = FedoraTypesUtils.isFedoraDatastream;
        Predicate holdO = FedoraTypesUtils.isFedoraObject;
        try {
            FedoraTypesUtils.isFedoraDatastream = mockFuncFalse;
            FedoraTypesUtils.isFedoraObject = mockFuncTrue;
            String testPath = "/foo/bar";
            Event mockEvent = (Event)Mockito.mock(Event.class);
            Mockito.when((Object)mockEvent.getPath()).thenReturn((Object)"/foo/bar");
            Node mockNode = (Node)Mockito.mock(Node.class);
            Mockito.when((Object)this.mockSession.getItem("/foo/bar")).thenReturn((Object)mockNode);
            Assert.assertTrue((boolean)this.testObj.apply(mockEvent));
        }
        finally {
            FedoraTypesUtils.isFedoraDatastream = holdDS;
            FedoraTypesUtils.isFedoraObject = holdO;
        }
    }

    @Test
    public void shouldNotApplyToNonExistentNodes() throws Exception {
        String testPath = "/foo/bar";
        Event mockEvent = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)mockEvent.getPath()).thenReturn((Object)"/foo/bar");
        Mockito.when((Object)this.mockSession.getItem("/foo/bar")).thenThrow(new Class[]{PathNotFoundException.class});
        Assert.assertEquals((Object)false, (Object)this.testObj.apply(mockEvent));
        ((Session)Mockito.verify((Object)this.mockSession)).getItem("/foo/bar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotApplyToSystemNodes() throws Exception {
        Predicate mockFuncFalse = (Predicate)Mockito.mock(Predicate.class);
        Predicate holdDS = FedoraTypesUtils.isFedoraDatastream;
        Predicate holdO = FedoraTypesUtils.isFedoraObject;
        try {
            FedoraTypesUtils.isFedoraDatastream = mockFuncFalse;
            FedoraTypesUtils.isFedoraObject = mockFuncFalse;
            String testPath = "/foo/bar";
            Event mockEvent = (Event)Mockito.mock(Event.class);
            Mockito.when((Object)mockEvent.getPath()).thenReturn((Object)"/foo/bar");
            Node mockNode = (Node)Mockito.mock(Node.class);
            Mockito.when((Object)this.mockSession.getItem("/foo/bar")).thenReturn((Object)mockNode);
            Assert.assertEquals((Object)false, (Object)this.testObj.apply(mockEvent));
        }
        finally {
            FedoraTypesUtils.isFedoraDatastream = holdDS;
            FedoraTypesUtils.isFedoraObject = holdO;
        }
    }
}

