/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.fcrepo.kernel.observer.EventFilter;
import org.fcrepo.kernel.observer.SimpleObserver;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.Repository;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={Iterables.class})
public class SimpleObserverTest {
    private SimpleObserver testObj;
    ObservationManager mockOM;
    @Mock
    Repository mockRepository;
    @Mock
    Session mockSession;
    @Mock
    Workspace mockWS;
    @Mock
    EventBus mockBus;
    @Mock
    EventFilter mockFilter;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new SimpleObserver();
    }

    @Test
    public void testBuildListener() throws Exception {
        this.mockOM = (ObservationManager)Mockito.mock(ObservationManager.class);
        Mockito.when((Object)this.mockWS.getObservationManager()).thenReturn((Object)this.mockOM);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWS);
        Mockito.when((Object)this.mockRepository.login()).thenReturn((Object)this.mockSession);
        SimpleObserverTest.setField("repository", this.testObj, this.mockRepository);
        this.testObj.buildListener();
        ((ObservationManager)Mockito.verify((Object)this.mockOM)).addEventListener((EventListener)this.testObj, SimpleObserver.EVENT_TYPES.intValue(), "/", true, null, null, false);
    }

    @Test
    public void testOnEvent() throws Exception {
        SimpleObserverTest.setField("eventBus", this.testObj, this.mockBus);
        SimpleObserverTest.setField("eventFilter", this.testObj, this.mockFilter);
        SimpleObserverTest.setField("session", this.testObj, this.mockSession);
        Event mockEvent = (Event)Mockito.mock(Event.class);
        Mockito.when((Object)mockEvent.getPath()).thenReturn((Object)"/foo/bar");
        Node mockNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)mockNode.isNode()).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getItem((String)Matchers.any(String.class))).thenReturn((Object)mockNode);
        EventIterator mockEvents = (EventIterator)Mockito.mock(EventIterator.class);
        List<Event> iterable = Arrays.asList(mockEvent);
        PowerMockito.mockStatic(Iterables.class, (Class[])new Class[0]);
        Mockito.when((Object)Iterables.filter((Iterable)((Iterable)Matchers.any(Iterable.class)), (Predicate)((Predicate)Matchers.eq((Object)this.mockFilter)))).thenReturn(iterable);
        this.testObj.onEvent(mockEvents);
        ((EventBus)Mockito.verify((Object)this.mockBus)).post(Matchers.any(Event.class));
    }

    @Test
    public void testOnEventAllFiltered() throws Exception {
        SimpleObserverTest.setField("eventBus", this.testObj, this.mockBus);
        SimpleObserverTest.setField("eventFilter", this.testObj, this.mockFilter);
        EventIterator mockEvents = (EventIterator)Mockito.mock(EventIterator.class);
        List<Event> iterable = Arrays.asList(new Event[0]);
        PowerMockito.mockStatic(Iterables.class, (Class[])new Class[0]);
        Mockito.when((Object)Iterables.filter((Iterable)((Iterable)Matchers.any(Iterable.class)), (Predicate)((Predicate)Matchers.eq((Object)this.mockFilter)))).thenReturn(iterable);
        this.testObj.onEvent(mockEvents);
        ((EventBus)Mockito.verify((Object)this.mockBus, (VerificationMode)Mockito.never())).post(Matchers.any(Event.class));
    }

    private static void setField(String name, SimpleObserver obj, Object val) throws Exception {
        Field field = SimpleObserver.class.getDeclaredField(name);
        field.setAccessible(true);
        field.set(obj, val);
    }
}

