/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.hp.hpl.jena.rdf.model.Resource;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.rdf.impl.DefaultGraphSubjects;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DefaultGraphSubjectsTest {
    private DefaultGraphSubjects testObj;
    @Mock
    Node mockNode;
    @Mock
    Resource mockSubject;
    @Mock
    Session mockSession;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new DefaultGraphSubjects(this.mockSession);
    }

    @Test
    public void testGetGraphSubject() throws RepositoryException {
        String testPath = "/foo/bar";
        String expected = "http://fedora.info/definitions/v4/rest-api#/foo/bar";
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/foo/bar");
        Resource actual = this.testObj.getGraphSubject(this.mockNode);
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/rest-api#/foo/bar", (Object)actual.getURI());
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/foo/bar/jcr:content");
        actual = this.testObj.getGraphSubject(this.mockNode);
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/rest-api#/foo/bar/fcr:content", (Object)actual.getURI());
    }

    @Test
    public void testGetNodeFromGraphSubject() throws RepositoryException {
        String expected = "/foo/bar";
        Mockito.when((Object)this.mockSession.nodeExists("/foo/bar")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode("/foo/bar")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)"http://fedora.info/definitions/v4/rest-api#/foo/bar");
        Mockito.when((Object)this.mockSubject.isURIResource()).thenReturn((Object)true);
        Node actual = this.testObj.getNodeFromGraphSubject(this.mockSubject);
        Assert.assertEquals((Object)this.mockNode, (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)"info:fedora2/foo/bar/bad");
        actual = this.testObj.getNodeFromGraphSubject(this.mockSubject);
        Assert.assertEquals(null, (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)"info:fedora/foo/bar/bad");
        actual = this.testObj.getNodeFromGraphSubject(this.mockSubject);
        Assert.assertEquals(null, (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)"http://fedora.info/definitions/v4/rest-api#/foo/bar/fcr:content");
        actual = this.testObj.getNodeFromGraphSubject(this.mockSubject);
        ((Session)Mockito.verify((Object)this.mockSession)).getNode("/foo/bar/jcr:content");
    }

    @Test
    public void testIsFedoraGraphSubject() {
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)"http://fedora.info/definitions/v4/rest-api#foo");
        Mockito.when((Object)this.mockSubject.isURIResource()).thenReturn((Object)true);
        boolean actual = this.testObj.isFedoraGraphSubject(this.mockSubject);
        Assert.assertEquals((Object)true, (Object)actual);
        Mockito.when((Object)this.mockSubject.getURI()).thenReturn((Object)"http://fedora/foo");
        actual = this.testObj.isFedoraGraphSubject(this.mockSubject);
        Assert.assertEquals((Object)false, (Object)actual);
    }
}

