/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import com.google.common.base.Function;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.Datastream;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.services.DatastreamService;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.services.ServiceHelpers;
import org.fcrepo.kernel.services.functions.CheckCacheEntryFixity;
import org.fcrepo.kernel.services.policy.StoragePolicyDecisionPoint;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.JcrRdfTools;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.infinispan.loaders.CacheLoaderException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "org.apache.xerces.*", "javax.xml.*", "org.xml.sax.*", "javax.management.*"})
@PrepareForTest(value={FedoraTypesUtils.class, ServiceHelpers.class, JcrRdfTools.class})
public class DatastreamServiceTest
implements FedoraJcrTypes {
    private static final String MOCK_CONTENT_TYPE = "application/test-data";
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_DATA = "jcr:data";
    @Mock
    private Session mockSession;
    @Mock
    private Node mockRoot;
    @Mock
    private Node mockNode;
    @Mock
    private Node mockContent;
    private DatastreamService testObj;
    private LowLevelStorageService llStore;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new DatastreamService();
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        this.llStore = (LowLevelStorageService)Mockito.mock(LowLevelStorageService.class);
        this.testObj.setLlStoreService(this.llStore);
    }

    @Test
    public void testCreateDatastreamNode() throws Exception {
        String testPath = "/foo/bar";
        Property mockData = (Property)Mockito.mock(Property.class);
        org.modeshape.jcr.api.Binary mockBinary = (org.modeshape.jcr.api.Binary)Mockito.mock(org.modeshape.jcr.api.Binary.class);
        Mockito.when((Object)this.mockRoot.getNode("/foo/bar".substring(1))).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getNode(JCR_CONTENT)).thenReturn((Object)this.mockContent);
        Mockito.when((Object)mockData.getBinary()).thenReturn((Object)mockBinary);
        InputStream mockIS = (InputStream)Mockito.mock(InputStream.class);
        Mockito.when((Object)this.mockContent.setProperty(JCR_DATA, (Binary)mockBinary)).thenReturn((Object)mockData);
        Mockito.when((Object)this.mockContent.getProperty(JCR_DATA)).thenReturn((Object)mockData);
        StoragePolicyDecisionPoint pdp = (StoragePolicyDecisionPoint)Mockito.mock(StoragePolicyDecisionPoint.class);
        Mockito.when((Object)pdp.evaluatePolicies(this.mockNode)).thenReturn(null);
        this.testObj.setStoragePolicyDecisionPoint(pdp);
        PowerMockito.mockStatic(FedoraTypesUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)FedoraTypesUtils.getBinary((Node)((Node)Matchers.eq((Object)this.mockNode)), (InputStream)((InputStream)Matchers.eq((Object)mockIS)), (String)((String)Matchers.any(String.class)))).thenReturn((Object)mockBinary);
        Node actual = this.testObj.createDatastreamNode(this.mockSession, "/foo/bar", MOCK_CONTENT_TYPE, mockIS);
        Assert.assertEquals((Object)this.mockNode, (Object)actual);
        ((Node)Mockito.verify((Object)this.mockContent)).setProperty(JCR_DATA, (Binary)mockBinary);
    }

    @Test
    public void testGetDatastreamNode() throws Exception {
        String testPath = "/foo/bar";
        NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"fedora:datastream");
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{mockNodeType});
        Mockito.when((Object)this.mockSession.getNode("/foo/bar")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockRoot.getNode("/foo/bar".substring(1))).thenReturn((Object)this.mockNode);
        DatastreamService testObj = new DatastreamService();
        testObj.getDatastreamNode(this.mockSession, "/foo/bar");
        ((Node)Mockito.verify((Object)this.mockRoot)).getNode("/foo/bar".substring(1));
    }

    @Test
    public void testGetDatastream() throws Exception {
        String testPath = "/foo/bar";
        NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"fedora:datastream");
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{mockNodeType});
        Mockito.when((Object)this.mockRoot.getNode("/foo/bar".substring(1))).thenReturn((Object)this.mockNode);
        this.testObj.getDatastream(this.mockSession, "/foo/bar");
        ((Node)Mockito.verify((Object)this.mockRoot)).getNode("/foo/bar".substring(1));
    }

    @Test
    public void testExists() throws RepositoryException {
        this.testObj.exists(this.mockSession, "/foo/bar");
        ((Session)Mockito.verify((Object)this.mockSession)).nodeExists("/foo/bar");
    }

    @Test
    public void testGetFixityResultsModel() throws Exception {
        PowerMockito.mockStatic(JcrRdfTools.class, (Class[])new Class[0]);
        GraphSubjects mockSubjects = (GraphSubjects)Mockito.mock(GraphSubjects.class);
        JcrRdfTools mockJcrRdfTools = (JcrRdfTools)Mockito.mock(JcrRdfTools.class);
        Mockito.when((Object)JcrRdfTools.withContext((GraphSubjects)mockSubjects, (Session)this.mockSession)).thenReturn((Object)mockJcrRdfTools);
        FixityResult fixityResult = (FixityResult)Mockito.mock(FixityResult.class);
        Mockito.when((Object)fixityResult.matches(((Long)Matchers.any(Long.class)).longValue(), (URI)Matchers.any(URI.class))).thenReturn((Object)true);
        List<FixityResult> mockCollection = Arrays.asList(fixityResult);
        Datastream mockDatastream = (Datastream)Mockito.mock(Datastream.class);
        Mockito.when((Object)this.mockNode.getNode(JCR_CONTENT)).thenReturn((Object)this.mockContent);
        Mockito.when((Object)mockDatastream.getNode()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)mockDatastream.getContentDigest()).thenReturn((Object)new URI("urn:sha1:abc"));
        Mockito.when((Object)this.llStore.transformLowLevelCacheEntries((Node)Matchers.eq((Object)this.mockContent), (Function)Matchers.any(Function.class))).thenReturn(mockCollection);
        Model mockModel = (Model)Mockito.mock(Model.class);
        Mockito.when((Object)mockJcrRdfTools.getJcrPropertiesModel((Node)Matchers.eq((Object)this.mockNode), (Iterable)Matchers.any(Collection.class))).thenReturn((Object)mockModel);
        Mockito.when((Object)mockSubjects.getGraphSubject(this.mockNode)).thenReturn((Object)ResourceFactory.createResource((String)"abc"));
        Dataset fixityResultsModel = this.testObj.getFixityResultsModel(mockSubjects, mockDatastream);
        Assert.assertTrue((boolean)fixityResultsModel.getContext().isDefined(Symbol.create((String)"uri")));
    }

    @Test
    public void testGetFixity() throws NoSuchAlgorithmException, RepositoryException {
        URI mockUri = URI.create("sha1:foo:bar");
        long testSize = 4L;
        Mockito.when((Object)this.mockNode.getNode(JCR_CONTENT)).thenReturn((Object)this.mockContent);
        this.testObj.getFixity(this.mockContent, mockUri, 4L);
        ServiceHelpers.getCheckCacheFixityFunction((URI)mockUri, (long)0L);
        ArgumentCaptor argument = ArgumentCaptor.forClass(CheckCacheEntryFixity.class);
        ((LowLevelStorageService)Mockito.verify((Object)this.llStore)).transformLowLevelCacheEntries((Node)Matchers.eq((Object)this.mockContent), (Function)argument.capture());
        CheckCacheEntryFixity actualFunction = (CheckCacheEntryFixity)argument.getValue();
        Assert.assertEquals((Object)mockUri, (Object)actualFunction.getChecksum());
        Assert.assertEquals((long)4L, (long)actualFunction.getSize());
    }

    @Test
    public void testRunFixityAndFixProblems() throws RepositoryException, IOException, CacheLoaderException, URISyntaxException {
        Datastream mockDatastream = (Datastream)Mockito.mock(Datastream.class);
        InputStream mockIS = (InputStream)Mockito.mock(InputStream.class);
        LowLevelCacheEntry mockGoodEntry = (LowLevelCacheEntry)Mockito.mock(LowLevelCacheEntry.class);
        Mockito.when((Object)mockGoodEntry.getInputStream()).thenReturn((Object)mockIS);
        LowLevelCacheEntry mockBadEntry = (LowLevelCacheEntry)Mockito.mock(LowLevelCacheEntry.class);
        FixityResult mockGoodResult = (FixityResult)Mockito.mock(FixityResult.class);
        Mockito.when((Object)mockGoodResult.matches(((Long)Matchers.any(Long.class)).longValue(), (URI)Matchers.any(URI.class))).thenReturn((Object)true);
        Mockito.when((Object)mockGoodResult.getEntry()).thenReturn((Object)mockGoodEntry);
        FixityResult mockBadResult = (FixityResult)Mockito.mock(FixityResult.class);
        Mockito.when((Object)mockBadResult.matches(((Long)Matchers.any(Long.class)).longValue(), (URI)Matchers.any(URI.class))).thenReturn((Object)false);
        Mockito.when((Object)mockBadResult.getEntry()).thenReturn((Object)mockBadEntry);
        FixityResult mockRepairedResult = (FixityResult)Mockito.mock(FixityResult.class);
        Mockito.when((Object)mockRepairedResult.matches(((Long)Matchers.any(Long.class)).longValue(), (URI)Matchers.any(URI.class))).thenReturn((Object)true);
        Mockito.when((Object)mockRepairedResult.getEntry()).thenReturn((Object)mockGoodEntry);
        Mockito.when((Object)mockRepairedResult.isSuccess()).thenReturn((Object)true);
        List<FixityResult> mockFixityResults = Arrays.asList(mockGoodResult, mockBadResult);
        Mockito.when((Object)this.mockNode.getNode(JCR_CONTENT)).thenReturn((Object)this.mockContent);
        Mockito.when((Object)mockDatastream.getNode()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)mockDatastream.getContentDigest()).thenReturn((Object)URI.create("urn:sha1:abc"));
        Mockito.when((Object)this.llStore.transformLowLevelCacheEntries((Node)Matchers.eq((Object)this.mockContent), (Function)Matchers.any(CheckCacheEntryFixity.class))).thenReturn(mockFixityResults);
        Mockito.when((Object)mockBadEntry.checkFixity((URI)Matchers.any(URI.class), ((Long)Matchers.any(Long.class)).longValue())).thenReturn((Object)mockRepairedResult);
        Collection fixityResults = this.testObj.runFixityAndFixProblems(mockDatastream);
        ((FixityResult)Mockito.verify((Object)mockBadResult)).setRepaired();
        ((LowLevelCacheEntry)Mockito.verify((Object)mockBadEntry)).storeValue(mockIS);
        Assert.assertTrue((String)"expected to find good result", (boolean)fixityResults.contains(mockGoodResult));
        Assert.assertTrue((String)"expected to find repaired result", (boolean)fixityResults.contains(mockBadResult));
    }
}

