/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.services.ServiceHelpers;
import org.fcrepo.kernel.services.functions.CacheLocalTransform;
import org.fcrepo.kernel.services.functions.GetBinaryKey;
import org.fcrepo.kernel.services.functions.GetCacheStore;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.fcrepo.kernel.utils.impl.CacheStoreEntry;
import org.fcrepo.kernel.utils.impl.LocalBinaryStoreEntry;
import org.infinispan.Cache;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.loaders.CacheStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.GetBinaryStore;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.CompositeBinaryStore;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={ServiceHelpers.class})
public class LowLevelStorageServiceTest {
    @Mock
    private GetBinaryStore mockStoreFunc;
    @Mock
    private GetBinaryKey mockKeyFunc;
    @Mock
    private Node mockNode;
    @Mock
    private Repository mockRepo;
    @Mock
    private BinaryKey mockKey;
    @Mock
    private BinaryStore mockStore;
    @Mock
    private Property mockProperty;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testTransformBinaryBlobs() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getProperty("jcr:data")).thenReturn((Object)this.mockProperty);
        Mockito.when((Object)this.mockStore.toString()).thenReturn((Object)"foo");
        Mockito.when((Object)this.mockKeyFunc.apply(this.mockProperty)).thenReturn((Object)this.mockKey);
        Mockito.when((Object)this.mockStoreFunc.apply(this.mockRepo)).thenReturn((Object)this.mockStore);
        LowLevelStorageService testObj = new LowLevelStorageService();
        testObj.setGetBinaryStore(this.mockStoreFunc);
        testObj.setGetBinaryKey(this.mockKeyFunc);
        testObj.setRepository(this.mockRepo);
        Function testFunc = (Function)Mockito.mock(Function.class);
        Mockito.when((Object)testFunc.apply(Matchers.any(LowLevelCacheEntry.class))).thenReturn((Object)"bar");
        Collection actual = testObj.transformLowLevelCacheEntries(this.mockNode, testFunc);
        Assert.assertEquals((Object)"bar", actual.iterator().next());
        ((Function)Mockito.verify((Object)testFunc)).apply(Matchers.any(LowLevelCacheEntry.class));
    }

    @Test
    public void testGetBinaryBlobs() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getProperty("jcr:data")).thenReturn((Object)this.mockProperty);
        Mockito.when((Object)this.mockStore.toString()).thenReturn((Object)"foo");
        Mockito.when((Object)this.mockKeyFunc.apply(this.mockProperty)).thenReturn((Object)this.mockKey);
        Mockito.when((Object)this.mockStoreFunc.apply(this.mockRepo)).thenReturn((Object)this.mockStore);
        LowLevelStorageService testObj = new LowLevelStorageService();
        testObj.setGetBinaryStore(this.mockStoreFunc);
        testObj.setGetBinaryKey(this.mockKeyFunc);
        testObj.setRepository(this.mockRepo);
        Set actual = testObj.getLowLevelCacheEntries(this.mockNode);
        Assert.assertEquals((Object)"/foo", (Object)((LowLevelCacheEntry)actual.iterator().next()).getExternalIdentifier());
    }

    @Test
    public void shouldRetrieveLowLevelCacheEntryForDefaultBinaryStore() throws RepositoryException {
        BinaryKey key = new BinaryKey("key-123");
        Mockito.when((Object)this.mockStoreFunc.apply(this.mockRepo)).thenReturn((Object)this.mockStore);
        LowLevelStorageService testObj = (LowLevelStorageService)PowerMockito.spy((Object)new LowLevelStorageService());
        testObj.setRepository(this.mockRepo);
        testObj.setGetBinaryStore(this.mockStoreFunc);
        testObj.getLowLevelCacheEntries(key);
        ((LowLevelStorageService)Mockito.verify((Object)testObj, (VerificationMode)Mockito.times((int)1))).getLowLevelCacheEntriesFromStore(this.mockStore, key);
    }

    @Test
    public void shouldRetrieveLowLevelCacheStoresForBinaryKey() throws RepositoryException {
        LowLevelStorageService testObj = new LowLevelStorageService();
        Set entries = testObj.getLowLevelCacheEntriesFromStore(this.mockStore, new BinaryKey("key-123"));
        Assert.assertEquals((long)1L, (long)entries.size());
        Assert.assertTrue((String)"does not contain our entry", (boolean)entries.contains(new LocalBinaryStoreEntry(this.mockStore, new BinaryKey("key-123"))));
    }

    @Test
    public void shouldRetrieveLowLevelCacheStoresForCompositeStore() throws Exception {
        PowerMockito.mockStatic(ServiceHelpers.class, (Class[])new Class[0]);
        Cache ispnCache1 = (Cache)Mockito.mock(Cache.class);
        Cache ispnCache2 = (Cache)Mockito.mock(Cache.class);
        CacheStore ispnCacheStore1 = (CacheStore)Mockito.mock(CacheStore.class);
        CacheStore ispnCacheStore2 = (CacheStore)Mockito.mock(CacheStore.class);
        BinaryStore plainBinaryStore = (BinaryStore)Mockito.mock(BinaryStore.class);
        BinaryStore plainBinaryStore2 = (BinaryStore)Mockito.mock(BinaryStore.class);
        GetCacheStore mockCacheStoreFunc = (GetCacheStore)Mockito.mock(GetCacheStore.class);
        Mockito.when((Object)mockCacheStoreFunc.apply(ispnCache1)).thenReturn((Object)ispnCacheStore1);
        Mockito.when((Object)mockCacheStoreFunc.apply(ispnCache2)).thenReturn((Object)ispnCacheStore2);
        CompositeBinaryStore mockStore = (CompositeBinaryStore)Mockito.mock(CompositeBinaryStore.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Cache> caches = new ArrayList<Cache>();
        caches.add(ispnCache1);
        caches.add(ispnCache2);
        map.put("default", plainBinaryStore);
        map.put("a", plainBinaryStore2);
        InfinispanBinaryStore infinispanBinaryStore = (InfinispanBinaryStore)Mockito.mock(InfinispanBinaryStore.class);
        Mockito.when((Object)infinispanBinaryStore.getCaches()).thenReturn(caches);
        map.put("b", infinispanBinaryStore);
        Mockito.when((Object)mockStore.getNamedStoreIterator()).thenReturn(map.entrySet().iterator());
        DistributedExecutorService mockCluster = (DistributedExecutorService)Mockito.mock(DistributedExecutorService.class);
        Mockito.when((Object)ServiceHelpers.getClusterExecutor((InfinispanBinaryStore)infinispanBinaryStore)).thenReturn((Object)mockCluster);
        BinaryKey key = new BinaryKey("key-123");
        CacheStoreEntry cacheEntry1 = new CacheStoreEntry(ispnCacheStore1, "cache1", key);
        ImmutableSet cacheResponse1 = ImmutableSet.of((Object)cacheEntry1);
        CacheStoreEntry cacheEntry2 = new CacheStoreEntry(ispnCacheStore2, "cache2", key);
        ImmutableSet cacheResponse2 = ImmutableSet.of((Object)cacheEntry2);
        Future future1 = (Future)Mockito.mock(Future.class);
        Future future2 = (Future)Mockito.mock(Future.class);
        Mockito.when(future1.get((Long)Matchers.any(Long.class), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))))).thenReturn((Object)cacheResponse1);
        Mockito.when(future2.get((Long)Matchers.any(Long.class), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))))).thenReturn((Object)cacheResponse2);
        ArrayList<Future> mockClusterResults = new ArrayList<Future>(2);
        mockClusterResults.add(future1);
        mockClusterResults.add(future2);
        Mockito.when((Object)mockCluster.submitEverywhere((Callable)Matchers.any(CacheLocalTransform.class))).thenReturn(mockClusterResults);
        LowLevelStorageService testObj = new LowLevelStorageService();
        Mockito.when((Object)plainBinaryStore.hasBinary(key)).thenReturn((Object)true);
        Mockito.when((Object)plainBinaryStore2.hasBinary(key)).thenReturn((Object)false);
        Mockito.when((Object)infinispanBinaryStore.hasBinary(key)).thenReturn((Object)true);
        Set entries = testObj.getLowLevelCacheEntriesFromStore(mockStore, key);
        Assert.assertEquals((long)3L, (long)entries.size());
        Assert.assertTrue((boolean)entries.contains(new LocalBinaryStoreEntry(plainBinaryStore, key)));
        Assert.assertFalse((boolean)entries.contains(new LocalBinaryStoreEntry(plainBinaryStore2, key)));
        Assert.assertTrue((boolean)entries.contains(new CacheStoreEntry(ispnCacheStore1, "cache1", key)));
        Assert.assertTrue((boolean)entries.contains(new CacheStoreEntry(ispnCacheStore2, "cache2", key)));
    }

    @Test
    public void shouldReturnAnEmptySetForMissingBinaryStore() throws RepositoryException {
        Mockito.when((Object)this.mockStoreFunc.apply(this.mockRepo)).thenReturn(null);
        LowLevelStorageService testObj = new LowLevelStorageService();
        testObj.setGetBinaryStore(this.mockStoreFunc);
        Set entries = testObj.getLowLevelCacheEntries(new BinaryKey("key-123"));
        Assert.assertEquals((long)0L, (long)entries.size());
    }
}

