/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.services.NodeService;
import org.fcrepo.kernel.services.ServiceHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={ServiceHelpers.class})
public class NodeServiceTest {
    @Mock
    private Session mockSession;
    @Mock
    private Node mockRoot;
    @Mock
    private Node mockObjNode;
    private NodeService testObj;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new NodeService();
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
    }

    @Test
    public void testGetObjectNames() throws RepositoryException {
        String objPath = "";
        Mockito.when((Object)this.mockObjNode.getName()).thenReturn((Object)"foo");
        Mockito.when((Object)this.mockObjNode.isNodeType("nt:folder")).thenReturn((Object)true);
        NodeIterator mockIter = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)mockIter.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)mockIter.nextNode()).thenReturn((Object)this.mockObjNode).thenThrow(new Class[]{IndexOutOfBoundsException.class});
        Mockito.when((Object)this.mockRoot.getNodes()).thenReturn((Object)mockIter);
        Mockito.when((Object)this.mockSession.getNode("")).thenReturn((Object)this.mockRoot);
        Set actual = this.testObj.getObjectNames(this.mockSession, "");
        ((Session)Mockito.verify((Object)this.mockSession)).getNode("");
        Assert.assertEquals((long)1L, (long)actual.size());
        Assert.assertEquals((Object)"foo", actual.iterator().next());
    }

    @Test
    public void testDeleteOBject() throws RepositoryException {
        String objPath = "foo";
        Node mockObjectsNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
        Mockito.when((Object)this.mockRoot.getNode("objects")).thenReturn((Object)mockObjectsNode);
        Mockito.when((Object)this.mockSession.getNode("foo")).thenReturn((Object)this.mockObjNode);
        PowerMockito.mockStatic(ServiceHelpers.class, (Class[])new Class[0]);
        this.testObj.deleteObject(this.mockSession, "foo");
        ((Session)Mockito.verify((Object)this.mockSession)).getNode("foo");
        ((Node)Mockito.verify((Object)this.mockObjNode)).remove();
    }
}

