/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.services.ObjectService;
import org.fcrepo.kernel.services.ServiceHelpers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={ServiceHelpers.class})
public class ObjectServiceTest
implements FedoraJcrTypes {
    @Mock
    private Session mockSession;
    @Mock
    private Node mockRoot;
    @Mock
    private Node mockNode;
    @Mock
    private NodeType mockNodeType;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRoot);
    }

    @Test
    public void testCreateObject() throws Exception {
        String testPath = "/foo";
        Mockito.when((Object)this.mockRoot.getNode("/foo".substring(1))).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNodeType.getName()).thenReturn((Object)"fedora:object");
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{this.mockNodeType});
        ObjectService testObj = new ObjectService();
        Node actual = testObj.createObject(this.mockSession, "/foo").getNode();
        Assert.assertEquals((Object)this.mockNode, (Object)actual);
    }

    @Test
    public void testGetObject() throws RepositoryException {
        Mockito.when((Object)this.mockNodeType.getName()).thenReturn((Object)"fedora:object");
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{this.mockNodeType});
        String testPath = "/foo";
        Mockito.when((Object)this.mockSession.getNode("/foo")).thenReturn((Object)this.mockNode);
        ObjectService testObj = new ObjectService();
        testObj.getObject(this.mockSession, "/foo");
        ((Session)Mockito.verify((Object)this.mockSession)).getNode("/foo");
    }

    @Test
    public void testGetObjectNode() throws RepositoryException {
        String testPath = "/foo";
        ObjectService testObj = new ObjectService();
        testObj.getObjectNode(this.mockSession, "/foo");
        ((Session)Mockito.verify((Object)this.mockSession)).getNode("/foo");
    }
}

