/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services.functions;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.jcr.Repository;
import org.fcrepo.kernel.services.functions.GetClusterConfiguration;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.DefaultCacheManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.GetBinaryStore;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.value.binary.infinispan.InfinispanBinaryStore;

public class GetClusterConfigurationTest {
    private GetClusterConfiguration testObj;
    @Mock
    private GetBinaryStore mockGetBinaryStore;
    @Mock
    private RepositoryConfiguration mockConfig;
    @Mock
    private JcrRepository mockRepo;
    @Mock
    private RepositoryConfiguration.BinaryStorage mockStorage;
    @Mock
    private InfinispanBinaryStore mockStore;
    @Mock
    private Cache<Object, Object> mockCache;
    @Mock
    private Configuration mockCC;
    @Mock
    private DefaultCacheManager mockCM;
    @Mock
    private ClusteringConfiguration mockClustering;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new GetClusterConfiguration();
        Field field = GetClusterConfiguration.class.getDeclaredField("getBinaryStore");
        field.setAccessible(true);
        field.set(this.testObj, this.mockGetBinaryStore);
    }

    @Test
    public void testGood() throws Exception {
        Mockito.when((Object)this.mockRepo.getConfiguration()).thenReturn((Object)this.mockConfig);
        Mockito.when((Object)this.mockConfig.getBinaryStorage()).thenReturn((Object)this.mockStorage);
        Mockito.when((Object)this.mockGetBinaryStore.apply((Repository)Matchers.any(Repository.class))).thenReturn((Object)this.mockStore);
        List<Cache> mockCaches = Arrays.asList(this.mockCache);
        Mockito.when((Object)this.mockStore.getCaches()).thenReturn(mockCaches);
        Mockito.when((Object)this.mockCM.getCache()).thenReturn(this.mockCache);
        Mockito.when((Object)this.mockCache.getCacheConfiguration()).thenReturn((Object)this.mockCC);
        Mockito.when((Object)this.mockCC.clustering()).thenReturn((Object)this.mockClustering);
        Mockito.when((Object)this.mockClustering.cacheMode()).thenReturn((Object)CacheMode.LOCAL);
        Mockito.when((Object)this.mockCache.getCacheManager()).thenReturn((Object)this.mockCM);
        Map actual = this.testObj.apply((Repository)this.mockRepo);
        Assert.assertNotNull((Object)actual);
        Assert.assertFalse((boolean)actual.isEmpty());
    }

    @Test
    public void testBad() {
        Map actual = this.testObj.apply((Repository)this.mockRepo);
        Assert.assertTrue((boolean)actual.isEmpty());
    }
}

