/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.spring;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.services.ObjectService;
import org.fcrepo.kernel.spring.ModeShapeRepositoryFactoryBean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrRepositoryFactory;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.api.Repository;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={ObjectService.class})
public class ModeShapeRepositoryFactoryBeanTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModeShapeRepositoryFactoryBeanTest.class);
    private ModeShapeRepositoryFactoryBean testObj;
    @Mock
    private Resource mockConfig;
    @Mock
    private JcrRepository mockRepo;
    @Mock
    private JcrRepositoryFactory mockRepos;
    @Mock
    private JcrSession mockSession;

    @Before
    public void setUp() throws RepositoryException, IOException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockRepo.login()).thenReturn((Object)this.mockSession);
        this.testObj = new ModeShapeRepositoryFactoryBean();
        this.testObj.setRepositoryConfiguration(this.mockConfig);
        Mockito.when((Object)this.mockRepos.getRepository((Map)Matchers.any(Map.class))).thenReturn((Object)this.mockRepo);
        ModeShapeRepositoryFactoryBeanTest.inject("jcrRepositoryFactory", this.mockRepos, this.testObj);
    }

    @Test
    public void testFactory() throws RepositoryException, IOException {
        this.testObj.buildRepository();
        Assert.assertEquals((Object)this.mockRepo, (Object)this.testObj.getObject());
    }

    @Test
    public void testFactoryMetadata() {
        Assert.assertEquals(Repository.class, (Object)this.testObj.getObjectType());
        Assert.assertEquals((Object)true, (Object)this.testObj.isSingleton());
    }

    private static void inject(String name, Object value, Object object) {
        try {
            Field field = ModeShapeRepositoryFactoryBean.class.getDeclaredField(name);
            if (!field.isAnnotationPresent(Inject.class)) {
                LOGGER.error("WARNING: test sets ModeShapeRepositoryFactoryBean.{}, which is not annotated as an @Inject!", (Object)name);
            }
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Throwable t) {
            Throwables.propagate((Throwable)t);
        }
    }
}

