/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.google.common.base.Predicate;
import java.io.InputStream;
import java.util.Calendar;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.api.Namespaced;

public class FedoraTypesUtilsTest {
    @Mock
    private Node mockNode;
    @Mock
    private Session mockSession;
    @Mock
    private ValueFactory mockVF;
    @Mock
    private InputStream mockInput;
    @Mock
    private JcrValueFactory mockJVF;
    @Mock
    private Workspace mockWS;
    @Mock
    private NodeTypeManager mockNTM;
    @Mock
    private NodeType mockNodeType;
    @Mock
    private PropertyDefinition mockPropertyDefinition;
    @Mock
    private Version mockVersion;
    @Mock
    private VersionManager mockVersionManager;
    @Mock
    private VersionHistory mockVersionHistory;
    @Mock
    private Repository mockRepository;
    @Mock
    private QueryManager mockQueryManager;
    @Mock
    private Query mockQuery;
    @Mock
    private QueryResult mockResults;
    @Mock
    private RowIterator mockIterator;
    @Mock
    private Row mockRow;
    @Mock
    private Value mockValue;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testIsMultipleValuedProperty() throws RepositoryException {
        Property mockYes = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)mockYes.isMultiple()).thenReturn((Object)true);
        Property mockNo = (Property)Mockito.mock(Property.class);
        Predicate test = FedoraTypesUtils.isMultipleValuedProperty;
        try {
            test.apply(null);
            Assert.fail((String)"Null values should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        boolean actual = test.apply((Object)mockYes);
        Assert.assertEquals((Object)true, (Object)actual);
        actual = test.apply((Object)mockNo);
        Assert.assertEquals((Object)false, (Object)actual);
        Mockito.when((Object)mockYes.isMultiple()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            test.apply((Object)mockYes);
            Assert.fail((String)"Unexpected completion after RepositoryException!");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
    }

    @Test
    public void testGetValueFactory() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockVF);
        ValueFactory actual = (ValueFactory)FedoraTypesUtils.getValueFactory.apply((Object)this.mockNode);
        Assert.assertEquals((Object)this.mockVF, (Object)actual);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            FedoraTypesUtils.getValueFactory.apply((Object)this.mockNode);
            Assert.fail((String)"Unexpected completion after RepositoryException!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPredicateForProperty() throws RepositoryException {
        PropertyMock mockProp = (PropertyMock)Mockito.mock(PropertyMock.class);
        FedoraTypesUtils.getPredicateForProperty.apply((Object)mockProp);
        Mockito.when((Object)mockProp.getNamespaceURI()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            FedoraTypesUtils.getPredicateForProperty.apply((Object)mockProp);
            Assert.fail((String)"Unexpected completion after RepositoryException!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetBinary() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockVF);
        FedoraTypesUtils.getBinary((Node)this.mockNode, (InputStream)this.mockInput);
        ((ValueFactory)Mockito.verify((Object)this.mockVF)).createBinary(this.mockInput);
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockJVF);
        String mockHint = "storage-hint";
        FedoraTypesUtils.getBinary((Node)this.mockNode, (InputStream)this.mockInput, (String)"storage-hint");
        ((JcrValueFactory)Mockito.verify((Object)this.mockJVF)).createBinary(this.mockInput, "storage-hint");
        Mockito.when((Object)this.mockNode.getSession()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            FedoraTypesUtils.getBinary((Node)this.mockNode, (InputStream)this.mockInput);
            Assert.fail((String)"Unexpected completion after RepositoryException!");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            FedoraTypesUtils.getBinary((Node)this.mockNode, (InputStream)this.mockInput, (String)"storage-hint");
            Assert.fail((String)"Unexpected completion after RepositoryException!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetDefinitionForPropertyName() throws RepositoryException {
        String mockPropertyName = "mock:property";
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWS);
        Mockito.when((Object)this.mockWS.getNodeTypeManager()).thenReturn((Object)this.mockNTM);
        Mockito.when((Object)this.mockNTM.getNodeType(Matchers.anyString())).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockPropertyDefinition.getName()).thenReturn((Object)"mock:property");
        PropertyDefinition[] PDs = new PropertyDefinition[]{this.mockPropertyDefinition};
        Mockito.when((Object)this.mockNodeType.getPropertyDefinitions()).thenReturn((Object)PDs);
        PropertyDefinition actual = FedoraTypesUtils.getDefinitionForPropertyName((Node)this.mockNode, (String)"mock:property");
        Assert.assertEquals((Object)this.mockPropertyDefinition, (Object)actual);
        actual = FedoraTypesUtils.getDefinitionForPropertyName((Node)this.mockNode, (String)"mock:property:fail");
        Assert.assertEquals(null, (Object)actual);
    }

    @Test
    public void testConvertDateToXSDString() {
        String expected = "2006-11-13T09:40:55.001Z";
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.set(2006, 10, 13, 9, 40, 55);
        date.set(14, 1);
        Assert.assertEquals((Object)"2006-11-13T09:40:55.001Z", (Object)FedoraTypesUtils.convertDateToXSDString((long)date.getTimeInMillis()));
    }

    @Test
    public void testGetBaseVersionForNode() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/my/path");
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWS);
        Mockito.when((Object)this.mockWS.getVersionManager()).thenReturn((Object)this.mockVersionManager);
        Mockito.when((Object)this.mockVersionManager.getBaseVersion("/my/path")).thenReturn((Object)this.mockVersion);
        Version versionHistory = FedoraTypesUtils.getBaseVersion((Node)this.mockNode);
        Assert.assertEquals((Object)this.mockVersion, (Object)versionHistory);
    }

    @Test
    public void testGetVersionHistoryForNode() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/my/path");
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNode.getSession().getWorkspace()).thenReturn((Object)this.mockWS);
        Mockito.when((Object)this.mockWS.getVersionManager()).thenReturn((Object)this.mockVersionManager);
        Mockito.when((Object)this.mockVersionManager.getVersionHistory("/my/path")).thenReturn((Object)this.mockVersionHistory);
        VersionHistory versionHistory = FedoraTypesUtils.getVersionHistory((Node)this.mockNode);
        Assert.assertEquals((Object)this.mockVersionHistory, (Object)versionHistory);
    }

    @Test
    public void testGetVersionHistoryForSessionAndPath() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWS);
        Mockito.when((Object)this.mockWS.getVersionManager()).thenReturn((Object)this.mockVersionManager);
        Mockito.when((Object)this.mockVersionManager.getVersionHistory("/my/path")).thenReturn((Object)this.mockVersionHistory);
        VersionHistory versionHistory = FedoraTypesUtils.getVersionHistory((Session)this.mockSession, (String)"/my/path");
        Assert.assertEquals((Object)this.mockVersionHistory, (Object)versionHistory);
    }

    @Test
    public void testIsInternalNode() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeType.isNodeType("mode:system")).thenReturn((Object)true);
        Assert.assertTrue((String)"mode:system nodes should be treated as internal nodes!", (boolean)FedoraTypesUtils.isInternalNode.apply((Object)this.mockNode));
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeType.isNodeType("mode:system")).thenReturn((Object)false);
        Assert.assertFalse((String)"Nodes that are not mode:system types should not be treated as internal nodes!", (boolean)FedoraTypesUtils.isInternalNode.apply((Object)this.mockNode));
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            FedoraTypesUtils.isInternalNode.apply((Object)this.mockNode);
            Assert.fail((String)"Unexpected completion of FedoraTypesUtils.isInternalNode after RepositoryException!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetObjectSize() throws RepositoryException {
        Mockito.when((Object)this.mockRepository.login()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWS);
        Mockito.when((Object)this.mockWS.getQueryManager()).thenReturn((Object)this.mockQueryManager);
        Mockito.when((Object)this.mockQueryManager.createQuery("SELECT [fedora:size] FROM [fedora:binary]", "JCR-SQL2")).thenReturn((Object)this.mockQuery);
        Mockito.when((Object)this.mockQuery.execute()).thenReturn((Object)this.mockResults);
        Mockito.when((Object)this.mockResults.getRows()).thenReturn((Object)this.mockIterator);
        Mockito.when((Object)this.mockIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)this.mockIterator.nextRow()).thenReturn((Object)this.mockRow, (Object[])new Row[]{this.mockRow, this.mockRow});
        Mockito.when((Object)this.mockRow.getValue("fedora:size")).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockValue.getLong()).thenReturn((Object)5L, (Object[])new Long[]{10L, 1L});
        long count = FedoraTypesUtils.getRepositorySize((Repository)this.mockRepository);
        Assert.assertEquals((String)"Got wrong count!", (long)16L, (long)count);
        ((Session)Mockito.verify((Object)this.mockSession)).logout();
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).save();
    }

    @Test
    public void testGetObjectCount() throws RepositoryException {
        Mockito.when((Object)this.mockRepository.login()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWS);
        Mockito.when((Object)this.mockWS.getQueryManager()).thenReturn((Object)this.mockQueryManager);
        Mockito.when((Object)this.mockQueryManager.createQuery("SELECT [jcr:path] FROM [fedora:object]", "JCR-SQL2")).thenReturn((Object)this.mockQuery);
        Mockito.when((Object)this.mockQuery.execute()).thenReturn((Object)this.mockResults);
        Mockito.when((Object)this.mockResults.getRows()).thenReturn((Object)this.mockIterator);
        Mockito.when((Object)this.mockIterator.getSize()).thenReturn((Object)3L);
        long count = FedoraTypesUtils.getRepositoryCount((Repository)this.mockRepository);
        Assert.assertTrue((count == 3L ? 1 : 0) != 0);
        ((Session)Mockito.verify((Object)this.mockSession)).logout();
        ((Session)Mockito.verify((Object)this.mockSession, (VerificationMode)Mockito.never())).save();
    }

    @Test
    public void testPredicateExceptionHandling() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            FedoraTypesUtils.isFedoraResource.apply((Object)this.mockNode);
            Assert.fail((String)"Unexpected FedoraTypesUtils.isFedoraResource completion after RepositoryException!");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            FedoraTypesUtils.isFedoraObject.apply((Object)this.mockNode);
            Assert.fail((String)"Unexpected FedoraTypesUtils.isFedoraObject completion after RepositoryException!");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            FedoraTypesUtils.isFedoraDatastream.apply((Object)this.mockNode);
            Assert.fail((String)"Unexpected FedoraTypesUtils.isFedoraDatastream completion after RepositoryException!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testValue2String() throws RepositoryException {
        Value mockValue = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)mockValue.getString()).thenReturn((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)FedoraTypesUtils.value2string.apply((Object)mockValue));
        Mockito.when((Object)mockValue.getString()).thenThrow(new Throwable[]{new RepositoryException()});
        try {
            FedoraTypesUtils.value2string.apply((Object)mockValue);
            Assert.fail((String)"Unexpected FedoraTypesUtils.value2string completion after RepositoryException!");
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        try {
            FedoraTypesUtils.value2string.apply(null);
            Assert.fail((String)"Unexpected FedoraTypesUtils.value2string completion with null argument!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static interface PropertyMock
    extends Property,
    Namespaced {
    }
}

