/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.impl.DefaultGraphSubjects;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.services.functions.GetClusterConfiguration;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.JcrRdfTools;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.fcrepo.kernel.utils.NamespaceTools;
import org.fcrepo.kernel.utils.NodeIterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.BinaryValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrRdfToolsTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrRdfToolsTest.class);
    private GraphSubjects testSubjects;
    @Mock
    private com.hp.hpl.jena.rdf.model.Property mockPredicate;
    @Mock
    private Function<Property, com.hp.hpl.jena.rdf.model.Property> mockPredicateFactoryFunc;
    @Mock
    private javax.jcr.NodeIterator mockNodes;
    @Mock
    private Function<javax.jcr.Node, ValueFactory> mockValueFactoryFunc;
    @Mock
    private javax.jcr.Node mockNode;
    @Mock
    private javax.jcr.Node mockParent;
    @Mock
    private NamespaceRegistry mockNsRegistry;
    @Mock
    private GraphSubjects mockFactory;
    @Mock
    private Resource mockSubject;
    @Mock
    private Resource mockResource;
    @Mock
    private Session mockSession;
    @Mock
    private NodeType mockNodeType;
    @Mock
    private Property mockProperty;
    @Mock
    private Value mockValue;
    @Mock
    private Repository mockRepository;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private PropertyIterator mockProperties;
    @Mock
    private PropertyIterator mockParentProperties;
    @Mock
    private LowLevelStorageService mockLowLevelStorageService;
    @Mock
    private javax.jcr.Node mockNodeContent;
    @Mock
    private Version mockVersion;
    @Mock
    private javax.jcr.Node mockFrozenNode;
    @Mock
    private VersionManager mockVersionManager;
    @Mock
    private VersionIterator mockVersionIterator;
    @Mock
    private VersionHistory mockVersionHistory;
    @Mock
    private BinaryValue mockBinary;
    @Mock
    private LowLevelCacheEntry mockCacheEntry;
    @Mock
    private QueryManager mockQueryManager;
    @Mock
    private Query mockQuery;
    @Mock
    private ValueFactory mockValueFactory;
    @Mock
    private QueryResult mockQueryResult;
    @Mock
    private RowIterator mockRowIterator;
    @Mock
    private MetricRegistry mockMetrics;
    @Mock
    private javax.jcr.Node mockChildNode;
    @Mock
    private javax.jcr.Node mockContentNode;
    @Mock
    private javax.jcr.Node mockFullChildNode;
    @Mock
    private Counter mockCounter;
    @Mock
    private GetClusterConfiguration mockGetClusterConfiguration;
    @Mock
    private NodeTypeManager mockNodeTypeManager;
    @Mock
    private NodeTypeIterator mockNodeTypeIterator;
    private JcrRdfTools testObj;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.testSubjects = new DefaultGraphSubjects(this.mockSession);
        this.testObj = new JcrRdfTools(this.testSubjects, this.mockSession);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getRepository()).thenReturn((Object)this.mockRepository);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        this.mockNamespaceRegistry();
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNsRegistry);
    }

    @Test
    public void shouldMapInternalJcrNamespaceToFcrepoNamespace() {
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/repository#", (Object)JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"http://www.jcp.org/jcr/1.0"));
    }

    @Test
    public void shouldMapFcrepoNamespaceToJcrNamespace() {
        Assert.assertEquals((Object)"http://www.jcp.org/jcr/1.0", (Object)JcrRdfTools.getJcrNamespaceForRDFNamespace((String)"http://fedora.info/definitions/v4/repository#"));
    }

    @Test
    public void shouldPassThroughOtherNamespaceValues() {
        Assert.assertEquals((Object)"some-namespace-uri", (Object)JcrRdfTools.getJcrNamespaceForRDFNamespace((String)"some-namespace-uri"));
        Assert.assertEquals((Object)"some-namespace-uri", (Object)JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"some-namespace-uri"));
    }

    @Test
    public void shouldMapRdfPredicatesToJcrProperties() throws RepositoryException {
        com.hp.hpl.jena.rdf.model.Property p = ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#", (String)"uuid");
        Assert.assertEquals((Object)"jcr:uuid", (Object)this.testObj.getPropertyNameFromPredicate(this.mockNode, p));
    }

    @Test
    public void shouldReuseRegisteredNamespaces() throws RepositoryException {
        com.hp.hpl.jena.rdf.model.Property p = ResourceFactory.createProperty((String)"registered-uri#", (String)"uuid");
        Assert.assertEquals((Object)"some-prefix:uuid", (Object)this.testObj.getPropertyNameFromPredicate(this.mockNode, p));
    }

    @Test
    public void shouldRegisterUnknownUris() throws RepositoryException {
        Mockito.when((Object)this.mockNsRegistry.registerNamespace("not-registered-uri#")).thenReturn((Object)"ns001");
        com.hp.hpl.jena.rdf.model.Property p = ResourceFactory.createProperty((String)"not-registered-uri#", (String)"uuid");
        Assert.assertEquals((Object)"ns001:uuid", (Object)this.testObj.getPropertyNameFromPredicate(this.mockNode, p));
    }

    @Test
    public void testGetPropertiesModel() throws RepositoryException {
        Mockito.when((Object)this.mockParent.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType().getName()).thenReturn((Object)"");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockParent.getProperties()).thenReturn((Object)this.mockParentProperties);
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.mockParentProperties.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"xyz");
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)0);
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"abc");
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockProperties.nextProperty()).thenReturn((Object)this.mockProperty);
        Mockito.when((Object)this.mockParentProperties.nextProperty()).thenReturn((Object)this.mockProperty);
        Model actual = this.testObj.getJcrPropertiesModel(this.mockNode);
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/repository#", (Object)actual.getNsPrefixURI("fcrepo"));
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getGraphSubject(this.mockNode), actual.getProperty("xyz"), (RDFNode)actual.createLiteral("abc")));
    }

    @Test
    public void testGetPropertiesModelWithContent() throws RepositoryException {
        JcrRdfTools.setLlstore((LowLevelStorageService)this.mockLowLevelStorageService);
        Mockito.when((Object)this.mockParent.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType().getName()).thenReturn((Object)"");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodeContent.getPath()).thenReturn((Object)"/test/jcr/jcr:content");
        Mockito.when((Object)this.mockBinary.getKey()).thenReturn((Object)new BinaryKey("abc"));
        Mockito.when((Object)this.mockProperty.getBinary()).thenReturn((Object)this.mockBinary);
        Mockito.when((Object)this.mockNodeContent.getProperty("jcr:data")).thenReturn((Object)this.mockProperty);
        Mockito.when((Object)this.mockCacheEntry.getExternalIdentifier()).thenReturn((Object)"xyz");
        Mockito.when((Object)this.mockLowLevelStorageService.getLowLevelCacheEntries(this.mockNodeContent)).thenReturn((Object)ImmutableSet.of((Object)this.mockCacheEntry));
        Mockito.when((Object)this.mockNode.getNode("jcr:content")).thenReturn((Object)this.mockNodeContent);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockParent.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockNodeContent.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Model actual = this.testObj.getJcrPropertiesModel(this.mockNode);
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/repository#", (Object)actual.getNsPrefixURI("fcrepo"));
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getGraphSubject(this.mockNode), RdfLexicon.HAS_CONTENT, (RDFNode)this.testSubjects.getGraphSubject(this.mockNodeContent)));
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getGraphSubject(this.mockNodeContent), RdfLexicon.HAS_LOCATION, (RDFNode)actual.createLiteral("xyz")));
    }

    @Test
    public void testGetPropertiesModelForRootNode() throws RepositoryException {
        Mockito.when((Object)this.mockRepository.login()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockRowIterator.getSize()).thenReturn((Object)0L);
        Mockito.when((Object)this.mockQueryResult.getRows()).thenReturn((Object)this.mockRowIterator);
        Mockito.when((Object)this.mockQuery.execute()).thenReturn((Object)this.mockQueryResult);
        Mockito.when((Object)this.mockQueryManager.createQuery(Matchers.anyString(), (String)Matchers.eq((Object)"JCR-SQL2"))).thenReturn((Object)this.mockQuery);
        Mockito.when((Object)this.mockWorkspace.getQueryManager()).thenReturn((Object)this.mockQueryManager);
        Mockito.when((Object)this.mockMetrics.getCounters()).thenReturn((Object)ImmutableSortedMap.of((Comparable)((Object)"LowLevelStorageService.fixity-check-counter"), (Object)this.mockCounter, (Comparable)((Object)"LowLevelStorageService.fixity-error-counter"), (Object)this.mockCounter, (Comparable)((Object)"LowLevelStorageService.fixity-repaired-counter"), (Object)this.mockCounter));
        Mockito.when((Object)this.mockGetClusterConfiguration.apply(this.mockRepository)).thenReturn((Object)ImmutableMap.of((Object)"a", (Object)"b"));
        JcrRdfTools.setGetClusterConfiguration((GetClusterConfiguration)this.mockGetClusterConfiguration);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/");
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType().getName()).thenReturn((Object)"mode:root");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockSession.getRepository()).thenReturn((Object)this.mockRepository);
        Mockito.when((Object)this.mockRepository.getDescriptorKeys()).thenReturn((Object)new String[]{"some-descriptor-key"});
        Mockito.when((Object)this.mockRepository.getDescriptor("some-descriptor-key")).thenReturn((Object)"some-descriptor-value");
        Mockito.when((Object)this.mockNodeTypeIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNodeTypeManager.getAllNodeTypes()).thenReturn((Object)this.mockNodeTypeIterator);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Model actual = this.testObj.getJcrPropertiesModel(this.mockNode);
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/repository#", (Object)actual.getNsPrefixURI("fcrepo"));
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getGraphSubject(this.mockNode), actual.createProperty("http://fedora.info/definitions/v4/repository#repository/some-descriptor-key"), (RDFNode)actual.createLiteral("some-descriptor-value")));
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getGraphSubject(this.mockNode), actual.createProperty("http://fedora.info/definitions/v4/repository#a"), (RDFNode)actual.createLiteral("b")));
    }

    @Test
    public void shouldExcludeBinaryProperties() throws RepositoryException {
        Mockito.when((Object)this.mockParent.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)2);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType().getName()).thenReturn((Object)"fedora:object");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockParent.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)2);
        Mockito.when((Object)this.mockProperties.nextProperty()).thenReturn((Object)this.mockProperty);
        Model actual = this.testObj.getJcrPropertiesModel(this.mockNode);
        Assert.assertEquals((long)0L, (long)actual.size());
    }

    @Test
    public void shouldBeAbleToDisableResourceInlining() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Model actual = this.testObj.getJcrTreeModel(this.mockNode, 0L, -2);
        Assert.assertEquals((long)0L, (long)Iterators.size((Iterator)actual.listObjectsOfProperty(actual.createProperty("http://www.w3.org/ns/ldp#inlinedResource"))));
        ((javax.jcr.Node)Mockito.verify((Object)this.mockParent, (VerificationMode)Mockito.never())).getProperties();
        ((javax.jcr.Node)Mockito.verify((Object)this.mockNode, (VerificationMode)Mockito.never())).getNodes();
    }

    @Test
    public void shouldIncludeLinkedDataPlatformContainerInformation() throws RepositoryException {
        Mockito.when((Object)this.mockParent.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        NodeType mockPrimaryNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockPrimaryNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[]{(NodeDefinition)Mockito.mock(NodeDefinition.class)});
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)mockPrimaryNodeType);
        Mockito.when((Object)this.mockParent.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)0);
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Model actual = this.testObj.getJcrTreeModel(this.mockNode, 0L, -1);
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getContext(), RDF.type, (RDFNode)actual.createProperty("http://www.w3.org/ns/ldp#Page")));
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getContext(), actual.createProperty("http://www.w3.org/ns/ldp#membersInlined"), (RDFNode)actual.createTypedLiteral(true)));
        Resource graphSubject = this.testSubjects.getGraphSubject(this.mockNode);
        Assert.assertTrue((boolean)actual.contains(graphSubject, RDF.type, (RDFNode)actual.createProperty("http://www.w3.org/ns/ldp#Container")));
        Assert.assertTrue((boolean)actual.contains(graphSubject, actual.createProperty("http://www.w3.org/ns/ldp#membershipSubject"), (RDFNode)graphSubject));
        Assert.assertTrue((boolean)actual.contains(graphSubject, actual.createProperty("http://www.w3.org/ns/ldp#membershipPredicate"), (RDFNode)RdfLexicon.HAS_CHILD));
        Assert.assertTrue((boolean)actual.contains(graphSubject, actual.createProperty("http://www.w3.org/ns/ldp#membershipObject"), (RDFNode)actual.createResource("http://www.w3.org/ns/ldp#MemberSubject")));
    }

    @Test
    public void shouldIncludeContainerInfoWithMixinTypeContainer() throws RepositoryException {
        Mockito.when((Object)this.mockParent.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        NodeType mockPrimaryNodeType = (NodeType)Mockito.mock(NodeType.class);
        NodeType mockMixinNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockPrimaryNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[0]);
        Mockito.when((Object)mockMixinNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[]{(NodeDefinition)Mockito.mock(NodeDefinition.class)});
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)mockPrimaryNodeType);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{mockMixinNodeType});
        Mockito.when((Object)this.mockParent.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)0);
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Model actual = this.testObj.getJcrTreeModel(this.mockNode, 0L, -1);
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getContext(), RDF.type, (RDFNode)actual.createProperty("http://www.w3.org/ns/ldp#Page")));
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getContext(), actual.createProperty("http://www.w3.org/ns/ldp#membersInlined"), (RDFNode)actual.createTypedLiteral(true)));
        Resource graphSubject = this.testSubjects.getGraphSubject(this.mockNode);
        Assert.assertTrue((boolean)actual.contains(graphSubject, RDF.type, (RDFNode)actual.createProperty("http://www.w3.org/ns/ldp#Container")));
        Assert.assertTrue((boolean)actual.contains(graphSubject, actual.createProperty("http://www.w3.org/ns/ldp#membershipSubject"), (RDFNode)graphSubject));
        Assert.assertTrue((boolean)actual.contains(graphSubject, actual.createProperty("http://www.w3.org/ns/ldp#membershipPredicate"), (RDFNode)RdfLexicon.HAS_CHILD));
        Assert.assertTrue((boolean)actual.contains(graphSubject, actual.createProperty("http://www.w3.org/ns/ldp#membershipObject"), (RDFNode)actual.createResource("http://www.w3.org/ns/ldp#MemberSubject")));
    }

    @Test
    public void shouldNotIncludeContainerInfoIfItIsntContainer() throws RepositoryException {
        Mockito.when((Object)this.mockParent.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        NodeType mockPrimaryNodeType = (NodeType)Mockito.mock(NodeType.class);
        NodeType mockMixinNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockPrimaryNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[0]);
        Mockito.when((Object)mockMixinNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[0]);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)mockPrimaryNodeType);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{mockMixinNodeType});
        Mockito.when((Object)this.mockParent.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)0);
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Model actual = this.testObj.getJcrTreeModel(this.mockNode, 0L, -1);
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getContext(), RDF.type, (RDFNode)actual.createProperty("http://www.w3.org/ns/ldp#Page")));
        Assert.assertFalse((boolean)actual.contains(this.testSubjects.getContext(), actual.createProperty("http://www.w3.org/ns/ldp#membersInlined"), (RDFNode)actual.createTypedLiteral(true)));
        Resource graphSubject = this.testSubjects.getGraphSubject(this.mockNode);
        Assert.assertFalse((boolean)actual.contains(graphSubject, RDF.type, (RDFNode)actual.createProperty("http://www.w3.org/ns/ldp#Container")));
        Assert.assertFalse((boolean)actual.contains(graphSubject, actual.createProperty("http://www.w3.org/ns/ldp#membershipSubject"), (RDFNode)graphSubject));
        Assert.assertFalse((boolean)actual.contains(graphSubject, actual.createProperty("http://www.w3.org/ns/ldp#membershipPredicate"), (RDFNode)RdfLexicon.HAS_CHILD));
        Assert.assertFalse((boolean)actual.contains(graphSubject, actual.createProperty("http://www.w3.org/ns/ldp#membershipObject"), (RDFNode)actual.createResource("http://www.w3.org/ns/ldp#MemberSubject")));
    }

    @Test
    public void shouldIncludeParentNodeInformation() throws RepositoryException {
        Mockito.when((Object)this.mockParent.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        NodeType mockPrimaryNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockPrimaryNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[]{(NodeDefinition)Mockito.mock(NodeDefinition.class)});
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)mockPrimaryNodeType);
        Mockito.when((Object)this.mockParent.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)2);
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Model actual = this.testObj.getJcrTreeModel(this.mockNode, 0L, -1);
        Assert.assertEquals((long)1L, (long)Iterators.size((Iterator)actual.listObjectsOfProperty(RdfLexicon.HAS_CHILD)));
    }

    @Test
    public void shouldIncludeChildNodeInformation() throws RepositoryException {
        Mockito.when((Object)this.mockParent.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        NodeType mockPrimaryNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockPrimaryNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[]{(NodeDefinition)Mockito.mock(NodeDefinition.class)});
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)mockPrimaryNodeType);
        Mockito.when((Object)this.mockParent.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)0);
        Mockito.when((Object)this.mockChildNode.getName()).thenReturn((Object)"some-name");
        Mockito.when((Object)this.mockChildNode.getPath()).thenReturn((Object)"/test/jcr/1", (Object[])new String[]{"/test/jcr/2", "/test/jcr/3", "/test/jcr/4", "/test/jcr/5"});
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, true, false});
        Mockito.when((Object)this.mockNode.hasNodes()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodes.nextNode()).thenReturn((Object)this.mockChildNode);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Model actual = this.testObj.getJcrTreeModel(this.mockNode, 0L, 0);
        Assert.assertEquals((long)5L, (long)Iterators.size((Iterator)actual.listObjectsOfProperty(RdfLexicon.HAS_CHILD)));
    }

    @Test
    public void shouldIncludeFullChildNodeInformationInsideWindow() throws RepositoryException {
        Mockito.when((Object)this.mockParent.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        Mockito.when((Object)this.mockNode.getDepth()).thenReturn((Object)0);
        NodeType mockPrimaryNodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)mockPrimaryNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[]{(NodeDefinition)Mockito.mock(NodeDefinition.class)});
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)mockPrimaryNodeType);
        Mockito.when((Object)this.mockChildNode.getName()).thenReturn((Object)"some-name");
        Mockito.when((Object)this.mockChildNode.getPath()).thenReturn((Object)"/test/jcr/1", (Object[])new String[]{"/test/jcr/4", "/test/jcr/5"});
        Mockito.when((Object)this.mockFullChildNode.getName()).thenReturn((Object)"some-other-name");
        Mockito.when((Object)this.mockFullChildNode.getPath()).thenReturn((Object)"/test/jcr/2", (Object[])new String[]{"/test/jcr/3"});
        Mockito.when((Object)this.mockFullChildNode.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, false});
        Mockito.when((Object)this.mockNode.hasNodes()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNodes.nextNode()).thenReturn((Object)this.mockChildNode, (Object[])new javax.jcr.Node[]{this.mockFullChildNode, this.mockFullChildNode, this.mockChildNode, this.mockChildNode});
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Model actual = this.testObj.getJcrTreeModel(this.mockNode, 1L, 2);
        Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)actual.listSubjectsWithProperty(RdfLexicon.HAS_PARENT)));
        ((javax.jcr.Node)Mockito.verify((Object)this.mockChildNode, (VerificationMode)Mockito.never())).getProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldMapRdfValuesToJcrPropertyValues() throws RepositoryException {
        Mockito.when((Object)this.mockValueFactoryFunc.apply((Object)this.mockNode)).thenReturn((Object)this.mockValueFactory);
        Function holdValueFactory = FedoraTypesUtils.getValueFactory;
        FedoraTypesUtils.getValueFactory = this.mockValueFactoryFunc;
        try {
            Resource n = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/rest-api#/abc");
            Mockito.when((Object)this.mockSession.getNode("/abc")).thenReturn((Object)this.mockNode);
            Mockito.when((Object)this.mockSession.nodeExists("/abc")).thenReturn((Object)true);
            this.testObj.createValue(this.mockNode, (RDFNode)n, 9);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(this.mockNode, false);
            this.testObj.createValue(this.mockNode, (RDFNode)n, 10);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(this.mockNode, true);
            this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue("http://fedora.info/definitions/v4/rest-api#/abc", 11);
            n = ResourceFactory.createResource();
            this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(n.toString(), 0);
            n = ResourceFactory.createTypedLiteral((Object)true);
            this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(true);
            n = ResourceFactory.createTypedLiteral((String)"1", (RDFDatatype)XSDDatatype.XSDbyte);
            this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(1L);
            n = ResourceFactory.createTypedLiteral((Object)2.0);
            this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(2.0);
            n = ResourceFactory.createTypedLiteral((Object)Float.valueOf(3.0f));
            this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(3.0);
            n = ResourceFactory.createTypedLiteral((Object)4);
            this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(4L);
            n = ResourceFactory.createTypedLiteral((String)"5", (RDFDatatype)XSDDatatype.XSDlong);
            this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(5L);
            n = ResourceFactory.createTypedLiteral((String)"6", (RDFDatatype)XSDDatatype.XSDshort);
            this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(6L);
            Calendar calendar = Calendar.getInstance();
            n = ResourceFactory.createTypedLiteral((Object)calendar);
            this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue((Calendar)Matchers.any(Calendar.class));
            n = ResourceFactory.createTypedLiteral((Object)"string");
            this.testObj.createValue(this.mockNode, (RDFNode)n, 0);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue("string", 1);
            n = ResourceFactory.createTypedLiteral((Object)"string");
            this.testObj.createValue(this.mockNode, (RDFNode)n, 7);
            ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue("string", 7);
        }
        finally {
            FedoraTypesUtils.getValueFactory = holdValueFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAddPropertiesToModel() throws RepositoryException {
        Mockito.when((Object)this.mockPredicateFactoryFunc.apply((Object)this.mockProperty)).thenReturn((Object)this.mockPredicate);
        Function holdPredicate = FedoraTypesUtils.getPredicateForProperty;
        FedoraTypesUtils.getPredicateForProperty = this.mockPredicateFactoryFunc;
        try {
            Resource mockSubject = (Resource)Mockito.mock(Resource.class);
            Model mockModel = (Model)Mockito.mock(Model.class);
            Value mockValue = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)mockValue.getString()).thenReturn((Object)"");
            Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
            Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)mockValue);
            this.testObj.addPropertyToModel(mockSubject, mockModel, this.mockProperty);
            ((Model)Mockito.verify((Object)mockModel)).add(mockSubject, this.mockPredicate, "");
        }
        finally {
            FedoraTypesUtils.getPredicateForProperty = holdPredicate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAddMultivaluedPropertiesToModel() throws RepositoryException {
        Mockito.when((Object)this.mockPredicateFactoryFunc.apply((Object)this.mockProperty)).thenReturn((Object)this.mockPredicate);
        Function holdPredicate = FedoraTypesUtils.getPredicateForProperty;
        FedoraTypesUtils.getPredicateForProperty = this.mockPredicateFactoryFunc;
        try {
            Resource mockSubject = (Resource)Mockito.mock(Resource.class);
            Model mockModel = (Model)Mockito.mock(Model.class);
            Value mockValue = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)mockValue.getString()).thenReturn((Object)"1");
            Value mockValue2 = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)mockValue2.getString()).thenReturn((Object)"2");
            Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
            Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)Arrays.asList(mockValue, mockValue2).toArray(new Value[2]));
            this.testObj.addPropertyToModel(mockSubject, mockModel, this.mockProperty);
            ((Model)Mockito.verify((Object)mockModel)).add(mockSubject, this.mockPredicate, "1");
            ((Model)Mockito.verify((Object)mockModel)).add(mockSubject, this.mockPredicate, "2");
        }
        finally {
            FedoraTypesUtils.getPredicateForProperty = holdPredicate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldMapJcrTypesToRdfDataTypes() throws RepositoryException {
        Resource mockSubject = ResourceFactory.createResource((String)"some-resource-uri");
        Model mockModel = ModelFactory.createDefaultModel();
        com.hp.hpl.jena.rdf.model.Property mockPredicate = mockModel.createProperty("some-predicate-uri");
        Mockito.when((Object)this.mockPredicateFactoryFunc.apply((Object)this.mockProperty)).thenReturn((Object)mockPredicate);
        Function holdPredicate = FedoraTypesUtils.getPredicateForProperty;
        FedoraTypesUtils.getPredicateForProperty = this.mockPredicateFactoryFunc;
        try {
            Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)6);
            Mockito.when((Object)this.mockValue.getBoolean()).thenReturn((Object)true);
            this.testObj.addPropertyToModel(mockSubject, mockModel, this.mockProperty, this.mockValue);
            Assert.assertTrue((boolean)mockModel.contains(mockSubject, mockPredicate, (RDFNode)ResourceFactory.createTypedLiteral((Object)true)));
            this.mockValue = (Value)Mockito.mock(Value.class);
            Calendar mockCalendar = Calendar.getInstance();
            Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)5);
            Mockito.when((Object)this.mockValue.getDate()).thenReturn((Object)mockCalendar);
            this.testObj.addPropertyToModel(mockSubject, mockModel, this.mockProperty, this.mockValue);
            Assert.assertTrue((boolean)mockModel.contains(mockSubject, mockPredicate, (RDFNode)ResourceFactory.createTypedLiteral((Object)mockCalendar)));
            this.mockValue = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)12);
            Mockito.when((Object)this.mockValue.getDecimal()).thenReturn((Object)BigDecimal.valueOf(0.0));
            this.testObj.addPropertyToModel(mockSubject, mockModel, this.mockProperty, this.mockValue);
            Assert.assertTrue((boolean)mockModel.contains(mockSubject, mockPredicate, (RDFNode)ResourceFactory.createTypedLiteral((Object)BigDecimal.valueOf(0.0))));
            this.mockValue = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)4);
            Mockito.when((Object)this.mockValue.getDouble()).thenReturn((Object)0.0);
            this.testObj.addPropertyToModel(mockSubject, mockModel, this.mockProperty, this.mockValue);
            Assert.assertTrue((boolean)mockModel.contains(mockSubject, mockPredicate, (RDFNode)ResourceFactory.createTypedLiteral((Object)0.0)));
            this.mockValue = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)3);
            Mockito.when((Object)this.mockValue.getLong()).thenReturn((Object)0L);
            this.testObj.addPropertyToModel(mockSubject, mockModel, this.mockProperty, this.mockValue);
            Assert.assertTrue((boolean)mockModel.contains(mockSubject, mockPredicate, (RDFNode)ResourceFactory.createTypedLiteral((Object)0L)));
            this.mockValue = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)1);
            Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"XYZ");
            this.testObj.addPropertyToModel(mockSubject, mockModel, this.mockProperty, this.mockValue);
            Assert.assertTrue((boolean)mockModel.contains(mockSubject, mockPredicate, (RDFNode)ResourceFactory.createTypedLiteral((Object)"XYZ")));
            this.mockValue = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)11);
            Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"info:fedora");
            this.testObj.addPropertyToModel(mockSubject, mockModel, this.mockProperty, this.mockValue);
            Assert.assertTrue((boolean)mockModel.contains(mockSubject, mockPredicate, (RDFNode)ResourceFactory.createResource((String)"info:fedora")));
            this.mockValue = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)this.mockProperty.getSession()).thenReturn((Object)this.mockSession);
            Mockito.when((Object)this.mockSession.getNodeByIdentifier("uuid")).thenReturn((Object)this.mockNode);
            Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/abc");
            Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)9);
            Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"uuid");
            this.testObj.addPropertyToModel(mockSubject, mockModel, this.mockProperty, this.mockValue);
            Assert.assertTrue((boolean)mockModel.contains(mockSubject, mockPredicate, (RDFNode)ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/rest-api#/abc")));
            this.mockValue = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)10);
            Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"uuid");
            Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/def");
            this.testObj.addPropertyToModel(mockSubject, mockModel, this.mockProperty, this.mockValue);
            Assert.assertTrue((boolean)mockModel.contains(mockSubject, mockPredicate, (RDFNode)ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/rest-api#/def")));
            this.mockValue = (Value)Mockito.mock(Value.class);
            Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)8);
            Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"/ghi");
            this.testObj.addPropertyToModel(mockSubject, mockModel, this.mockProperty, this.mockValue);
            Assert.assertTrue((boolean)mockModel.contains(mockSubject, mockPredicate, (RDFNode)ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/rest-api#/ghi")));
        }
        finally {
            FedoraTypesUtils.getPredicateForProperty = holdPredicate;
        }
    }

    @Test
    @Ignore
    public void testJcrNodeContent() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType().getName()).thenReturn((Object)"");
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/path/to/node");
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Mockito.when((Object)this.mockContentNode.getPath()).thenReturn((Object)"/path/to/node/content");
        Mockito.when((Object)this.mockContentNode.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)this.mockContentNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockNode.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.getNode("jcr:content")).thenReturn((Object)this.mockContentNode);
        Model model = this.testObj.getJcrPropertiesModel(this.mockNode);
        Assert.assertTrue((model != null ? 1 : 0) != 0);
    }

    @Test
    public void testJcrNodeIteratorModel() throws RepositoryException {
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)false);
        Model model = this.testObj.getJcrPropertiesModel((Iterator)new NodeIterator(this.mockNodes), this.mockResource);
        Assert.assertTrue((model != null ? 1 : 0) != 0);
    }

    @Test
    public void testJcrNodeIteratorAddsPredicatesForEachNode() throws RepositoryException {
        Resource mockResource = ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/rest-api#/search/resource");
        javax.jcr.Node mockNode1 = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        javax.jcr.Node mockNode2 = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        javax.jcr.Node mockNode3 = (javax.jcr.Node)Mockito.mock(javax.jcr.Node.class);
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)mockNode1.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)mockNode1.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)mockNode1.getPath()).thenReturn((Object)"/path/to/first/node");
        Mockito.when((Object)mockNode2.getPath()).thenReturn((Object)"/second/path/to/node");
        Mockito.when((Object)mockNode3.getPath()).thenReturn((Object)"/third/path/to/node");
        Mockito.when((Object)mockNode1.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)mockNode2.getProperties()).thenReturn((Object)this.mockProperties);
        Mockito.when((Object)mockNode3.getProperties()).thenReturn((Object)this.mockProperties);
        Iterator<javax.jcr.Node> mockIterator = Arrays.asList(mockNode1, mockNode2, mockNode3).iterator();
        Model model = this.testObj.getJcrPropertiesModel(mockIterator, mockResource);
        Assert.assertEquals((long)3L, (long)model.listObjectsOfProperty(RdfLexicon.HAS_MEMBER_OF_RESULT).toSet().size());
    }

    @Test
    public void testGetFixityResultsModel() throws RepositoryException, URISyntaxException {
        Mockito.when((Object)this.mockCacheEntry.getExternalIdentifier()).thenReturn((Object)"xyz");
        FixityResult mockResult = new FixityResult(this.mockCacheEntry, 123L, new URI("abc"));
        mockResult.status.add(FixityResult.FixityState.BAD_CHECKSUM);
        mockResult.status.add(FixityResult.FixityState.BAD_SIZE);
        List<FixityResult> mockBlobs = Arrays.asList(mockResult);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/path/to/node");
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)this.mockProperties);
        Model fixityResultsModel = this.testObj.getJcrPropertiesModel(this.mockNode, mockBlobs);
        LOGGER.debug("Got graph {}", (Object)fixityResultsModel);
        GraphStore gs = GraphStoreFactory.create((Model)fixityResultsModel);
        Assert.assertTrue((boolean)gs.contains(Node.ANY, Node.ANY, RdfLexicon.IS_FIXITY_RESULT_OF.asNode(), ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/rest-api#/path/to/node").asNode()));
        Assert.assertTrue((boolean)gs.contains(Node.ANY, Node.ANY, RdfLexicon.HAS_COMPUTED_CHECKSUM.asNode(), ResourceFactory.createResource((String)"abc").asNode()));
        Assert.assertTrue((boolean)gs.contains(Node.ANY, Node.ANY, RdfLexicon.HAS_COMPUTED_SIZE.asNode(), ResourceFactory.createTypedLiteral((Object)123).asNode()));
    }

    @Test
    public void testGetJcrNamespaceModel() throws Exception {
        Model jcrNamespaceModel = this.testObj.getJcrNamespaceModel();
        Assert.assertTrue((boolean)jcrNamespaceModel.contains(ResourceFactory.createResource((String)"http://fedora.info/definitions/v4/repository#"), RdfLexicon.HAS_NAMESPACE_PREFIX, "fcrepo"));
        Resource nsSubject = ResourceFactory.createResource((String)"registered-uri#");
        Assert.assertTrue((boolean)jcrNamespaceModel.contains(nsSubject, RDF.type, (RDFNode)RdfLexicon.VOAF_VOCABULARY));
        Assert.assertTrue((boolean)jcrNamespaceModel.contains(nsSubject, RdfLexicon.HAS_NAMESPACE_PREFIX, "some-prefix"));
        Assert.assertTrue((boolean)jcrNamespaceModel.contains(nsSubject, RdfLexicon.HAS_NAMESPACE_URI, "registered-uri#"));
    }

    @Test
    public void testGetJcrVersionsModel() throws Exception {
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockVersionManager.getVersionHistory(this.mockNode.getPath())).thenReturn((Object)this.mockVersionHistory);
        Mockito.when((Object)this.mockVersionIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.mockFrozenNode.getPath()).thenReturn((Object)"/jcr:system/versions/test/jcr");
        Mockito.when((Object)this.mockVersion.getFrozenNode()).thenReturn((Object)this.mockFrozenNode);
        Mockito.when((Object)this.mockVersionIterator.nextVersion()).thenReturn((Object)this.mockVersion);
        Mockito.when((Object)this.mockVersionHistory.getAllVersions()).thenReturn((Object)this.mockVersionIterator);
        Mockito.when((Object)this.mockWorkspace.getVersionManager()).thenReturn((Object)this.mockVersionManager);
        Mockito.when((Object)this.mockVersionHistory.getVersionLabels(this.mockVersion)).thenReturn((Object)new String[]{"abc"});
        Mockito.when((Object)this.mockProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockFrozenNode.getProperties()).thenReturn((Object)this.mockProperties);
        Model actual = this.testObj.getJcrPropertiesModel(this.mockVersionHistory, this.testSubjects.getGraphSubject(this.mockNode));
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getGraphSubject(this.mockNode), RdfLexicon.HAS_VERSION, (RDFNode)this.testSubjects.getGraphSubject(this.mockFrozenNode)));
        Assert.assertTrue((boolean)actual.contains(this.testSubjects.getGraphSubject(this.mockFrozenNode), RdfLexicon.HAS_VERSION_LABEL, (RDFNode)actual.createLiteral("abc")));
    }

    @Test
    public void testIsInternalProperty() throws Exception {
        Assert.assertTrue((boolean)this.testObj.isInternalProperty(this.mockNode, (Resource)ResourceFactory.createProperty((String)"http://fedora.info/definitions/v4/repository#", (String)"some-property")));
        Assert.assertTrue((boolean)this.testObj.isInternalProperty(this.mockNode, (Resource)ResourceFactory.createProperty((String)"http://www.jcp.org/jcr/1.0", (String)"some-property")));
        Assert.assertTrue((boolean)this.testObj.isInternalProperty(this.mockNode, (Resource)ResourceFactory.createProperty((String)"http://www.w3.org/ns/ldp#some-property")));
        Assert.assertFalse((boolean)this.testObj.isInternalProperty(this.mockNode, (Resource)ResourceFactory.createProperty((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#label")));
        Assert.assertFalse((boolean)this.testObj.isInternalProperty(this.mockNode, (Resource)ResourceFactory.createProperty((String)"my-own-ns", (String)"some-property")));
    }

    private void mockNamespaceRegistry() throws RepositoryException {
        Mockito.when((Object)this.mockNsRegistry.isRegisteredUri("registered-uri#")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNsRegistry.isRegisteredUri("not-registered-uri#")).thenReturn((Object)false);
        Mockito.when((Object)this.mockNsRegistry.isRegisteredUri("http://www.jcp.org/jcr/1.0")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNsRegistry.getPrefix("http://www.jcp.org/jcr/1.0")).thenReturn((Object)"jcr");
        Mockito.when((Object)this.mockNsRegistry.getPrefix("registered-uri#")).thenReturn((Object)"some-prefix");
        Mockito.when((Object)this.mockNsRegistry.getURI("jcr")).thenReturn((Object)"http://www.jcp.org/jcr/1.0");
        Mockito.when((Object)this.mockNsRegistry.getURI("some-prefix")).thenReturn((Object)"registered-uri#");
        Mockito.when((Object)this.mockNsRegistry.getPrefixes()).thenReturn((Object)new String[]{"jcr", "some-prefix"});
        Mockito.when((Object)NamespaceTools.getNamespaceRegistry((Session)this.mockSession)).thenReturn((Object)this.mockNsRegistry);
        Mockito.when((Object)NamespaceTools.getNamespaceRegistry((Item)this.mockNode)).thenReturn((Object)this.mockNsRegistry);
    }
}

