/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.fcrepo.kernel.utils.ContentDigest;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.fcrepo.kernel.utils.impl.CacheStoreEntry;
import org.fcrepo.kernel.utils.impl.LocalBinaryStoreEntry;
import org.fcrepo.kernel.utils.infinispan.StoreChunkInputStream;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.CacheStoreConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.modeshape.jcr.value.binary.FileSystemBinaryStore;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={StoreChunkInputStream.class})
public class LowLevelCacheEntryTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(LowLevelCacheEntryTest.class);
    private LowLevelCacheEntry testObj;
    private LowLevelCacheEntry testIspnObj;
    @Mock
    private InputStream mockIS;
    @Mock
    private BinaryStore mockStore;
    @Mock
    private BinaryStore otherStore;
    @Mock
    private CacheStore mockLowLevelCacheStore;
    @Mock
    private CacheStoreConfig mockConfig;
    @Mock
    private FileSystemBinaryStore fsbs;
    private BinaryKey testKey;

    @Before
    public void setUp() throws Exception {
        this.testKey = new BinaryKey("test-key-123");
        this.testObj = new LocalBinaryStoreEntry(this.mockStore, this.testKey);
        this.testIspnObj = new CacheStoreEntry(this.mockLowLevelCacheStore, "foo", this.testKey);
    }

    @Test
    public void shouldBeEqualIfTheKeyAndStoreAreEqual() throws Exception {
        LocalBinaryStoreEntry otherObj = new LocalBinaryStoreEntry(this.mockStore, this.testKey);
        Assert.assertTrue((boolean)this.testObj.equals(otherObj));
    }

    @Test
    public void shouldBeEqualIfTheKeyStoreAndCacheStoreAreEqual() throws Exception {
        CacheStoreEntry ispnObject = new CacheStoreEntry(this.mockLowLevelCacheStore, "foo", this.testKey);
        Assert.assertTrue((boolean)this.testIspnObj.equals(ispnObject));
    }

    @Test
    public void shouldNotBeEqualIfTheOtherObjectIsTotallyDifferent() throws Exception {
        Assert.assertFalse((boolean)this.testObj.equals(""));
    }

    @Test
    public void shouldNotBeEqualIfTheBinaryKeyIsDifferent() throws Exception {
        LocalBinaryStoreEntry otherObj = new LocalBinaryStoreEntry(this.mockStore, new BinaryKey("321-yek-tset"));
        Assert.assertFalse((boolean)this.testObj.equals(otherObj));
    }

    @Test
    public void shouldNotBeEqualIfTheStoreIsDifferent() throws Exception {
        LocalBinaryStoreEntry otherObj = new LocalBinaryStoreEntry(this.otherStore, this.testKey);
        Assert.assertFalse((boolean)this.testObj.equals(otherObj));
    }

    @Test
    public void testGetInputStream() throws Exception {
        Mockito.when((Object)this.mockStore.getInputStream(this.testKey)).thenReturn((Object)this.mockIS);
        Assert.assertEquals((Object)this.mockIS, (Object)this.testObj.getInputStream());
        ((BinaryStore)Mockito.verify((Object)this.mockStore)).getInputStream(this.testKey);
    }

    @Test
    public void testGetInputStreamWithAnInfinispanStore() throws Exception {
        PowerMockito.mockStatic(StoreChunkInputStream.class, (Class[])new Class[0]);
        Mockito.when((Object)this.mockStore.getInputStream(this.testKey)).thenReturn((Object)this.mockIS);
        InputStream is = this.testIspnObj.getInputStream();
        Assert.assertTrue((boolean)(is instanceof StoreChunkInputStream));
    }

    @Test
    public void testStoreValue() throws Exception {
        this.testObj.storeValue(this.mockIS);
        ((BinaryStore)Mockito.verify((Object)this.mockStore)).storeValue(this.mockIS);
        Mockito.when((Object)this.mockConfig.toString()).thenReturn((Object)"mockCacheStoreConfig");
        Mockito.when((Object)this.mockLowLevelCacheStore.getCacheStoreConfig()).thenReturn((Object)this.mockConfig);
        CacheStoreEntry ispnEntry = new CacheStoreEntry(this.mockLowLevelCacheStore, "foo", this.testKey);
        byte[] bytes = new byte[]{0, 1, 2, 3, 4};
        ispnEntry.storeValue((InputStream)new ByteArrayInputStream(bytes));
        ((CacheStore)Mockito.verify((Object)this.mockLowLevelCacheStore)).store((InternalCacheEntry)Matchers.any(InternalCacheEntry.class));
    }

    @Test
    public void testGetExternalIdentifier() throws Exception {
        Mockito.when((Object)this.mockStore.toString()).thenReturn((Object)"i-am-a-mock-store");
        this.testObj.setExternalId("zyx");
        Assert.assertEquals((Object)"zyx/i-am-a-mock-store", (Object)this.testObj.getExternalIdentifier());
    }

    @Test
    public void testFileSystemExternalIdentifier() throws Exception {
        Mockito.when((Object)this.fsbs.getDirectory()).thenReturn((Object)new File("/tmp/xyz"));
        LocalBinaryStoreEntry filesystemTestObj = new LocalBinaryStoreEntry((BinaryStore)this.fsbs, this.testKey);
        filesystemTestObj.setExternalId("zyx");
        String identifier = filesystemTestObj.getExternalIdentifier();
        Assert.assertTrue((boolean)identifier.startsWith("zyx/org.modeshape.jcr.value.binary.FileSystemBinaryStore"));
        Assert.assertTrue((boolean)identifier.endsWith(File.separator + "tmp" + File.separator + "xyz"));
    }

    @Test
    public void testGetFixity() throws BinaryStoreException, IOException, NoSuchAlgorithmException {
        LocalBinaryStoreEntry ispnEntry = new LocalBinaryStoreEntry(this.mockStore, this.testKey);
        final byte[] bytes = new byte[]{0, 1, 2, 3, 4};
        Mockito.when((Object)this.mockStore.getInputStream(this.testKey)).thenAnswer((Answer)new Answer<InputStream>(){

            public InputStream answer(InvocationOnMock invocation) throws Throwable {
                return new ByteArrayInputStream(bytes);
            }
        });
        MessageDigest d = MessageDigest.getInstance("SHA-1");
        byte[] digested = d.digest(bytes);
        URI testCS = ContentDigest.asURI((String)"SHA-1", (byte[])digested);
        LOGGER.debug(testCS.toString());
        FixityResult actual = ispnEntry.checkFixity(testCS, (long)bytes.length);
        Assert.assertEquals((long)1L, (long)actual.status.size());
        Assert.assertEquals((String)((FixityResult.FixityState)actual.status.iterator().next()).toString(), (Object)true, (Object)actual.status.contains(FixityResult.FixityState.SUCCESS));
        actual = ispnEntry.checkFixity(testCS, (long)(bytes.length + 1));
        Assert.assertEquals((long)1L, (long)actual.status.size());
        Assert.assertEquals((String)((FixityResult.FixityState)actual.status.iterator().next()).toString(), (Object)true, (Object)actual.status.contains(FixityResult.FixityState.BAD_SIZE));
        digested[0] = (byte)(digested[0] + 9);
        testCS = ContentDigest.asURI((String)"SHA-1", (byte[])digested);
        actual = ispnEntry.checkFixity(testCS, (long)bytes.length);
        Assert.assertEquals((long)1L, (long)actual.status.size());
        Assert.assertEquals((String)((FixityResult.FixityState)actual.status.iterator().next()).toString(), (Object)true, (Object)actual.status.contains(FixityResult.FixityState.BAD_CHECKSUM));
        actual = ispnEntry.checkFixity(testCS, (long)(bytes.length + 1));
        Assert.assertEquals((long)2L, (long)actual.status.size());
        Assert.assertEquals((Object)true, (Object)actual.status.contains(FixityResult.FixityState.BAD_CHECKSUM));
        Assert.assertEquals((Object)true, (Object)actual.status.contains(FixityResult.FixityState.BAD_SIZE));
    }
}

