/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.NodePropertiesTools;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PowerMockIgnore(value={"org.slf4j.*", "javax.xml.parsers.*", "org.apache.xerces.*"})
@PrepareForTest(value={FedoraTypesUtils.class})
public class NodePropertiesToolsTest {
    @Mock
    private PropertyDefinition mockDefinition;
    @Mock
    private Value mockValue;
    @Mock
    private Node mockNode;
    @Mock
    private Property mockProperty;
    @Mock
    private Value previousValue;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(FedoraTypesUtils.class, (Class[])new Class[0]);
        Mockito.when((Object)FedoraTypesUtils.getDefinitionForPropertyName((Node)this.mockNode, (String)"mockPropertyName")).thenReturn((Object)this.mockDefinition);
        Mockito.when((Object)this.mockNode.getProperty("mockPropertyName")).thenReturn((Object)this.mockProperty);
    }

    @Test
    public void addNewSingleValuedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockDefinition.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)false);
        NodePropertiesTools.appendOrReplaceNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Node)Mockito.verify((Object)this.mockNode)).setProperty("mockPropertyName", this.mockValue, 0);
    }

    @Test
    public void addNewMultiValuedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockDefinition.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)false);
        NodePropertiesTools.appendOrReplaceNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Node)Mockito.verify((Object)this.mockNode)).setProperty("mockPropertyName", Arrays.asList(this.mockValue).toArray(new Value[0]), 0);
    }

    @Test
    public void replaceExistingSingleValuedPropertyWithValue() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        NodePropertiesTools.appendOrReplaceNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue(this.mockValue);
    }

    @Test
    public void appendValueToExistingMultivaluedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        Value[] values = new Value[]{this.previousValue};
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)values);
        NodePropertiesTools.appendOrReplaceNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ArgumentCaptor valuesCaptor = ArgumentCaptor.forClass(Value[].class);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue((Value[])valuesCaptor.capture());
        List<Object> actualValues = Arrays.asList((Object[])valuesCaptor.getValue());
        Assert.assertEquals((long)2L, (long)actualValues.size());
        Assert.assertTrue((String)"actual values missing previous value", (boolean)actualValues.contains(this.previousValue));
        Assert.assertTrue((String)"actual values missing value we were adding", (boolean)actualValues.contains(this.mockValue));
    }

    @Test
    public void addMultiValuedPropertyWithSameValueAsExistingProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        Value[] values = new Value[]{this.previousValue};
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)values);
        NodePropertiesTools.appendOrReplaceNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.previousValue);
        ((Property)Mockito.verify((Object)this.mockProperty, (VerificationMode)Mockito.never())).setValue((Value[])Matchers.any(Value[].class));
    }

    @Test
    public void shouldBeANoopWhenRemovingPropertyThatDoesntExist() throws RepositoryException {
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)false);
        NodePropertiesTools.removeNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Node)Mockito.verify((Object)this.mockNode)).hasProperty("mockPropertyName");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockNode});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockProperty});
    }

    @Test
    public void shouldRemoveASingleValuedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"");
        NodePropertiesTools.removeNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue((Value)null);
    }

    @Test
    public void shouldRemoveAMultiValuedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        Value[] values = new Value[]{this.mockValue};
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)values);
        NodePropertiesTools.removeNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue((Value[])null);
    }

    @Test
    public void shouldRemoveAValueFromMultiValuedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        Value[] values = new Value[]{this.previousValue, this.mockValue};
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)values);
        NodePropertiesTools.removeNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ArgumentCaptor valuesCaptor = ArgumentCaptor.forClass(Value[].class);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue((Value[])valuesCaptor.capture());
        Value[] actualValues = (Value[])valuesCaptor.getValue();
        Assert.assertEquals((long)1L, (long)actualValues.length);
        Assert.assertTrue((String)"removed the wrong value", (boolean)this.previousValue.equals(actualValues[0]));
        Assert.assertTrue((String)"found the value we were removing", (!this.mockValue.equals(actualValues[0]) ? 1 : 0) != 0);
    }

    @Test
    public void shouldRemoveAllMatchingValuesFromAMultivaluedProperty() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockNode.hasProperty("mockPropertyName")).thenReturn((Object)true);
        Value[] values = new Value[]{this.mockValue, this.mockValue};
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)values);
        NodePropertiesTools.removeNodeProperty((Node)this.mockNode, (String)"mockPropertyName", (Value)this.mockValue);
        ((Property)Mockito.verify((Object)this.mockProperty)).setValue((Value[])null);
    }
}

