/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Set;
import org.fcrepo.kernel.utils.impl.ChainingCacheStoreEntry;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.FileCacheStoreConfiguration;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.decorators.ChainingCacheStore;
import org.infinispan.util.TypedProperties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.value.BinaryKey;
import org.modeshape.jcr.value.binary.BinaryStoreException;

public class ChainingCacheStoreEntryTest {
    private static final String DUMMY_CACHE_NAME = "dummy-cache-name";
    @Mock
    private ChainingCacheStore mockStore;
    @Mock
    private BinaryKey mockKey;
    private ChainingCacheStoreEntry testObj;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new ChainingCacheStoreEntry(this.mockStore, DUMMY_CACHE_NAME, this.mockKey);
    }

    @Test
    public void testNullAndUnimplementedMethodImpls() throws BinaryStoreException, IOException {
        try {
            this.testObj.getInputStream();
            Assert.fail((String)"Unexpected completion of ChainingCacheStoreEntry#getInputStream");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            InputStream mockStream = (InputStream)Mockito.mock(InputStream.class);
            this.testObj.storeValue(mockStream);
            Assert.fail((String)"Unexpected completion of ChainingCacheStoreEntry#storeValue");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertNull((String)"Unexpected non-null return from ChainingCacheStoreEntry#getExternalIdentifier", (Object)this.testObj.getExternalIdentifier());
    }

    @Test
    public void testChainedEntries() {
        CacheStore mockChainedFileStore = (CacheStore)Mockito.mock(CacheStore.class);
        CacheStore mockChainedAbstractStore = (CacheStore)Mockito.mock(CacheStore.class);
        CacheStore mockUnknownStore = (CacheStore)Mockito.mock(CacheStore.class);
        FileCacheStoreConfiguration mockFileConfig = (FileCacheStoreConfiguration)Mockito.mock(FileCacheStoreConfiguration.class);
        Mockito.when((Object)mockFileConfig.location()).thenReturn((Object)"/foo/bar");
        AbstractStoreConfiguration mockAbstractConfig = (AbstractStoreConfiguration)Mockito.mock(AbstractStoreConfiguration.class);
        CacheStoreConfiguration mockUnknownConfig = (CacheStoreConfiguration)Mockito.mock(CacheStoreConfiguration.class);
        TypedProperties mockProps = (TypedProperties)Mockito.mock(TypedProperties.class);
        TypedProperties mockNoProps = (TypedProperties)Mockito.mock(TypedProperties.class);
        Mockito.when((Object)mockProps.get((Object)"id")).thenReturn((Object)"dummy-abstract");
        Mockito.when((Object)mockAbstractConfig.properties()).thenReturn((Object)mockProps);
        Mockito.when((Object)mockFileConfig.properties()).thenReturn((Object)mockNoProps);
        Mockito.when((Object)mockUnknownConfig.properties()).thenReturn((Object)mockNoProps);
        LinkedHashMap<CacheStore, Object> mockStores = new LinkedHashMap<CacheStore, Object>(3);
        mockStores.put(mockChainedFileStore, mockFileConfig);
        mockStores.put(mockChainedAbstractStore, mockAbstractConfig);
        mockStores.put(mockUnknownStore, mockUnknownConfig);
        Mockito.when((Object)this.mockStore.getStores()).thenReturn(mockStores);
        Set actual = this.testObj.chainedEntries();
        Assert.assertEquals((long)3L, (long)actual.size());
        ((TypedProperties)Mockito.verify((Object)mockProps)).get((Object)"id");
        ((FileCacheStoreConfiguration)Mockito.verify((Object)mockFileConfig)).location();
        ((TypedProperties)Mockito.verify((Object)mockNoProps, (VerificationMode)Mockito.times((int)0))).get((Object)"id");
    }
}

