/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.UpdateAction;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.VersionHistory;
import org.apache.commons.codec.digest.DigestUtils;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.rdf.GraphProperties;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.rdf.impl.JcrGraphProperties;
import org.fcrepo.kernel.services.ServiceHelpers;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.JcrRdfTools;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraResource
extends JcrTools
implements FedoraJcrTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraResource.class);
    private static final GraphProperties DEFAULT_PROPERTY_FACTORY = new JcrGraphProperties();
    protected Node node;
    private GraphProperties properties;

    public FedoraResource() {
        this.node = null;
        this.properties = DEFAULT_PROPERTY_FACTORY;
    }

    public FedoraResource(Node node) {
        super(false);
        this.node = node;
        this.properties = DEFAULT_PROPERTY_FACTORY;
    }

    public FedoraResource(Session session, String path, String nodeType) throws RepositoryException {
        super(false);
        this.node = this.findOrCreateNode(session, path, "nt:folder", nodeType);
        if (!FedoraResource.hasMixin(this.node)) {
            this.node.addMixin("fedora:resource");
        }
        if (this.node.isNew()) {
            this.node.setProperty("jcr:lastModified", Calendar.getInstance());
        }
        this.properties = DEFAULT_PROPERTY_FACTORY;
    }

    public static boolean hasMixin(Node node) throws RepositoryException {
        return FedoraTypesUtils.isFedoraResource.apply((Object)node);
    }

    public boolean hasContent() throws RepositoryException {
        return this.node.hasNode("jcr:content");
    }

    public Node getNode() {
        return this.node;
    }

    public String getPath() throws RepositoryException {
        return this.node.getPath();
    }

    public Date getCreatedDate() throws RepositoryException {
        if (this.node.hasProperty("jcr:created")) {
            return new Date(this.node.getProperty("jcr:created").getDate().getTimeInMillis());
        }
        LOGGER.info("Node {} does not have a createdDate", (Object)this.node);
        return null;
    }

    public Date getLastModifiedDate() throws RepositoryException {
        if (this.node.hasProperty("jcr:lastModified")) {
            return new Date(this.node.getProperty("jcr:lastModified").getDate().getTimeInMillis());
        }
        LOGGER.info("Could not get last modified date property for node {}", (Object)this.node);
        Date createdDate = this.getCreatedDate();
        if (createdDate != null) {
            LOGGER.info("Using created date for last modified date for node {}", (Object)this.node);
            return createdDate;
        }
        return null;
    }

    public long getSize() throws RepositoryException {
        return ServiceHelpers.getObjectSize(this.node);
    }

    public Collection<String> getModels() throws RepositoryException {
        return FedoraTypesUtils.map(this.node.getMixinNodeTypes(), FedoraTypesUtils.nodetype2name);
    }

    public Dataset updatePropertiesDataset(GraphSubjects subjects, String sparqlUpdateStatement) throws RepositoryException {
        Dataset dataset = this.getPropertiesDataset(subjects, 0L, 0);
        UpdateRequest request = UpdateFactory.create((String)sparqlUpdateStatement, (String)dataset.getContext().getAsString(GraphProperties.URI_SYMBOL));
        dataset.getDefaultModel().setNsPrefixes(request.getPrefixMapping());
        UpdateAction.execute((UpdateRequest)request, (Dataset)dataset);
        return dataset;
    }

    public Dataset getPropertiesDataset(GraphSubjects subjects, long offset, int limit) throws RepositoryException {
        if (this.properties != null) {
            return this.properties.getProperties(this.node, subjects, offset, limit);
        }
        return null;
    }

    public Dataset getPropertiesDataset(GraphSubjects subjects) throws RepositoryException {
        return this.getPropertiesDataset(subjects, 0L, -1);
    }

    public Dataset getVersionDataset(GraphSubjects subjects) throws RepositoryException {
        Model model = JcrRdfTools.withContext(subjects, this.node.getSession()).getJcrPropertiesModel(FedoraTypesUtils.getVersionHistory(this.node), subjects.getGraphSubject(this.node));
        Dataset dataset = DatasetFactory.create((Model)model);
        String uri = subjects.getGraphSubject(this.node).getURI();
        Context context = dataset.getContext();
        context.set(GraphProperties.URI_SYMBOL, (Object)uri);
        return dataset;
    }

    public void addVersionLabel(String label) throws RepositoryException {
        VersionHistory versionHistory = FedoraTypesUtils.getVersionHistory(this.node);
        versionHistory.addVersionLabel(FedoraTypesUtils.getBaseVersion(this.node).getName(), label, true);
    }

    public boolean isNew() {
        return this.node.isNew();
    }

    public Dataset replacePropertiesDataset(GraphSubjects subjects, Model inputModel) throws RepositoryException {
        Dataset propertiesDataset = this.getPropertiesDataset(subjects, 0L, -2);
        Model model = propertiesDataset.getDefaultModel();
        Model removed = model.difference(inputModel);
        model.remove(removed.listStatements());
        Model created = inputModel.difference(model);
        model.add(created.listStatements());
        return propertiesDataset;
    }

    public String getEtagValue() throws RepositoryException {
        Date lastModifiedDate = this.getLastModifiedDate();
        if (lastModifiedDate != null) {
            return DigestUtils.shaHex((String)(this.node.getPath() + lastModifiedDate.toString()));
        }
        return "";
    }
}

