/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.google.common.base.Throwables;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.observer.EventFilter;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.modeshape.jcr.api.Repository;

public class DefaultFilter
implements EventFilter {
    @Inject
    private Repository repository;
    private Session session;

    public boolean apply(Event event) {
        try {
            Item item = this.session.getItem(event.getPath());
            Node n = item.isNode() ? (Node)item : item.getParent();
            return FedoraTypesUtils.isFedoraObject.apply((Object)n) || FedoraTypesUtils.isFedoraDatastream.apply((Object)n);
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @PostConstruct
    public void acquireSession() throws RepositoryException {
        this.session = this.repository.login();
    }

    @PreDestroy
    public void releaseSession() {
        this.session.logout();
    }
}

