/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.observer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.EventBus;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventListener;
import org.fcrepo.kernel.observer.EventFilter;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.fcrepo.kernel.utils.EventIterator;
import org.fcrepo.metrics.RegistryService;
import org.modeshape.jcr.api.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleObserver
implements EventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleObserver.class);
    static final Counter EVENT_COUNTER = RegistryService.getMetrics().counter(MetricRegistry.name(SimpleObserver.class, (String[])new String[]{"onEvent"}));
    static final Integer EVENT_TYPES = 63;
    @Inject
    private Repository repository;
    @Inject
    private EventBus eventBus;
    @Inject
    private EventFilter eventFilter;
    private Session session;

    @PostConstruct
    public void buildListener() throws RepositoryException {
        this.session = this.repository.login();
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, EVENT_TYPES.intValue(), "/", true, null, null, false);
        this.session.save();
    }

    public void onEvent(javax.jcr.observation.EventIterator events) {
        HashSet<Node> posted = new HashSet<Node>();
        for (Event e : Iterables.filter((Iterable)new EventIterator(events), (Predicate)this.eventFilter)) {
            try {
                Item item = this.session.getItem(e.getPath());
                Node n = null;
                n = item.isNode() ? (Node)item : item.getParent();
                if (n != null && !posted.contains(n)) {
                    EVENT_COUNTER.inc();
                    LOGGER.debug("Putting event: " + e.toString() + " on the bus.");
                    this.eventBus.post((Object)new FedoraEvent(e));
                    posted.add(n);
                    continue;
                }
                LOGGER.debug("Skipping: " + e);
            }
            catch (PathNotFoundException ex) {
                LOGGER.trace("Not a node in the Fedora workspace: " + e);
            }
            catch (RepositoryException ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        }
    }
}

