/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializationUtils {
    private static final Logger logger = LoggerFactory.getLogger(SerializationUtils.class);
    public static final Symbol subjectKey = Symbol.create((String)"uri");

    private SerializationUtils() {
        throw new AssertionError((Object)(this.getClass().getName() + " is a helper class which should never be instantiated!"));
    }

    public static void setDatasetSubject(Dataset rdf, String uri) {
        Context context = rdf.getContext();
        context.set(subjectKey, (Object)uri);
    }

    public static Node getDatasetSubject(Dataset rdf) {
        Context context = rdf.getContext();
        String uri = context.getAsString(subjectKey);
        logger.debug("uri from context: {}", (Object)uri);
        if (uri != null) {
            return NodeFactory.createURI((String)uri);
        }
        return null;
    }

    public static Model unifyDatasetModel(Dataset dataset) {
        Iterator iterator = dataset.listNames();
        Model model = ModelFactory.createDefaultModel();
        model = model.union(dataset.getDefaultModel());
        while (iterator.hasNext()) {
            String modelName = (String)iterator.next();
            logger.debug("Serializing model {}", (Object)modelName);
            model = model.union(dataset.getNamedModel(modelName));
        }
        model.setNsPrefixes(dataset.getDefaultModel().getNsPrefixMap());
        return model;
    }
}

