/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.google.common.base.Preconditions;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.rdf.GraphSubjects;

public class DefaultGraphSubjects
implements GraphSubjects {
    private final Resource context;
    private final Session session;

    public DefaultGraphSubjects(Session session) {
        this.session = session;
        this.context = ResourceFactory.createResource();
    }

    @Override
    public Resource getGraphSubject(String absPath) throws RepositoryException {
        if (absPath.endsWith("jcr:content")) {
            return ResourceFactory.createResource((String)("http://fedora.info/definitions/v4/rest-api#" + absPath.replace("jcr:content", "fcr:content")));
        }
        return ResourceFactory.createResource((String)("http://fedora.info/definitions/v4/rest-api#" + absPath));
    }

    @Override
    public Resource getContext() {
        return this.context;
    }

    @Override
    public Resource getGraphSubject(Node node) throws RepositoryException {
        return this.getGraphSubject(node.getPath());
    }

    @Override
    public Node getNodeFromGraphSubject(Resource subject) throws RepositoryException {
        if (!this.isFedoraGraphSubject(subject)) {
            return null;
        }
        String absPath = subject.getURI().substring("http://fedora.info/definitions/v4/rest-api#".length());
        if (absPath.endsWith("fcr:content")) {
            return this.session.getNode(absPath.replace("fcr:content", "jcr:content"));
        }
        if (this.session.nodeExists(absPath)) {
            return this.session.getNode(absPath);
        }
        return null;
    }

    @Override
    public boolean isFedoraGraphSubject(Resource subject) {
        Preconditions.checkArgument((subject != null ? 1 : 0) != 0, (Object)"null cannot be a Fedora object!");
        assert (subject != null);
        return subject.isURIResource() && subject.getURI().startsWith("http://fedora.info/definitions/v4/rest-api#");
    }
}

