/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.rdf.impl;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.util.Context;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.rdf.GraphProperties;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.utils.JcrPropertyStatementListener;
import org.fcrepo.kernel.utils.JcrRdfTools;

public class JcrGraphProperties
implements GraphProperties {
    private static final String MODEL_NAME = "tree";

    @Override
    public String getPropertyModelName() {
        return MODEL_NAME;
    }

    @Override
    public Dataset getProperties(Node node, GraphSubjects subjects, long offset, int limit) throws RepositoryException {
        JcrRdfTools jcrRdfTools = JcrRdfTools.withContext(subjects, node.getSession());
        Model model = jcrRdfTools.getJcrPropertiesModel(node);
        Model treeModel = jcrRdfTools.getJcrTreeModel(node, offset, limit);
        Model problemModel = JcrRdfTools.getProblemsModel();
        JcrPropertyStatementListener listener = JcrPropertyStatementListener.getListener(subjects, node.getSession(), problemModel);
        model.register((ModelChangedListener)listener);
        treeModel.register((ModelChangedListener)listener);
        Dataset dataset = DatasetFactory.create((Model)model);
        dataset.addNamedModel(MODEL_NAME, treeModel);
        Resource subject = subjects.getGraphSubject(node);
        String uri = subject.getURI();
        Context context = dataset.getContext();
        context.set(URI_SYMBOL, (Object)uri);
        context.set(INLINED_RESOURCES_MODEL, (Object)MODEL_NAME);
        dataset.addNamedModel("problems", problemModel);
        return dataset;
    }

    @Override
    public Dataset getProperties(Node node, GraphSubjects subjects) throws RepositoryException {
        return this.getProperties(node, subjects, 0L, -1);
    }
}

