/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.GraphStoreFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.Datastream;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.rdf.GraphProperties;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.services.RepositoryService;
import org.fcrepo.kernel.services.ServiceHelpers;
import org.fcrepo.kernel.services.policy.StoragePolicyDecisionPoint;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.JcrRdfTools;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.fcrepo.metrics.RegistryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DatastreamService
extends RepositoryService {
    @Autowired(required=false)
    StoragePolicyDecisionPoint storagePolicyDecisionPoint;
    @Autowired
    private LowLevelStorageService llStoreService;
    static final Counter fixityCheckCounter = RegistryService.getMetrics().counter(MetricRegistry.name(LowLevelStorageService.class, (String[])new String[]{"fixity-check-counter"}));
    static final Timer timer = RegistryService.getMetrics().timer(MetricRegistry.name(Datastream.class, (String[])new String[]{"fixity-check-time"}));
    static final Counter fixityRepairedCounter = RegistryService.getMetrics().counter(MetricRegistry.name(LowLevelStorageService.class, (String[])new String[]{"fixity-repaired-counter"}));
    static final Counter fixityErrorCounter = RegistryService.getMetrics().counter(MetricRegistry.name(LowLevelStorageService.class, (String[])new String[]{"fixity-error-counter"}));
    private static final Logger logger = LoggerFactory.getLogger(DatastreamService.class);

    public Datastream createDatastream(Session session, String dsPath) throws RepositoryException {
        return new Datastream(session, dsPath);
    }

    public Node createDatastreamNode(Session session, String dsPath, String contentType, InputStream requestBodyStream) throws RepositoryException, IOException, InvalidChecksumException {
        return this.createDatastreamNode(session, dsPath, contentType, requestBodyStream, null);
    }

    public Node createDatastreamNode(Session session, String dsPath, String contentType, InputStream requestBodyStream, URI checksum) throws RepositoryException, IOException, InvalidChecksumException {
        Datastream ds = this.createDatastream(session, dsPath);
        ds.setContent(requestBodyStream, contentType, checksum, this.getStoragePolicyDecisionPoint());
        return ds.getNode();
    }

    public Node getDatastreamNode(Session session, String path) throws RepositoryException {
        logger.trace("Executing getDatastreamNode() with path: {}", (Object)path);
        Node dsNode = this.getDatastream(session, path).getNode();
        logger.trace("Retrieved datastream node: {}", (Object)dsNode.getName());
        return dsNode;
    }

    public Datastream getDatastream(Session session, String path) throws RepositoryException {
        return new Datastream(session, path);
    }

    public Datastream asDatastream(Node node) throws RepositoryException {
        return new Datastream(node);
    }

    public Dataset getFixityResultsModel(GraphSubjects subjects, Datastream datastream) throws RepositoryException {
        Collection<FixityResult> blobs = this.runFixityAndFixProblems(datastream);
        Model model = JcrRdfTools.withContext(subjects, datastream.getNode().getSession()).getJcrPropertiesModel(datastream.getNode(), blobs);
        Dataset dataset = GraphStoreFactory.create((Model)model).toDataset();
        String uri = subjects.getGraphSubject(datastream.getNode()).getURI();
        Context context = dataset.getContext();
        context.set(GraphProperties.URI_SYMBOL, (Object)uri);
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<FixityResult> runFixityAndFixProblems(Datastream datastream) throws RepositoryException {
        ImmutableSet goodEntries;
        ImmutableSet fixityResults;
        final URI digestUri = datastream.getContentDigest();
        final long size = datastream.getContentSize();
        fixityCheckCounter.inc();
        Timer.Context context = timer.time();
        try {
            fixityResults = ImmutableSet.copyOf(this.getFixity(datastream.getNode().getNode("jcr:content"), digestUri, size));
            goodEntries = ImmutableSet.copyOf((Collection)Collections2.filter((Collection)fixityResults, (Predicate)new Predicate<FixityResult>(){

                public boolean apply(FixityResult input) {
                    return input.matches(size, digestUri);
                }
            }));
        }
        finally {
            context.stop();
        }
        if (goodEntries.size() == 0) {
            logger.error("ALL COPIES OF " + datastream.getNode().getPath() + " HAVE FAILED FIXITY CHECKS.");
            return fixityResults;
        }
        LowLevelCacheEntry anyGoodCacheEntry = ((FixityResult)goodEntries.iterator().next()).getEntry();
        Sets.SetView badEntries = Sets.difference((Set)fixityResults, (Set)goodEntries);
        for (FixityResult result : badEntries) {
            try {
                result.getEntry().storeValue(anyGoodCacheEntry.getInputStream());
                FixityResult newResult = result.getEntry().checkFixity(digestUri, size);
                if (newResult.isSuccess()) {
                    result.setRepaired();
                    fixityRepairedCounter.inc();
                    continue;
                }
                fixityErrorCounter.inc();
            }
            catch (IOException e) {
                logger.warn("Exception repairing low-level cache entry: {}", (Throwable)e);
            }
        }
        return fixityResults;
    }

    public Collection<FixityResult> getFixity(Node resource, URI dsChecksum, long dsSize) throws RepositoryException {
        logger.debug("Checking resource: " + resource.getPath());
        Function<LowLevelCacheEntry, FixityResult> checkCacheFunc = ServiceHelpers.getCheckCacheFixityFunction(dsChecksum, dsSize);
        return this.llStoreService.transformLowLevelCacheEntries(resource, checkCacheFunc);
    }

    public void setLlStoreService(LowLevelStorageService llStoreService) {
        this.llStoreService = llStoreService;
    }

    public void setStoragePolicyDecisionPoint(StoragePolicyDecisionPoint pdp) {
        this.storagePolicyDecisionPoint = pdp;
    }

    private StoragePolicyDecisionPoint getStoragePolicyDecisionPoint() {
        if (this.storagePolicyDecisionPoint == null) {
            logger.debug("Using new PolicyDecisionPoint.");
        }
        return this.storagePolicyDecisionPoint;
    }
}

