/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelChangedListener;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.util.Context;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.Source;
import javax.jcr.query.qom.StaticOperand;
import org.fcrepo.jcr.FedoraJcrTypes;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.rdf.GraphProperties;
import org.fcrepo.kernel.rdf.GraphSubjects;
import org.fcrepo.kernel.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.JcrRdfTools;
import org.fcrepo.kernel.utils.NamespaceChangedStatementListener;
import org.fcrepo.kernel.utils.NamespaceTools;
import org.fcrepo.metrics.RegistryService;
import org.modeshape.jcr.api.JcrTools;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.modeshape.jcr.api.Problems;
import org.modeshape.jcr.api.RepositoryManager;
import org.modeshape.jcr.api.Session;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RepositoryService
extends JcrTools
implements FedoraJcrTypes {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryService.class);
    private final Timer objectSizeCalculationTimer = RegistryService.getMetrics().timer(MetricRegistry.name(RepositoryService.class, (String[])new String[]{"objectSizeCalculation"}));
    @Inject
    protected Repository repo;

    public boolean exists(javax.jcr.Session session, String path) throws RepositoryException {
        return session.nodeExists(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getRepositorySize() {
        Long l;
        Timer.Context context = this.objectSizeCalculationTimer.time();
        logger.info("Calculating repository size from index");
        try {
            l = FedoraTypesUtils.getRepositorySize(this.repo);
        }
        catch (Throwable throwable) {
            try {
                context.stop();
                throw throwable;
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        context.stop();
        return l;
    }

    public Long getRepositoryObjectCount() {
        try {
            return FedoraTypesUtils.getRepositoryCount(this.repo);
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public NodeTypeIterator getAllNodeTypes(javax.jcr.Session session) throws RepositoryException {
        NodeTypeManager ntmanager = (NodeTypeManager)session.getWorkspace().getNodeTypeManager();
        return ntmanager.getAllNodeTypes();
    }

    public static Map<String, String> getRepositoryNamespaces(javax.jcr.Session session) throws RepositoryException {
        NamespaceRegistry reg = NamespaceTools.getNamespaceRegistry(session);
        return Maps.asMap((Set)Sets.newHashSet((Object[])reg.getPrefixes()), (Function)new Function<String, String>((javax.jcr.NamespaceRegistry)reg){
            final /* synthetic */ javax.jcr.NamespaceRegistry val$reg;
            {
                this.val$reg = namespaceRegistry;
            }

            public String apply(String p) {
                try {
                    return this.val$reg.getURI(p);
                }
                catch (RepositoryException e) {
                    Throwables.propagate((Throwable)e);
                    return null;
                }
            }
        });
    }

    public Dataset getNamespaceRegistryGraph(javax.jcr.Session session) throws RepositoryException {
        Model model = JcrRdfTools.withContext(null, session).getJcrNamespaceModel();
        model.register((ModelChangedListener)new NamespaceChangedStatementListener(session));
        Dataset dataset = DatasetFactory.create((Model)model);
        return dataset;
    }

    public Dataset searchRepository(GraphSubjects subjectFactory, Resource searchSubject, javax.jcr.Session session, String terms, int limit, long offset) throws RepositoryException {
        Model model;
        if (terms != null) {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            QueryObjectModelFactory factory = queryManager.getQOMFactory();
            Selector selector = factory.selector("fedora:resource", "resourcesSelector");
            FullTextSearch constraints = factory.fullTextSearch("resourcesSelector", null, (StaticOperand)factory.literal(session.getValueFactory().createValue(terms)));
            QueryObjectModel query = factory.createQuery((Source)selector, (Constraint)constraints, null, null);
            query.setLimit((long)(limit + 1));
            query.setOffset(offset);
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            long size = nodeIterator.getSize();
            Iterator limitedIterator = Iterators.limit((Iterator)new org.fcrepo.kernel.utils.NodeIterator(nodeIterator), (int)limit);
            model = JcrRdfTools.withContext(subjectFactory, session).getJcrPropertiesModel(limitedIterator, searchSubject);
            model.add(searchSubject, RdfLexicon.SEARCH_HAS_TOTAL_RESULTS, (RDFNode)model.createTypedLiteral(size));
            model.add(searchSubject, RdfLexicon.SEARCH_HAS_MORE, (RDFNode)model.createTypedLiteral(nodeIterator.hasNext()));
        } else {
            model = ModelFactory.createDefaultModel();
        }
        Dataset dataset = DatasetFactory.create((Model)model);
        String uri = searchSubject.getURI();
        Context context = dataset.getContext() != null ? dataset.getContext() : new Context();
        context.set(GraphProperties.URI_SYMBOL, (Object)uri);
        return dataset;
    }

    public Problems backupRepository(javax.jcr.Session session, File backupDirectory) throws RepositoryException {
        RepositoryManager repoMgr = ((Session)session).getWorkspace().getRepositoryManager();
        Problems problems = repoMgr.backupRepository(backupDirectory);
        return problems;
    }

    public Problems restoreRepository(javax.jcr.Session session, File backupDirectory) throws RepositoryException {
        RepositoryManager repoMgr = ((Session)session).getWorkspace().getRepositoryManager();
        Problems problems = repoMgr.restoreRepository(backupDirectory);
        return problems;
    }

    public void setRepository(Repository repository) {
        this.repo = repository;
    }
}

