/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.services.functions;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import java.io.Serializable;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.fcrepo.kernel.services.LowLevelStorageService;
import org.fcrepo.kernel.utils.ContentDigest;
import org.fcrepo.kernel.utils.FixityResult;
import org.fcrepo.kernel.utils.LowLevelCacheEntry;
import org.modeshape.jcr.value.binary.BinaryStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckCacheEntryFixity
implements Function<LowLevelCacheEntry, FixityResult>,
Serializable {
    private static final long serialVersionUID = 4701589005571818110L;
    private static final Logger logger = LoggerFactory.getLogger(LowLevelStorageService.class);
    private final URI dsChecksum;
    private final long dsSize;

    public CheckCacheEntryFixity(URI dsChecksum, long dsSize) {
        this.dsChecksum = dsChecksum;
        this.dsSize = dsSize;
    }

    public FixityResult apply(LowLevelCacheEntry input) {
        logger.debug("Checking fixity for resource in cache store " + input.toString());
        FixityResult result = null;
        try {
            result = input.checkFixity(this.dsChecksum, this.dsSize);
        }
        catch (BinaryStoreException e) {
            logger.error("Exception checking low-level fixity: {}", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        return result;
    }

    public MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance(ContentDigest.getAlgorithm(this.dsChecksum));
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public URI getChecksum() {
        return this.dsChecksum;
    }

    public long getSize() {
        return this.dsSize;
    }
}

