/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentDigest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentDigest.class);
    public static final Map<String, String> algorithmToScheme = ImmutableMap.of((Object)"SHA-1", (Object)"urn:sha1", (Object)"SHA1", (Object)"urn:sha1");
    public static final Map<String, String> schemeToAlgorithm = ImmutableMap.of((Object)"urn:sha1", (Object)"SHA-1");

    public static URI asURI(String algorithm, String value) {
        try {
            String scheme = algorithmToScheme.get(algorithm);
            return new URI(scheme, value, null);
        }
        catch (URISyntaxException unlikelyException) {
            LOGGER.warn("Exception creating checksum URI: {}", (Throwable)unlikelyException);
            throw Throwables.propagate((Throwable)unlikelyException);
        }
    }

    public static URI asURI(String algorithm, byte[] data) {
        return ContentDigest.asURI(algorithm, ContentDigest.asString(data));
    }

    public static String getAlgorithm(URI digestUri) {
        return schemeToAlgorithm.get(digestUri.getScheme() + ":" + digestUri.getSchemeSpecificPart().split(":", 2)[0]);
    }

    private static String asString(byte[] data) {
        return Hex.encodeHexString((byte[])data);
    }
}

