/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

public enum EventType {
    NODE_ADDED,
    NODE_REMOVED,
    PROPERTY_ADDED,
    PROPERTY_REMOVED,
    PROPERTY_CHANGED,
    NODE_MOVED,
    PERSIST;


    public static EventType getEventType(Integer i) {
        switch (i) {
            case 1: {
                return NODE_ADDED;
            }
            case 2: {
                return NODE_REMOVED;
            }
            case 4: {
                return PROPERTY_ADDED;
            }
            case 8: {
                return PROPERTY_REMOVED;
            }
            case 16: {
                return PROPERTY_CHANGED;
            }
            case 32: {
                return NODE_MOVED;
            }
            case 64: {
                return PERSIST;
            }
        }
        throw new IllegalArgumentException("Invalid JCR event type: " + i);
    }

    public static String getEventName(Integer jcrEvent) {
        switch (EventType.getEventType(jcrEvent)) {
            case NODE_ADDED: {
                return "node added";
            }
            case NODE_REMOVED: {
                return "node removed";
            }
            case PROPERTY_ADDED: {
                return "property added";
            }
            case PROPERTY_CHANGED: {
                return "property changed";
            }
            case PROPERTY_REMOVED: {
                return "property removed";
            }
            case NODE_MOVED: {
                return "node moved";
            }
            case PERSIST: {
                return "persist";
            }
        }
        throw new IllegalArgumentException("Invalid JCR event type: " + jcrEvent);
    }
}

