/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.utils;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.io.InputStream;
import java.util.Collection;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.fcrepo.kernel.utils.JcrRdfTools;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.modeshape.jcr.JcrValueFactory;
import org.modeshape.jcr.api.Namespaced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FedoraTypesUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(FedoraTypesUtils.class);
    public static Predicate<Node> isFedoraResource = new Predicate<Node>(){

        public boolean apply(Node node) {
            Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)"null cannot be a Fedora object!");
            try {
                return FedoraTypesUtils.map(node.getMixinNodeTypes(), nodetype2name).contains("fedora:resource");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Node> isFedoraObject = new Predicate<Node>(){

        public boolean apply(Node node) {
            Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)"null cannot be a Fedora object!");
            try {
                return FedoraTypesUtils.map(node.getMixinNodeTypes(), nodetype2name).contains("fedora:object");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Node> isFedoraDatastream = new Predicate<Node>(){

        public boolean apply(Node node) {
            Preconditions.checkArgument((node != null ? 1 : 0) != 0, (Object)"null cannot be a Fedora datastream!");
            try {
                return FedoraTypesUtils.map(node.getMixinNodeTypes(), nodetype2name).contains("fedora:datastream");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Function<NodeType, String> nodetype2name = new Function<NodeType, String>(){

        public String apply(NodeType t) {
            Preconditions.checkArgument((t != null ? 1 : 0) != 0, (Object)"null has no name!");
            return t.getName();
        }
    };
    public static Function<Value, String> value2string = new Function<Value, String>(){

        public String apply(Value v) {
            try {
                Preconditions.checkArgument((v != null ? 1 : 0) != 0, (Object)"null has no appropriate String representation!");
                return v.getString();
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Property> isMultipleValuedProperty = new Predicate<Property>(){

        public boolean apply(Property p) {
            Preconditions.checkArgument((p != null ? 1 : 0) != 0, (Object)"null is neither multiple or not multiple!");
            try {
                return p.isMultiple();
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Predicate<Node> isInternalNode = new Predicate<Node>(){

        public boolean apply(Node n) {
            Preconditions.checkArgument((n != null ? 1 : 0) != 0, (Object)"null is neither multiple or not multiple!");
            try {
                NodeType primaryNodeType = n.getPrimaryNodeType();
                return primaryNodeType != null && primaryNodeType.isNodeType("mode:system");
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Function<Node, ValueFactory> getValueFactory = new Function<Node, ValueFactory>(){

        public ValueFactory apply(Node n) {
            try {
                Preconditions.checkArgument((n != null ? 1 : 0) != 0, (Object)"null has no ValueFactory associated with it!");
                return n.getSession().getValueFactory();
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    public static Function<Property, com.hp.hpl.jena.rdf.model.Property> getPredicateForProperty = new Function<Property, com.hp.hpl.jena.rdf.model.Property>(){

        public com.hp.hpl.jena.rdf.model.Property apply(Property property) {
            LOGGER.trace("Creating predicate for property: {}", (Object)property);
            try {
                if (property instanceof Namespaced) {
                    Namespaced nsProperty = (Namespaced)property;
                    String uri = nsProperty.getNamespaceURI();
                    return ResourceFactory.createProperty((String)JcrRdfTools.getRDFNamespaceForJcrNamespace(uri), (String)nsProperty.getLocalName());
                }
                return ResourceFactory.createProperty((String)property.getName());
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    };
    private static final DateTimeFormatter FMT = ISODateTimeFormat.dateTime();

    public static Binary getBinary(Node n, InputStream i) {
        try {
            Preconditions.checkArgument((n != null ? 1 : 0) != 0, (Object)"null cannot have a Binary created for it!");
            Preconditions.checkArgument((i != null ? 1 : 0) != 0, (Object)"null cannot have a Binary created from it!");
            return n.getSession().getValueFactory().createBinary(i);
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Binary getBinary(Node n, InputStream i, String hint) {
        try {
            Preconditions.checkArgument((n != null ? 1 : 0) != 0, (Object)"null cannot have a Binary created for it!");
            Preconditions.checkArgument((i != null ? 1 : 0) != 0, (Object)"null cannot have a Binary created from it!");
            JcrValueFactory jcrValueFactory = (JcrValueFactory)n.getSession().getValueFactory();
            return jcrValueFactory.createBinary(i, hint);
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static NodeTypeManager getNodeTypeManager(Node node) throws RepositoryException {
        return node.getSession().getWorkspace().getNodeTypeManager();
    }

    public static PropertyDefinition getDefinitionForPropertyName(Node node, String propertyName) throws RepositoryException {
        PropertyDefinition[] propertyDefinitions;
        for (PropertyDefinition p : propertyDefinitions = FedoraTypesUtils.getNodeTypeManager(node).getNodeType("fedora:resource").getPropertyDefinitions()) {
            if (!p.getName().equals(propertyName)) continue;
            return p;
        }
        return null;
    }

    public static <F, T> Collection<T> map(F[] input, Function<F, T> f) {
        return Collections2.transform((Collection)ImmutableSet.copyOf((Object[])input), f);
    }

    public static String convertDateToXSDString(long date) {
        DateTime dt = new DateTime(date, DateTimeZone.UTC);
        return FMT.print((ReadableInstant)dt);
    }

    public static Version getBaseVersion(Node node) throws RepositoryException {
        return node.getSession().getWorkspace().getVersionManager().getBaseVersion(node.getPath());
    }

    public static VersionHistory getVersionHistory(Node node) throws RepositoryException {
        return FedoraTypesUtils.getVersionHistory(node.getSession(), node.getPath());
    }

    public static VersionHistory getVersionHistory(Session session, String path) throws RepositoryException {
        return session.getWorkspace().getVersionManager().getVersionHistory(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRepositoryCount(Repository repository) throws RepositoryException {
        Session session = repository.login();
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String querystring = "SELECT [jcr:path] FROM [fedora:object]";
            QueryResult queryResults = queryManager.createQuery("SELECT [jcr:path] FROM [fedora:object]", "JCR-SQL2").execute();
            long l = queryResults.getRows().getSize();
            return l;
        }
        finally {
            session.logout();
        }
    }

    public static long getRepositorySize(Repository repository) throws RepositoryException {
        Session session = repository.login();
        long sum = 0L;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String querystring = "SELECT [fedora:size] FROM [fedora:binary]";
        QueryResult queryResults = queryManager.createQuery("SELECT [fedora:size] FROM [fedora:binary]", "JCR-SQL2").execute();
        RowIterator rows = queryResults.getRows();
        while (rows.hasNext()) {
            Value value = rows.nextRow().getValue("fedora:size");
            sum += value.getLong();
        }
        session.logout();
        return sum;
    }
}

